/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs;

import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.Paths;

public class CryptoFileSystemUri {
    public static final String URI_SCHEME = "cryptomator";
    private final Path pathToVault;
    private final String pathInsideVault;

    private CryptoFileSystemUri(URI uRI) {
        CryptoFileSystemUri.validate(uRI);
        this.pathToVault = Paths.get(URI.create(uRI.getAuthority()));
        this.pathInsideVault = uRI.getPath();
    }

    public static URI create(Path path, String ... stringArray) {
        try {
            return new URI(URI_SCHEME, path.toUri().toString(), "/" + String.join((CharSequence)"/", stringArray), null, null);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalArgumentException("Can not create URI from given input", uRISyntaxException);
        }
    }

    static CryptoFileSystemUri parse(URI uRI) throws IllegalArgumentException {
        return new CryptoFileSystemUri(uRI);
    }

    private static void validate(URI uRI) {
        if (!URI_SCHEME.equals(uRI.getScheme())) {
            throw new IllegalArgumentException("URI must have cryptomator scheme");
        }
        if (uRI.getAuthority() == null) {
            throw new IllegalArgumentException("URI must have an authority");
        }
        if (uRI.getPath() == null || uRI.getPath().isEmpty()) {
            throw new IllegalArgumentException("URI must have a path");
        }
        if (uRI.getQuery() != null) {
            throw new IllegalArgumentException("URI must not have a query part");
        }
        if (uRI.getFragment() != null) {
            throw new IllegalArgumentException("URI must not have a fragment part");
        }
    }

    public Path pathToVault() {
        return this.pathToVault;
    }

    public String pathInsideVault() {
        return this.pathInsideVault;
    }
}

