/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs;

import com.google.common.base.Strings;
import java.text.Normalizer;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;

public class CryptoFileSystemProperties
extends AbstractMap<String, Object> {
    public static final String PROPERTY_PASSPHRASE = "passphrase";
    public static final String PROPERTY_PEPPER = "pepper";
    static final byte[] DEFAULT_PEPPER = new byte[0];
    public static final String PROPERTY_MASTERKEY_FILENAME = "masterkeyFilename";
    static final String DEFAULT_MASTERKEY_FILENAME = "masterkey.cryptomator";
    public static final String PROPERTY_FILESYSTEM_FLAGS = "flags";
    static final Set<FileSystemFlags> DEFAULT_FILESYSTEM_FLAGS = Collections.unmodifiableSet(EnumSet.of(FileSystemFlags.MIGRATE_IMPLICITLY, FileSystemFlags.INIT_IMPLICITLY));
    private final Set<Map.Entry<String, Object>> entries;

    private CryptoFileSystemProperties(Builder builder) {
        this.entries = Collections.unmodifiableSet(new HashSet<Map.Entry>(Arrays.asList(CryptoFileSystemProperties.entry(PROPERTY_PASSPHRASE, builder.passphrase), CryptoFileSystemProperties.entry(PROPERTY_PEPPER, builder.pepper), CryptoFileSystemProperties.entry(PROPERTY_FILESYSTEM_FLAGS, builder.flags), CryptoFileSystemProperties.entry(PROPERTY_MASTERKEY_FILENAME, builder.masterkeyFilename))));
    }

    CharSequence passphrase() {
        return (CharSequence)this.get(PROPERTY_PASSPHRASE);
    }

    byte[] pepper() {
        return (byte[])this.get(PROPERTY_PEPPER);
    }

    Set<FileSystemFlags> flags() {
        return (Set)this.get(PROPERTY_FILESYSTEM_FLAGS);
    }

    boolean readonly() {
        return this.flags().contains((Object)FileSystemFlags.READONLY);
    }

    boolean migrateImplicitly() {
        return this.flags().contains((Object)FileSystemFlags.MIGRATE_IMPLICITLY);
    }

    boolean initializeImplicitly() {
        return this.flags().contains((Object)FileSystemFlags.INIT_IMPLICITLY);
    }

    String masterkeyFilename() {
        return (String)this.get(PROPERTY_MASTERKEY_FILENAME);
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.entries;
    }

    private static Map.Entry<String, Object> entry(final String string, final Object object) {
        return new Map.Entry<String, Object>(){

            @Override
            public String getKey() {
                return string;
            }

            @Override
            public Object getValue() {
                return object;
            }

            @Override
            public Object setValue(Object object2) {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static Builder cryptoFileSystemProperties() {
        return new Builder();
    }

    public static Builder withPassphrase(CharSequence charSequence) {
        return new Builder().withPassphrase(charSequence);
    }

    public static Builder cryptoFileSystemPropertiesFrom(Map<String, ?> map) {
        return new Builder(map);
    }

    public static CryptoFileSystemProperties wrap(Map<String, ?> map) {
        if (map instanceof CryptoFileSystemProperties) {
            return (CryptoFileSystemProperties)map;
        }
        try {
            return CryptoFileSystemProperties.cryptoFileSystemPropertiesFrom(map).build();
        }
        catch (IllegalStateException illegalStateException) {
            throw new IllegalArgumentException(illegalStateException);
        }
    }

    public static class Builder {
        private CharSequence passphrase;
        public byte[] pepper = DEFAULT_PEPPER;
        private final Set<FileSystemFlags> flags = EnumSet.copyOf(DEFAULT_FILESYSTEM_FLAGS);
        private String masterkeyFilename = "masterkey.cryptomator";

        private Builder() {
        }

        private Builder(Map<String, ?> map) {
            this.checkedSet(CharSequence.class, CryptoFileSystemProperties.PROPERTY_PASSPHRASE, map, this::withPassphrase);
            this.checkedSet(byte[].class, CryptoFileSystemProperties.PROPERTY_PEPPER, map, this::withPepper);
            this.checkedSet(String.class, CryptoFileSystemProperties.PROPERTY_MASTERKEY_FILENAME, map, this::withMasterkeyFilename);
            this.checkedSet(Set.class, CryptoFileSystemProperties.PROPERTY_FILESYSTEM_FLAGS, map, this::withFlags);
        }

        private <T> void checkedSet(Class<T> clazz, String string, Map<String, ?> map, Consumer<T> consumer) {
            Object obj = map.get(string);
            if (obj == null) {
                return;
            }
            if (!clazz.isInstance(obj)) {
                throw new IllegalArgumentException(string + " must be of type " + clazz.getSimpleName());
            }
            consumer.accept(clazz.cast(obj));
        }

        public Builder withPassphrase(CharSequence charSequence) {
            this.passphrase = Normalizer.normalize(charSequence, Normalizer.Form.NFC);
            return this;
        }

        public Builder withPepper(byte[] byArray) {
            this.pepper = byArray;
            return this;
        }

        public Builder withFlags(FileSystemFlags ... fileSystemFlagsArray) {
            return this.withFlags(Arrays.asList(fileSystemFlagsArray));
        }

        public Builder withFlags(Collection<FileSystemFlags> collection) {
            this.flags.clear();
            this.flags.addAll(collection);
            return this;
        }

        @Deprecated
        public Builder withReadonlyFlag() {
            this.flags.add(FileSystemFlags.READONLY);
            return this;
        }

        public Builder withMasterkeyFilename(String string) {
            this.masterkeyFilename = string;
            return this;
        }

        public CryptoFileSystemProperties build() {
            this.validate();
            return new CryptoFileSystemProperties(this);
        }

        private void validate() {
            if (this.passphrase == null) {
                throw new IllegalStateException("passphrase is required");
            }
            if (Strings.nullToEmpty(this.masterkeyFilename).trim().isEmpty()) {
                throw new IllegalStateException("masterkeyFilename is required");
            }
        }
    }

    public static enum FileSystemFlags {
        READONLY,
        MIGRATE_IMPLICITLY,
        INIT_IMPLICITLY;

    }
}

