/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs;

import java.io.IOException;
import java.nio.file.ClosedFileSystemException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.inject.Inject;
import org.cryptomator.cryptofs.CryptoFileChannel;
import org.cryptomator.cryptofs.EffectiveOpenOptions;
import org.cryptomator.cryptofs.FinallyUtil;
import org.cryptomator.cryptofs.OpenCryptoFile;
import org.cryptomator.cryptofs.PerOpenFile;

@PerOpenFile
class CryptoFileChannelFactory {
    private final ConcurrentMap<CryptoFileChannel, CryptoFileChannel> channels = new ConcurrentHashMap<CryptoFileChannel, CryptoFileChannel>();
    private volatile boolean closed = false;
    private final FinallyUtil finallyUtil;

    @Inject
    public CryptoFileChannelFactory(FinallyUtil finallyUtil) {
        this.finallyUtil = finallyUtil;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CryptoFileChannel create(OpenCryptoFile openCryptoFile, EffectiveOpenOptions effectiveOpenOptions) throws IOException {
        CryptoFileChannel cryptoFileChannel2 = new CryptoFileChannel(openCryptoFile, effectiveOpenOptions, cryptoFileChannel -> {
            CryptoFileChannel cfr_ignored_0 = (CryptoFileChannel)this.channels.remove(cryptoFileChannel);
        }, this.finallyUtil);
        this.channels.put(cryptoFileChannel2, cryptoFileChannel2);
        if (this.closed) {
            try {
                cryptoFileChannel2.close();
            }
            finally {
                throw new ClosedFileSystemException();
            }
        }
        return cryptoFileChannel2;
    }

    public void close() throws IOException {
        this.closed = true;
        this.finallyUtil.guaranteeInvocationOf(this.channels.keySet().stream().map(cryptoFileChannel -> () -> cryptoFileChannel.close()).iterator());
    }
}

