/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.entity.mime.content;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.content.AbstractContentBody;
import org.apache.http.util.Args;

public class FileBody
extends AbstractContentBody {
    private final File file;
    private final String filename;

    @Deprecated
    public FileBody(File file, String string, String string2, String string3) {
        this(file, ContentType.create(string2, string3), string);
    }

    @Deprecated
    public FileBody(File file, String string, String string2) {
        this(file, null, string, string2);
    }

    @Deprecated
    public FileBody(File file, String string) {
        this(file, ContentType.create(string), null);
    }

    public FileBody(File file) {
        this(file, ContentType.DEFAULT_BINARY, file != null ? file.getName() : null);
    }

    public FileBody(File file, ContentType contentType, String string) {
        super(contentType);
        Args.notNull(file, "File");
        this.file = file;
        this.filename = string == null ? file.getName() : string;
    }

    public FileBody(File file, ContentType contentType) {
        this(file, contentType, file != null ? file.getName() : null);
    }

    public InputStream getInputStream() throws IOException {
        return new FileInputStream(this.file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeTo(OutputStream outputStream) throws IOException {
        Args.notNull(outputStream, "Output stream");
        FileInputStream fileInputStream = new FileInputStream(this.file);
        try {
            int n;
            byte[] byArray = new byte[4096];
            while ((n = ((InputStream)fileInputStream).read(byArray)) != -1) {
                outputStream.write(byArray, 0, n);
            }
            outputStream.flush();
        }
        finally {
            ((InputStream)fileInputStream).close();
        }
    }

    @Override
    public String getTransferEncoding() {
        return "binary";
    }

    @Override
    public long getContentLength() {
        return this.file.length();
    }

    @Override
    public String getFilename() {
        return this.filename;
    }

    public File getFile() {
        return this.file;
    }
}

