/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.filefilter;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.filefilter.AbstractFileFilter;
import org.apache.commons.io.filefilter.ConditionalFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;

public class AndFileFilter
extends AbstractFileFilter
implements ConditionalFileFilter {
    private List fileFilters;

    public AndFileFilter() {
        this.fileFilters = new ArrayList();
    }

    public AndFileFilter(List list) {
        this.fileFilters = list == null ? new ArrayList() : new ArrayList(list);
    }

    public AndFileFilter(IOFileFilter iOFileFilter, IOFileFilter iOFileFilter2) {
        if (iOFileFilter == null || iOFileFilter2 == null) {
            throw new IllegalArgumentException("The filters must not be null");
        }
        this.fileFilters = new ArrayList();
        this.addFileFilter(iOFileFilter);
        this.addFileFilter(iOFileFilter2);
    }

    public void addFileFilter(IOFileFilter iOFileFilter) {
        this.fileFilters.add(iOFileFilter);
    }

    public List getFileFilters() {
        return Collections.unmodifiableList(this.fileFilters);
    }

    public boolean removeFileFilter(IOFileFilter iOFileFilter) {
        return this.fileFilters.remove(iOFileFilter);
    }

    public void setFileFilters(List list) {
        this.fileFilters = new ArrayList(list);
    }

    public boolean accept(File file) {
        if (this.fileFilters.size() == 0) {
            return false;
        }
        Iterator iterator = this.fileFilters.iterator();
        while (iterator.hasNext()) {
            IOFileFilter iOFileFilter = (IOFileFilter)iterator.next();
            if (iOFileFilter.accept(file)) continue;
            return false;
        }
        return true;
    }

    public boolean accept(File file, String string) {
        if (this.fileFilters.size() == 0) {
            return false;
        }
        Iterator iterator = this.fileFilters.iterator();
        while (iterator.hasNext()) {
            IOFileFilter iOFileFilter = (IOFileFilter)iterator.next();
            if (iOFileFilter.accept(file, string)) continue;
            return false;
        }
        return true;
    }
}

