/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import org.apache.commons.cli.PatternOptionBuilder;
import org.apache.commons.lang.NumberUtils;

public class TypeHandler {
    public static Object createValue(String string, Object object) {
        return TypeHandler.createValue(string, (Class)object);
    }

    public static Object createValue(String string, Class clazz) {
        if (PatternOptionBuilder.STRING_VALUE == clazz) {
            return string;
        }
        if (PatternOptionBuilder.OBJECT_VALUE == clazz) {
            return TypeHandler.createObject(string);
        }
        if (PatternOptionBuilder.NUMBER_VALUE == clazz) {
            return TypeHandler.createNumber(string);
        }
        if (PatternOptionBuilder.DATE_VALUE == clazz) {
            return TypeHandler.createDate(string);
        }
        if (PatternOptionBuilder.CLASS_VALUE == clazz) {
            return TypeHandler.createClass(string);
        }
        if (PatternOptionBuilder.FILE_VALUE == clazz) {
            return TypeHandler.createFile(string);
        }
        if (PatternOptionBuilder.EXISTING_FILE_VALUE == clazz) {
            return TypeHandler.createFile(string);
        }
        if (PatternOptionBuilder.FILES_VALUE == clazz) {
            return TypeHandler.createFiles(string);
        }
        if (PatternOptionBuilder.URL_VALUE == clazz) {
            return TypeHandler.createURL(string);
        }
        return null;
    }

    public static Object createObject(String string) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("Unable to find: " + string);
            return null;
        }
        Object var2_3 = null;
        try {
            var2_3 = clazz.newInstance();
        }
        catch (InstantiationException instantiationException) {
            System.err.println("InstantiationException; Unable to create: " + string);
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            System.err.println("IllegalAccessException; Unable to create: " + string);
            return null;
        }
        return var2_3;
    }

    public static Number createNumber(String string) {
        try {
            return NumberUtils.createNumber((String)string);
        }
        catch (NumberFormatException numberFormatException) {
            System.err.println(numberFormatException.getMessage());
            return null;
        }
    }

    public static Class createClass(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("Unable to find: " + string);
            return null;
        }
    }

    public static Date createDate(String string) {
        Date date = null;
        if (date == null) {
            System.err.println("Unable to parse: " + string);
        }
        return date;
    }

    public static URL createURL(String string) {
        try {
            return new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            System.err.println("Unable to parse: " + string);
            return null;
        }
    }

    public static File createFile(String string) {
        return new File(string);
    }

    public static File[] createFiles(String string) {
        return null;
    }
}

