/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.TypeHandler;

public class CommandLine {
    private List args = new LinkedList();
    private Map options = new HashMap();
    private Map hashcodeMap = new HashMap();
    private Option[] optionsArray;

    CommandLine() {
    }

    public boolean hasOption(String string) {
        return this.options.containsKey(string);
    }

    public boolean hasOption(char c) {
        return this.hasOption(String.valueOf(c));
    }

    public Object getOptionObject(String string) {
        String string2 = this.getOptionValue(string);
        Object object = ((Option)((List)this.options.get(string)).iterator().next()).getType();
        return string2 == null ? null : TypeHandler.createValue(string2, object);
    }

    public Object getOptionObject(char c) {
        return this.getOptionObject(String.valueOf(c));
    }

    public String getOptionValue(String string) {
        String[] stringArray = this.getOptionValues(string);
        return stringArray == null ? null : stringArray[0];
    }

    public String getOptionValue(char c) {
        return this.getOptionValue(String.valueOf(c));
    }

    public String[] getOptionValues(String string) {
        ArrayList arrayList = new ArrayList();
        if (this.options.containsKey(string)) {
            List list = (List)this.options.get(string);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Option option = (Option)iterator.next();
                arrayList.addAll(option.getValuesList());
            }
        }
        return arrayList.size() == 0 ? null : arrayList.toArray(new String[0]);
    }

    public String[] getOptionValues(char c) {
        return this.getOptionValues(String.valueOf(c));
    }

    public String getOptionValue(String string, String string2) {
        String string3 = this.getOptionValue(string);
        return string3 != null ? string3 : string2;
    }

    public String getOptionValue(char c, String string) {
        return this.getOptionValue(String.valueOf(c), string);
    }

    public String[] getArgs() {
        String[] stringArray = new String[this.args.size()];
        this.args.toArray(stringArray);
        return stringArray;
    }

    public List getArgList() {
        return this.args;
    }

    void addArg(String string) {
        this.args.add(string);
    }

    void addOption(Option option) {
        this.hashcodeMap.put(new Integer(option.hashCode()), option);
        String string = option.getOpt();
        if (" ".equals(string)) {
            string = option.getLongOpt();
        }
        if (this.options.get(string) != null) {
            ((List)this.options.get(string)).add(option);
        } else {
            this.options.put(string, new ArrayList());
            ((List)this.options.get(string)).add(option);
        }
    }

    public Iterator iterator() {
        return this.hashcodeMap.values().iterator();
    }

    public Option[] getOptions() {
        Collection collection = this.hashcodeMap.values();
        this.optionsArray = new Option[collection.size()];
        return collection.toArray(this.optionsArray);
    }
}

