/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal.shaded.org.jctools.queues;

import io.netty.util.internal.shaded.org.jctools.queues.ConcurrentCircularArrayQueue;
import io.netty.util.internal.shaded.org.jctools.queues.SparsePaddedCircularArrayOffsetCalculator;
import io.netty.util.internal.shaded.org.jctools.util.JvmInfo;
import io.netty.util.internal.shaded.org.jctools.util.UnsafeAccess;

public abstract class ConcurrentSequencedCircularArrayQueue<E>
extends ConcurrentCircularArrayQueue<E> {
    private static final long ARRAY_BASE;
    private static final int ELEMENT_SHIFT;
    protected static final int SEQ_BUFFER_PAD;
    protected final long[] sequenceBuffer;

    public ConcurrentSequencedCircularArrayQueue(int n) {
        super(n);
        int n2 = (int)(this.mask + 1L);
        this.sequenceBuffer = new long[(n2 << SparsePaddedCircularArrayOffsetCalculator.SPARSE_SHIFT) + SEQ_BUFFER_PAD * 2];
        for (long i = 0L; i < (long)n2; ++i) {
            this.soSequence(this.sequenceBuffer, this.calcSequenceOffset(i), i);
        }
    }

    protected final long calcSequenceOffset(long l) {
        return ConcurrentSequencedCircularArrayQueue.calcSequenceOffset(l, this.mask);
    }

    protected static long calcSequenceOffset(long l, long l2) {
        return ARRAY_BASE + ((l & l2) << ELEMENT_SHIFT);
    }

    protected final void soSequence(long[] lArray, long l, long l2) {
        UnsafeAccess.UNSAFE.putOrderedLong(lArray, l, l2);
    }

    protected final long lvSequence(long[] lArray, long l) {
        return UnsafeAccess.UNSAFE.getLongVolatile(lArray, l);
    }

    static {
        int n = UnsafeAccess.UNSAFE.arrayIndexScale(long[].class);
        if (8 != n) {
            throw new IllegalStateException("Unexpected long[] element size");
        }
        ELEMENT_SHIFT = 3 + SparsePaddedCircularArrayOffsetCalculator.SPARSE_SHIFT;
        SEQ_BUFFER_PAD = JvmInfo.CACHE_LINE_SIZE * 2 / n;
        ARRAY_BASE = UnsafeAccess.UNSAFE.arrayBaseOffset(long[].class) + SEQ_BUFFER_PAD * n;
    }
}

