/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal.shaded.org.jctools.queues;

import io.netty.util.internal.shaded.org.jctools.queues.ConcurrentCircularArrayQueueL0Pad;
import io.netty.util.internal.shaded.org.jctools.queues.SparsePaddedCircularArrayOffsetCalculator;
import io.netty.util.internal.shaded.org.jctools.util.Pow2;
import java.util.Iterator;

public abstract class ConcurrentCircularArrayQueue<E>
extends ConcurrentCircularArrayQueueL0Pad<E> {
    protected final long mask;
    protected final E[] buffer;

    public ConcurrentCircularArrayQueue(int n) {
        int n2 = Pow2.roundToPowerOfTwo(n);
        this.mask = n2 - 1;
        this.buffer = SparsePaddedCircularArrayOffsetCalculator.allocate(n2);
    }

    protected final long calcElementOffset(long l) {
        return ConcurrentCircularArrayQueue.calcElementOffset(l, this.mask);
    }

    protected static long calcElementOffset(long l, long l2) {
        return SparsePaddedCircularArrayOffsetCalculator.calcElementOffset(l, l2);
    }

    @Override
    public Iterator<E> iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        while (this.poll() != null || !this.isEmpty()) {
        }
    }

    @Override
    public int capacity() {
        return (int)(this.mask + 1L);
    }
}

