/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.IdentityCipherSuiteFilter;
import io.netty.handler.ssl.OpenSsl;
import io.netty.handler.ssl.OpenSslContext;
import io.netty.handler.ssl.OpenSslEngine;
import io.netty.handler.ssl.OpenSslEngineMap;
import io.netty.handler.ssl.OpenSslExtendedKeyMaterialManager;
import io.netty.handler.ssl.OpenSslKeyMaterialManager;
import io.netty.handler.ssl.OpenSslSessionContext;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.File;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.HashSet;
import java.util.Set;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import javax.security.auth.x500.X500Principal;
import org.apache.tomcat.jni.CertificateRequestedCallback;
import org.apache.tomcat.jni.CertificateVerifier;
import org.apache.tomcat.jni.SSLContext;

public final class OpenSslClientContext
extends OpenSslContext {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(OpenSslClientContext.class);
    private final OpenSslSessionContext sessionContext;

    @Deprecated
    public OpenSslClientContext() throws SSLException {
        this((File)null, null, null, null, null, null, null, (CipherSuiteFilter)IdentityCipherSuiteFilter.INSTANCE, null, 0L, 0L);
    }

    @Deprecated
    public OpenSslClientContext(File file) throws SSLException {
        this(file, null);
    }

    @Deprecated
    public OpenSslClientContext(TrustManagerFactory trustManagerFactory) throws SSLException {
        this(null, trustManagerFactory);
    }

    @Deprecated
    public OpenSslClientContext(File file, TrustManagerFactory trustManagerFactory) throws SSLException {
        this(file, trustManagerFactory, null, null, null, null, null, (CipherSuiteFilter)IdentityCipherSuiteFilter.INSTANCE, null, 0L, 0L);
    }

    @Deprecated
    public OpenSslClientContext(File file, TrustManagerFactory trustManagerFactory, Iterable<String> iterable, ApplicationProtocolConfig applicationProtocolConfig, long l, long l2) throws SSLException {
        this(file, trustManagerFactory, null, null, null, null, iterable, (CipherSuiteFilter)IdentityCipherSuiteFilter.INSTANCE, applicationProtocolConfig, l, l2);
    }

    @Deprecated
    public OpenSslClientContext(File file, TrustManagerFactory trustManagerFactory, Iterable<String> iterable, CipherSuiteFilter cipherSuiteFilter, ApplicationProtocolConfig applicationProtocolConfig, long l, long l2) throws SSLException {
        this(file, trustManagerFactory, null, null, null, null, iterable, cipherSuiteFilter, applicationProtocolConfig, l, l2);
    }

    @Deprecated
    public OpenSslClientContext(File file, TrustManagerFactory trustManagerFactory, File file2, File file3, String string, KeyManagerFactory keyManagerFactory, Iterable<String> iterable, CipherSuiteFilter cipherSuiteFilter, ApplicationProtocolConfig applicationProtocolConfig, long l, long l2) throws SSLException {
        this(OpenSslClientContext.toX509CertificatesInternal(file), trustManagerFactory, OpenSslClientContext.toX509CertificatesInternal(file2), OpenSslClientContext.toPrivateKeyInternal(file3, string), string, keyManagerFactory, iterable, cipherSuiteFilter, applicationProtocolConfig, l, l2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OpenSslClientContext(X509Certificate[] x509CertificateArray, TrustManagerFactory trustManagerFactory, X509Certificate[] x509CertificateArray2, PrivateKey privateKey, String string, KeyManagerFactory keyManagerFactory, Iterable<String> iterable, CipherSuiteFilter cipherSuiteFilter, ApplicationProtocolConfig applicationProtocolConfig, long l, long l2) throws SSLException {
        super(iterable, cipherSuiteFilter, applicationProtocolConfig, l, l2, 0, (Certificate[])x509CertificateArray2, ClientAuth.NONE);
        boolean bl = false;
        try {
            if (privateKey == null && x509CertificateArray2 != null || privateKey != null && x509CertificateArray2 == null) {
                throw new IllegalArgumentException("Either both keyCertChain and key needs to be null or none of them");
            }
            Class<OpenSslContext> clazz = OpenSslContext.class;
            synchronized (OpenSslContext.class) {
                Object object;
                try {
                    if (!OpenSsl.supportsKeyManagerFactory()) {
                        if (keyManagerFactory != null) {
                            throw new IllegalArgumentException("KeyManagerFactory not supported");
                        }
                        if (x509CertificateArray2 != null && privateKey != null) {
                            OpenSslClientContext.setKeyMaterial(this.ctx, x509CertificateArray2, privateKey, string);
                        }
                    } else {
                        if (x509CertificateArray2 != null) {
                            keyManagerFactory = OpenSslClientContext.buildKeyManagerFactory(x509CertificateArray2, privateKey, string, keyManagerFactory);
                        }
                        if (keyManagerFactory != null) {
                            object = OpenSslClientContext.chooseX509KeyManager(keyManagerFactory.getKeyManagers());
                            OpenSslKeyMaterialManager openSslKeyMaterialManager = OpenSslClientContext.useExtendedKeyManager((X509KeyManager)object) ? new OpenSslExtendedKeyMaterialManager((X509ExtendedKeyManager)object, string) : new OpenSslKeyMaterialManager((X509KeyManager)object, string);
                            SSLContext.setCertRequestedCallback((long)this.ctx, (CertificateRequestedCallback)new OpenSslCertificateRequestedCallback(this.engineMap, openSslKeyMaterialManager));
                        }
                    }
                }
                catch (Exception exception) {
                    throw new SSLException("failed to set certificate and key", exception);
                }
                SSLContext.setVerify((long)this.ctx, (int)0, (int)10);
                try {
                    if (x509CertificateArray != null) {
                        trustManagerFactory = OpenSslClientContext.buildTrustManagerFactory(x509CertificateArray, trustManagerFactory);
                    } else if (trustManagerFactory == null) {
                        trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                        trustManagerFactory.init((KeyStore)null);
                    }
                    object = OpenSslClientContext.chooseTrustManager(trustManagerFactory.getTrustManagers());
                    if (OpenSslClientContext.useExtendedTrustManager((X509TrustManager)object)) {
                        SSLContext.setCertVerifyCallback((long)this.ctx, (CertificateVerifier)new ExtendedTrustManagerVerifyCallback(this.engineMap, (X509ExtendedTrustManager)object));
                    } else {
                        SSLContext.setCertVerifyCallback((long)this.ctx, (CertificateVerifier)new TrustManagerVerifyCallback(this.engineMap, (X509TrustManager)object));
                    }
                }
                catch (Exception exception) {
                    throw new SSLException("unable to setup trustmanager", exception);
                }
                this.sessionContext = new OpenSslClientSessionContext(this);
                bl = true;
            }
        }
        finally {
            if (!bl) {
                this.destroy();
            }
        }
        {
            return;
        }
    }

    @Override
    public OpenSslSessionContext sessionContext() {
        return this.sessionContext;
    }

    @Override
    OpenSslKeyMaterialManager keyMaterialManager() {
        return null;
    }

    private static final class OpenSslCertificateRequestedCallback
    implements CertificateRequestedCallback {
        private final OpenSslEngineMap engineMap;
        private final OpenSslKeyMaterialManager keyManagerHolder;

        OpenSslCertificateRequestedCallback(OpenSslEngineMap openSslEngineMap, OpenSslKeyMaterialManager openSslKeyMaterialManager) {
            this.engineMap = openSslEngineMap;
            this.keyManagerHolder = openSslKeyMaterialManager;
        }

        public void requested(long l, byte[] byArray, byte[][] byArray2) {
            OpenSslEngine openSslEngine = this.engineMap.get(l);
            try {
                X500Principal[] x500PrincipalArray;
                Set<String> set = OpenSslCertificateRequestedCallback.supportedClientKeyTypes(byArray);
                String[] stringArray = set.toArray(new String[set.size()]);
                if (byArray2 == null) {
                    x500PrincipalArray = null;
                } else {
                    x500PrincipalArray = new X500Principal[byArray2.length];
                    for (int i = 0; i < byArray2.length; ++i) {
                        x500PrincipalArray[i] = new X500Principal(byArray2[i]);
                    }
                }
                this.keyManagerHolder.setKeyMaterial(openSslEngine, stringArray, x500PrincipalArray);
            }
            catch (Throwable throwable) {
                logger.debug("request of key failed", throwable);
                SSLHandshakeException sSLHandshakeException = new SSLHandshakeException("General OpenSslEngine problem");
                sSLHandshakeException.initCause(throwable);
                openSslEngine.handshakeException = sSLHandshakeException;
            }
        }

        private static Set<String> supportedClientKeyTypes(byte[] byArray) {
            HashSet<String> hashSet = new HashSet<String>(byArray.length);
            for (byte by : byArray) {
                String string = OpenSslCertificateRequestedCallback.clientKeyType(by);
                if (string == null) continue;
                hashSet.add(string);
            }
            return hashSet;
        }

        private static String clientKeyType(byte by) {
            switch (by) {
                case 1: {
                    return "RSA";
                }
                case 3: {
                    return "DH_RSA";
                }
                case 64: {
                    return "EC";
                }
                case 65: {
                    return "EC_RSA";
                }
                case 66: {
                    return "EC_EC";
                }
            }
            return null;
        }
    }

    private static final class ExtendedTrustManagerVerifyCallback
    extends OpenSslContext.AbstractCertificateVerifier {
        private final X509ExtendedTrustManager manager;

        ExtendedTrustManagerVerifyCallback(OpenSslEngineMap openSslEngineMap, X509ExtendedTrustManager x509ExtendedTrustManager) {
            super(openSslEngineMap);
            this.manager = x509ExtendedTrustManager;
        }

        @Override
        void verify(OpenSslEngine openSslEngine, X509Certificate[] x509CertificateArray, String string) throws Exception {
            this.manager.checkServerTrusted(x509CertificateArray, string, openSslEngine);
        }
    }

    private static final class TrustManagerVerifyCallback
    extends OpenSslContext.AbstractCertificateVerifier {
        private final X509TrustManager manager;

        TrustManagerVerifyCallback(OpenSslEngineMap openSslEngineMap, X509TrustManager x509TrustManager) {
            super(openSslEngineMap);
            this.manager = x509TrustManager;
        }

        @Override
        void verify(OpenSslEngine openSslEngine, X509Certificate[] x509CertificateArray, String string) throws Exception {
            this.manager.checkServerTrusted(x509CertificateArray, string);
        }
    }

    private static final class OpenSslClientSessionContext
    extends OpenSslSessionContext {
        private OpenSslClientSessionContext(OpenSslContext openSslContext) {
            super(openSslContext);
        }

        @Override
        public void setSessionTimeout(int n) {
            if (n < 0) {
                throw new IllegalArgumentException();
            }
        }

        @Override
        public int getSessionTimeout() {
            return 0;
        }

        @Override
        public void setSessionCacheSize(int n) {
            if (n < 0) {
                throw new IllegalArgumentException();
            }
        }

        @Override
        public int getSessionCacheSize() {
            return 0;
        }

        @Override
        public void setSessionCacheEnabled(boolean bl) {
        }

        @Override
        public boolean isSessionCacheEnabled() {
            return false;
        }
    }
}

