/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.redis;

import io.netty.handler.codec.redis.RedisCodecException;

public enum RedisMessageType {
    SIMPLE_STRING(43, true),
    ERROR(45, true),
    INTEGER(58, true),
    BULK_STRING(36, false),
    ARRAY_HEADER(42, false),
    ARRAY(42, false);

    private final byte value;
    private final boolean inline;

    private RedisMessageType(byte by, boolean bl) {
        this.value = by;
        this.inline = bl;
    }

    public byte value() {
        return this.value;
    }

    public boolean isInline() {
        return this.inline;
    }

    public static RedisMessageType valueOf(byte by) {
        switch (by) {
            case 43: {
                return SIMPLE_STRING;
            }
            case 45: {
                return ERROR;
            }
            case 58: {
                return INTEGER;
            }
            case 36: {
                return BULK_STRING;
            }
            case 42: {
                return ARRAY_HEADER;
            }
        }
        throw new RedisCodecException("Unknown RedisMessageType: " + by);
    }
}

