/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2.internal.hpack;

import io.netty.handler.codec.UnsupportedValueConverter;
import io.netty.handler.codec.http2.CharSequenceMap;
import io.netty.handler.codec.http2.internal.hpack.HeaderField;
import io.netty.handler.codec.http2.internal.hpack.HpackUtil;
import io.netty.util.AsciiString;
import java.util.Arrays;
import java.util.List;

final class StaticTable {
    private static final List<HeaderField> STATIC_TABLE = Arrays.asList(StaticTable.newEmptyHeaderField(":authority"), StaticTable.newHeaderField(":method", "GET"), StaticTable.newHeaderField(":method", "POST"), StaticTable.newHeaderField(":path", "/"), StaticTable.newHeaderField(":path", "/index.html"), StaticTable.newHeaderField(":scheme", "http"), StaticTable.newHeaderField(":scheme", "https"), StaticTable.newHeaderField(":status", "200"), StaticTable.newHeaderField(":status", "204"), StaticTable.newHeaderField(":status", "206"), StaticTable.newHeaderField(":status", "304"), StaticTable.newHeaderField(":status", "400"), StaticTable.newHeaderField(":status", "404"), StaticTable.newHeaderField(":status", "500"), StaticTable.newEmptyHeaderField("accept-charset"), StaticTable.newHeaderField("accept-encoding", "gzip, deflate"), StaticTable.newEmptyHeaderField("accept-language"), StaticTable.newEmptyHeaderField("accept-ranges"), StaticTable.newEmptyHeaderField("accept"), StaticTable.newEmptyHeaderField("access-control-allow-origin"), StaticTable.newEmptyHeaderField("age"), StaticTable.newEmptyHeaderField("allow"), StaticTable.newEmptyHeaderField("authorization"), StaticTable.newEmptyHeaderField("cache-control"), StaticTable.newEmptyHeaderField("content-disposition"), StaticTable.newEmptyHeaderField("content-encoding"), StaticTable.newEmptyHeaderField("content-language"), StaticTable.newEmptyHeaderField("content-length"), StaticTable.newEmptyHeaderField("content-location"), StaticTable.newEmptyHeaderField("content-range"), StaticTable.newEmptyHeaderField("content-type"), StaticTable.newEmptyHeaderField("cookie"), StaticTable.newEmptyHeaderField("date"), StaticTable.newEmptyHeaderField("etag"), StaticTable.newEmptyHeaderField("expect"), StaticTable.newEmptyHeaderField("expires"), StaticTable.newEmptyHeaderField("from"), StaticTable.newEmptyHeaderField("host"), StaticTable.newEmptyHeaderField("if-match"), StaticTable.newEmptyHeaderField("if-modified-since"), StaticTable.newEmptyHeaderField("if-none-match"), StaticTable.newEmptyHeaderField("if-range"), StaticTable.newEmptyHeaderField("if-unmodified-since"), StaticTable.newEmptyHeaderField("last-modified"), StaticTable.newEmptyHeaderField("link"), StaticTable.newEmptyHeaderField("location"), StaticTable.newEmptyHeaderField("max-forwards"), StaticTable.newEmptyHeaderField("proxy-authenticate"), StaticTable.newEmptyHeaderField("proxy-authorization"), StaticTable.newEmptyHeaderField("range"), StaticTable.newEmptyHeaderField("referer"), StaticTable.newEmptyHeaderField("refresh"), StaticTable.newEmptyHeaderField("retry-after"), StaticTable.newEmptyHeaderField("server"), StaticTable.newEmptyHeaderField("set-cookie"), StaticTable.newEmptyHeaderField("strict-transport-security"), StaticTable.newEmptyHeaderField("transfer-encoding"), StaticTable.newEmptyHeaderField("user-agent"), StaticTable.newEmptyHeaderField("vary"), StaticTable.newEmptyHeaderField("via"), StaticTable.newEmptyHeaderField("www-authenticate"));
    private static final CharSequenceMap<Integer> STATIC_INDEX_BY_NAME = StaticTable.createMap();
    static final int length = STATIC_TABLE.size();

    private static HeaderField newEmptyHeaderField(CharSequence charSequence) {
        return StaticTable.newHeaderField(charSequence, AsciiString.EMPTY_STRING);
    }

    private static HeaderField newHeaderField(CharSequence charSequence, CharSequence charSequence2) {
        return new HeaderField(AsciiString.of(charSequence), AsciiString.of(charSequence2));
    }

    static HeaderField getEntry(int n) {
        return STATIC_TABLE.get(n - 1);
    }

    static int getIndex(CharSequence charSequence) {
        Integer n = (Integer)STATIC_INDEX_BY_NAME.get(charSequence);
        if (n == null) {
            return -1;
        }
        return n;
    }

    static int getIndex(CharSequence charSequence, CharSequence charSequence2) {
        int n = StaticTable.getIndex(charSequence);
        if (n == -1) {
            return -1;
        }
        while (n <= length) {
            HeaderField headerField = StaticTable.getEntry(n);
            if (HpackUtil.equalsConstantTime(charSequence, headerField.name) == 0) break;
            if (HpackUtil.equalsConstantTime(charSequence2, headerField.value) != 0) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    private static CharSequenceMap<Integer> createMap() {
        int n = STATIC_TABLE.size();
        CharSequenceMap<Integer> charSequenceMap = new CharSequenceMap<Integer>(true, UnsupportedValueConverter.instance(), n);
        for (int i = n; i > 0; --i) {
            HeaderField headerField = StaticTable.getEntry(i);
            CharSequence charSequence = headerField.name;
            charSequenceMap.set(charSequence, i);
        }
        return charSequenceMap;
    }

    private StaticTable() {
    }
}

