/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.EventLoopGroup;
import io.netty.handler.codec.http2.DefaultHttp2FrameWriter;
import io.netty.handler.codec.http2.Http2FrameCodec;
import io.netty.handler.codec.http2.Http2FrameWriter;
import io.netty.handler.codec.http2.Http2MultiplexCodec;

public final class Http2Codec
extends ChannelDuplexHandler {
    private final Http2FrameCodec frameCodec;
    private final Http2MultiplexCodec multiplexCodec;

    public Http2Codec(boolean bl, ChannelHandler channelHandler) {
        this(bl, channelHandler, null);
    }

    public Http2Codec(boolean bl, ChannelHandler channelHandler, EventLoopGroup eventLoopGroup) {
        this(bl, channelHandler, eventLoopGroup, new DefaultHttp2FrameWriter());
    }

    Http2Codec(boolean bl, ChannelHandler channelHandler, EventLoopGroup eventLoopGroup, Http2FrameWriter http2FrameWriter) {
        this.frameCodec = new Http2FrameCodec(bl, http2FrameWriter);
        this.multiplexCodec = new Http2MultiplexCodec(bl, eventLoopGroup, channelHandler);
    }

    Http2FrameCodec frameCodec() {
        return this.frameCodec;
    }

    @Override
    public void handlerAdded(ChannelHandlerContext channelHandlerContext) throws Exception {
        channelHandlerContext.pipeline().addBefore(channelHandlerContext.executor(), channelHandlerContext.name(), null, this.frameCodec);
        channelHandlerContext.pipeline().addBefore(channelHandlerContext.executor(), channelHandlerContext.name(), null, this.multiplexCodec);
        channelHandlerContext.pipeline().remove(this);
    }
}

