/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http2.DefaultHttp2HeaderTableListSize;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2HeaderTable;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2HeadersEncoder;
import io.netty.handler.codec.http2.internal.hpack.Encoder;
import io.netty.util.internal.ObjectUtil;
import java.util.Map;

public class DefaultHttp2HeadersEncoder
implements Http2HeadersEncoder,
Http2HeadersEncoder.Configuration {
    private final Encoder encoder;
    private final Http2HeadersEncoder.SensitivityDetector sensitivityDetector;
    private final Http2HeaderTable headerTable;
    private final ByteBuf tableSizeChangeOutput = Unpooled.buffer();

    public DefaultHttp2HeadersEncoder() {
        this(4096, NEVER_SENSITIVE);
    }

    public DefaultHttp2HeadersEncoder(int n, Http2HeadersEncoder.SensitivityDetector sensitivityDetector) {
        this.sensitivityDetector = ObjectUtil.checkNotNull(sensitivityDetector, "sensitiveDetector");
        this.encoder = new Encoder(n);
        this.headerTable = new Http2HeaderTableEncoder();
    }

    @Override
    public void encodeHeaders(Http2Headers http2Headers, ByteBuf byteBuf) throws Http2Exception {
        try {
            if (http2Headers.size() > this.headerTable.maxHeaderListSize()) {
                throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Number of headers (%d) exceeds maxHeaderListSize (%d)", http2Headers.size(), this.headerTable.maxHeaderListSize());
            }
            if (this.tableSizeChangeOutput.isReadable()) {
                byteBuf.writeBytes(this.tableSizeChangeOutput);
                this.tableSizeChangeOutput.clear();
            }
            for (Map.Entry<CharSequence, CharSequence> entry : http2Headers) {
                this.encodeHeader(byteBuf, entry.getKey(), entry.getValue());
            }
        }
        catch (Http2Exception http2Exception) {
            throw http2Exception;
        }
        catch (Throwable throwable) {
            throw Http2Exception.connectionError(Http2Error.COMPRESSION_ERROR, throwable, "Failed encoding headers block: %s", throwable.getMessage());
        }
    }

    @Override
    public Http2HeaderTable headerTable() {
        return this.headerTable;
    }

    @Override
    public Http2HeadersEncoder.Configuration configuration() {
        return this;
    }

    private void encodeHeader(ByteBuf byteBuf, CharSequence charSequence, CharSequence charSequence2) {
        this.encoder.encodeHeader(byteBuf, charSequence, charSequence2, this.sensitivityDetector.isSensitive(charSequence, charSequence2));
    }

    private final class Http2HeaderTableEncoder
    extends DefaultHttp2HeaderTableListSize
    implements Http2HeaderTable {
        private Http2HeaderTableEncoder() {
        }

        @Override
        public void maxHeaderTableSize(int n) throws Http2Exception {
            if (n < 0) {
                throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Header Table Size must be non-negative but was %d", n);
            }
            try {
                DefaultHttp2HeadersEncoder.this.encoder.setMaxHeaderTableSize(DefaultHttp2HeadersEncoder.this.tableSizeChangeOutput, n);
            }
            catch (Throwable throwable) {
                throw new Http2Exception(Http2Error.PROTOCOL_ERROR, throwable.getMessage(), throwable);
            }
        }

        @Override
        public int maxHeaderTableSize() {
            return DefaultHttp2HeadersEncoder.this.encoder.getMaxHeaderTableSize();
        }
    }
}

