/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.compression;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.channel.ChannelPromiseNotifier;
import io.netty.handler.codec.MessageToByteEncoder;
import io.netty.handler.codec.compression.CompressionException;
import io.netty.util.concurrent.EventExecutor;
import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;
import java.util.zip.Checksum;
import net.jpountz.lz4.LZ4Compressor;
import net.jpountz.lz4.LZ4Exception;
import net.jpountz.lz4.LZ4Factory;
import net.jpountz.xxhash.XXHashFactory;

public class Lz4FrameEncoder
extends MessageToByteEncoder<ByteBuf> {
    private final int blockSize;
    private LZ4Compressor compressor;
    private Checksum checksum;
    private final int compressionLevel;
    private ByteBuf buffer;
    private int currentBlockLength;
    private final int compressedBlockSize;
    private volatile boolean finished;
    private volatile ChannelHandlerContext ctx;

    public Lz4FrameEncoder() {
        this(false);
    }

    public Lz4FrameEncoder(boolean bl) {
        this(LZ4Factory.fastestInstance(), bl, 65536, XXHashFactory.fastestInstance().newStreamingHash32(-1756908916).asChecksum());
    }

    public Lz4FrameEncoder(LZ4Factory lZ4Factory, boolean bl, int n, Checksum checksum) {
        if (lZ4Factory == null) {
            throw new NullPointerException("factory");
        }
        if (checksum == null) {
            throw new NullPointerException("checksum");
        }
        this.compressor = bl ? lZ4Factory.highCompressor() : lZ4Factory.fastCompressor();
        this.checksum = checksum;
        this.compressionLevel = Lz4FrameEncoder.compressionLevel(n);
        this.blockSize = n;
        this.currentBlockLength = 0;
        this.compressedBlockSize = 21 + this.compressor.maxCompressedLength(n);
        this.finished = false;
    }

    private static int compressionLevel(int n) {
        if (n < 64 || n > 0x2000000) {
            throw new IllegalArgumentException(String.format("blockSize: %d (expected: %d-%d)", n, 64, 0x2000000));
        }
        int n2 = 32 - Integer.numberOfLeadingZeros(n - 1);
        n2 = Math.max(0, n2 - 10);
        return n2;
    }

    @Override
    protected void encode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, ByteBuf byteBuf2) throws Exception {
        if (this.finished) {
            byteBuf2.writeBytes(byteBuf);
            return;
        }
        int n = byteBuf.readableBytes();
        ByteBuf byteBuf3 = this.buffer;
        int n2 = byteBuf3.capacity();
        while (this.currentBlockLength + n >= n2) {
            int n3 = n2 - this.currentBlockLength;
            byteBuf.getBytes(byteBuf.readerIndex(), byteBuf3, this.currentBlockLength, n3);
            this.currentBlockLength = n2;
            this.flushBufferedData(byteBuf2);
            byteBuf.skipBytes(n3);
            n -= n3;
        }
        byteBuf.readBytes(byteBuf3, this.currentBlockLength, n);
        this.currentBlockLength += n;
    }

    private void flushBufferedData(ByteBuf byteBuf) {
        int n;
        int n2;
        int n3 = this.currentBlockLength;
        if (n3 == 0) {
            return;
        }
        this.checksum.reset();
        this.checksum.update(this.buffer.array(), this.buffer.arrayOffset(), n3);
        int n4 = (int)this.checksum.getValue();
        byteBuf.ensureWritable(this.compressedBlockSize);
        int n5 = byteBuf.writerIndex();
        try {
            ByteBuffer byteBuffer = byteBuf.internalNioBuffer(n5 + 21, byteBuf.writableBytes() - 21);
            int n6 = byteBuffer.position();
            this.compressor.compress(this.buffer.internalNioBuffer(0, n3), byteBuffer);
            n2 = byteBuffer.position() - n6;
        }
        catch (LZ4Exception lZ4Exception) {
            throw new CompressionException(lZ4Exception);
        }
        if (n2 >= n3) {
            n = 16;
            n2 = n3;
            byteBuf.setBytes(n5 + 21, this.buffer, 0, n3);
        } else {
            n = 32;
        }
        byteBuf.setLong(n5, 5501767354678207339L);
        byteBuf.setByte(n5 + 8, (byte)(n | this.compressionLevel));
        byteBuf.setIntLE(n5 + 9, n2);
        byteBuf.setIntLE(n5 + 13, n3);
        byteBuf.setIntLE(n5 + 17, n4);
        byteBuf.writerIndex(n5 + 21 + n2);
        this.currentBlockLength = n3 = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ChannelFuture finishEncode(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) {
        if (this.finished) {
            channelPromise.setSuccess();
            return channelPromise;
        }
        this.finished = true;
        try {
            ByteBuf byteBuf = channelHandlerContext.alloc().heapBuffer(this.compressor.maxCompressedLength(this.currentBlockLength) + 21);
            this.flushBufferedData(byteBuf);
            int n = byteBuf.writerIndex();
            byteBuf.setLong(n, 5501767354678207339L);
            byteBuf.setByte(n + 8, (byte)(0x10 | this.compressionLevel));
            byteBuf.setInt(n + 9, 0);
            byteBuf.setInt(n + 13, 0);
            byteBuf.setInt(n + 17, 0);
            byteBuf.writerIndex(n + 21);
            ChannelFuture channelFuture = channelHandlerContext.writeAndFlush(byteBuf, channelPromise);
            return channelFuture;
        }
        finally {
            this.cleanup();
        }
    }

    private void cleanup() {
        this.compressor = null;
        this.checksum = null;
        if (this.buffer != null) {
            this.buffer.release();
            this.buffer = null;
        }
    }

    public boolean isClosed() {
        return this.finished;
    }

    public ChannelFuture close() {
        return this.close(this.ctx().newPromise());
    }

    public ChannelFuture close(final ChannelPromise channelPromise) {
        ChannelHandlerContext channelHandlerContext = this.ctx();
        EventExecutor eventExecutor = channelHandlerContext.executor();
        if (eventExecutor.inEventLoop()) {
            return this.finishEncode(channelHandlerContext, channelPromise);
        }
        eventExecutor.execute(new Runnable(){

            @Override
            public void run() {
                ChannelFuture channelFuture = Lz4FrameEncoder.this.finishEncode(Lz4FrameEncoder.this.ctx(), channelPromise);
                channelFuture.addListener(new ChannelPromiseNotifier(channelPromise));
            }
        });
        return channelPromise;
    }

    @Override
    public void close(final ChannelHandlerContext channelHandlerContext, final ChannelPromise channelPromise) throws Exception {
        ChannelFuture channelFuture = this.finishEncode(channelHandlerContext, channelHandlerContext.newPromise());
        channelFuture.addListener(new ChannelFutureListener(){

            @Override
            public void operationComplete(ChannelFuture channelFuture) throws Exception {
                channelHandlerContext.close(channelPromise);
            }
        });
        if (!channelFuture.isDone()) {
            channelHandlerContext.executor().schedule(new Runnable(){

                @Override
                public void run() {
                    channelHandlerContext.close(channelPromise);
                }
            }, 10L, TimeUnit.SECONDS);
        }
    }

    private ChannelHandlerContext ctx() {
        ChannelHandlerContext channelHandlerContext = this.ctx;
        if (channelHandlerContext == null) {
            throw new IllegalStateException("not added to a pipeline");
        }
        return channelHandlerContext;
    }

    @Override
    public void handlerAdded(ChannelHandlerContext channelHandlerContext) throws Exception {
        this.ctx = channelHandlerContext;
        this.buffer = Unpooled.wrappedBuffer(new byte[this.blockSize]);
    }

    @Override
    public void handlerRemoved(ChannelHandlerContext channelHandlerContext) throws Exception {
        super.handlerRemoved(channelHandlerContext);
        this.cleanup();
    }
}

