/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel;

import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundBuffer;
import io.netty.channel.ChannelPromise;
import io.netty.channel.MessageSizeEstimator;
import io.netty.channel.VoidChannelPromise;
import io.netty.util.Recycler;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.PromiseCombiner;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;

public final class PendingWriteQueue {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(PendingWriteQueue.class);
    private final ChannelHandlerContext ctx;
    private final ChannelOutboundBuffer buffer;
    private final MessageSizeEstimator.Handle estimatorHandle;
    private PendingWrite head;
    private PendingWrite tail;
    private int size;
    private long bytes;

    public PendingWriteQueue(ChannelHandlerContext channelHandlerContext) {
        if (channelHandlerContext == null) {
            throw new NullPointerException("ctx");
        }
        this.ctx = channelHandlerContext;
        this.buffer = channelHandlerContext.channel().unsafe().outboundBuffer();
        this.estimatorHandle = channelHandlerContext.channel().config().getMessageSizeEstimator().newHandle();
    }

    public boolean isEmpty() {
        assert (this.ctx.executor().inEventLoop());
        return this.head == null;
    }

    public int size() {
        assert (this.ctx.executor().inEventLoop());
        return this.size;
    }

    public long bytes() {
        assert (this.ctx.executor().inEventLoop());
        return this.bytes;
    }

    public void add(Object object, ChannelPromise channelPromise) {
        assert (this.ctx.executor().inEventLoop());
        if (object == null) {
            throw new NullPointerException("msg");
        }
        if (channelPromise == null) {
            throw new NullPointerException("promise");
        }
        int n = this.estimatorHandle.size(object);
        if (n < 0) {
            n = 0;
        }
        PendingWrite pendingWrite = PendingWrite.newInstance(object, n, channelPromise);
        PendingWrite pendingWrite2 = this.tail;
        if (pendingWrite2 == null) {
            this.tail = this.head = pendingWrite;
        } else {
            pendingWrite2.next = pendingWrite;
            this.tail = pendingWrite;
        }
        ++this.size;
        this.bytes += (long)n;
        if (this.buffer != null) {
            this.buffer.incrementPendingOutboundBytes(pendingWrite.size);
        }
    }

    public void removeAndFailAll(Throwable throwable) {
        assert (this.ctx.executor().inEventLoop());
        if (throwable == null) {
            throw new NullPointerException("cause");
        }
        PendingWrite pendingWrite = this.head;
        while (pendingWrite != null) {
            this.tail = null;
            this.head = null;
            this.size = 0;
            this.bytes = 0L;
            while (pendingWrite != null) {
                PendingWrite pendingWrite2 = pendingWrite.next;
                ReferenceCountUtil.safeRelease(pendingWrite.msg);
                ChannelPromise channelPromise = pendingWrite.promise;
                this.recycle(pendingWrite, false);
                PendingWriteQueue.safeFail(channelPromise, throwable);
                pendingWrite = pendingWrite2;
            }
            pendingWrite = this.head;
        }
        this.assertEmpty();
    }

    public void removeAndFail(Throwable throwable) {
        assert (this.ctx.executor().inEventLoop());
        if (throwable == null) {
            throw new NullPointerException("cause");
        }
        PendingWrite pendingWrite = this.head;
        if (pendingWrite == null) {
            return;
        }
        ReferenceCountUtil.safeRelease(pendingWrite.msg);
        ChannelPromise channelPromise = pendingWrite.promise;
        PendingWriteQueue.safeFail(channelPromise, throwable);
        this.recycle(pendingWrite, true);
    }

    public ChannelFuture removeAndWriteAll() {
        assert (this.ctx.executor().inEventLoop());
        if (this.size == 1) {
            return this.removeAndWrite();
        }
        PendingWrite pendingWrite = this.head;
        if (pendingWrite == null) {
            return null;
        }
        this.tail = null;
        this.head = null;
        this.size = 0;
        this.bytes = 0L;
        ChannelPromise channelPromise = this.ctx.newPromise();
        PromiseCombiner promiseCombiner = new PromiseCombiner();
        try {
            while (pendingWrite != null) {
                PendingWrite pendingWrite2 = pendingWrite.next;
                Object object = pendingWrite.msg;
                ChannelPromise channelPromise2 = pendingWrite.promise;
                this.recycle(pendingWrite, false);
                promiseCombiner.add(channelPromise2);
                this.ctx.write(object, channelPromise2);
                pendingWrite = pendingWrite2;
            }
            this.assertEmpty();
            promiseCombiner.finish(channelPromise);
        }
        catch (Throwable throwable) {
            channelPromise.setFailure(throwable);
        }
        return channelPromise;
    }

    private void assertEmpty() {
        assert (this.tail == null && this.head == null && this.size == 0);
    }

    public ChannelFuture removeAndWrite() {
        assert (this.ctx.executor().inEventLoop());
        PendingWrite pendingWrite = this.head;
        if (pendingWrite == null) {
            return null;
        }
        Object object = pendingWrite.msg;
        ChannelPromise channelPromise = pendingWrite.promise;
        this.recycle(pendingWrite, true);
        return this.ctx.write(object, channelPromise);
    }

    public ChannelPromise remove() {
        assert (this.ctx.executor().inEventLoop());
        PendingWrite pendingWrite = this.head;
        if (pendingWrite == null) {
            return null;
        }
        ChannelPromise channelPromise = pendingWrite.promise;
        ReferenceCountUtil.safeRelease(pendingWrite.msg);
        this.recycle(pendingWrite, true);
        return channelPromise;
    }

    public Object current() {
        assert (this.ctx.executor().inEventLoop());
        PendingWrite pendingWrite = this.head;
        if (pendingWrite == null) {
            return null;
        }
        return pendingWrite.msg;
    }

    private void recycle(PendingWrite pendingWrite, boolean bl) {
        PendingWrite pendingWrite2 = pendingWrite.next;
        long l = pendingWrite.size;
        if (bl) {
            if (pendingWrite2 == null) {
                this.tail = null;
                this.head = null;
                this.size = 0;
                this.bytes = 0L;
            } else {
                this.head = pendingWrite2;
                --this.size;
                this.bytes -= l;
                assert (this.size > 0 && this.bytes >= 0L);
            }
        }
        pendingWrite.recycle();
        if (this.buffer != null) {
            this.buffer.decrementPendingOutboundBytes(l);
        }
    }

    private static void safeFail(ChannelPromise channelPromise, Throwable throwable) {
        if (!(channelPromise instanceof VoidChannelPromise) && !channelPromise.tryFailure(throwable)) {
            logger.warn("Failed to mark a promise as failure because it's done already: {}", (Object)channelPromise, (Object)throwable);
        }
    }

    static final class PendingWrite {
        private static final Recycler<PendingWrite> RECYCLER = new Recycler<PendingWrite>(){

            @Override
            protected PendingWrite newObject(Recycler.Handle<PendingWrite> handle) {
                return new PendingWrite(handle);
            }
        };
        private final Recycler.Handle<PendingWrite> handle;
        private PendingWrite next;
        private long size;
        private ChannelPromise promise;
        private Object msg;

        private PendingWrite(Recycler.Handle<PendingWrite> handle) {
            this.handle = handle;
        }

        static PendingWrite newInstance(Object object, int n, ChannelPromise channelPromise) {
            PendingWrite pendingWrite = RECYCLER.get();
            pendingWrite.size = n;
            pendingWrite.msg = object;
            pendingWrite.promise = channelPromise;
            return pendingWrite;
        }

        private void recycle() {
            this.size = 0L;
            this.next = null;
            this.msg = null;
            this.promise = null;
            this.handle.recycle(this);
        }
    }
}

