/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufHolder;
import io.netty.buffer.Unpooled;
import io.netty.channel.AbstractChannel;
import io.netty.channel.Channel;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelProgressivePromise;
import io.netty.channel.ChannelPromise;
import io.netty.channel.FileRegion;
import io.netty.channel.VoidChannelPromise;
import io.netty.util.Recycler;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.FastThreadLocal;
import io.netty.util.internal.InternalThreadLocalMap;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.ThrowableUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;

public final class ChannelOutboundBuffer {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ChannelOutboundBuffer.class);
    private static final FastThreadLocal<ByteBuffer[]> NIO_BUFFERS = new FastThreadLocal<ByteBuffer[]>(){

        @Override
        protected ByteBuffer[] initialValue() throws Exception {
            return new ByteBuffer[1024];
        }
    };
    private final Channel channel;
    private Entry flushedEntry;
    private Entry unflushedEntry;
    private Entry tailEntry;
    private int flushed;
    private int nioBufferCount;
    private long nioBufferSize;
    private boolean inFail;
    private static final AtomicLongFieldUpdater<ChannelOutboundBuffer> TOTAL_PENDING_SIZE_UPDATER;
    private volatile long totalPendingSize;
    private static final AtomicIntegerFieldUpdater<ChannelOutboundBuffer> UNWRITABLE_UPDATER;
    private volatile int unwritable;
    private volatile Runnable fireChannelWritabilityChangedTask;

    ChannelOutboundBuffer(AbstractChannel abstractChannel) {
        this.channel = abstractChannel;
    }

    public void addMessage(Object object, int n, ChannelPromise channelPromise) {
        Entry entry = Entry.newInstance(object, n, ChannelOutboundBuffer.total(object), channelPromise);
        if (this.tailEntry == null) {
            this.flushedEntry = null;
            this.tailEntry = entry;
        } else {
            Entry entry2 = this.tailEntry;
            entry2.next = entry;
            this.tailEntry = entry;
        }
        if (this.unflushedEntry == null) {
            this.unflushedEntry = entry;
        }
        this.incrementPendingOutboundBytes(n, false);
    }

    public void addFlush() {
        Entry entry = this.unflushedEntry;
        if (entry != null) {
            if (this.flushedEntry == null) {
                this.flushedEntry = entry;
            }
            do {
                ++this.flushed;
                if (entry.promise.setUncancellable()) continue;
                int n = entry.cancel();
                this.decrementPendingOutboundBytes(n, false, true);
            } while ((entry = entry.next) != null);
            this.unflushedEntry = null;
        }
    }

    void incrementPendingOutboundBytes(long l) {
        this.incrementPendingOutboundBytes(l, true);
    }

    private void incrementPendingOutboundBytes(long l, boolean bl) {
        if (l == 0L) {
            return;
        }
        long l2 = TOTAL_PENDING_SIZE_UPDATER.addAndGet(this, l);
        if (l2 >= (long)this.channel.config().getWriteBufferHighWaterMark()) {
            this.setUnwritable(bl);
        }
    }

    void decrementPendingOutboundBytes(long l) {
        this.decrementPendingOutboundBytes(l, true, true);
    }

    private void decrementPendingOutboundBytes(long l, boolean bl, boolean bl2) {
        if (l == 0L) {
            return;
        }
        long l2 = TOTAL_PENDING_SIZE_UPDATER.addAndGet(this, -l);
        if (bl2 && (l2 == 0L || l2 <= (long)this.channel.config().getWriteBufferLowWaterMark())) {
            this.setWritable(bl);
        }
    }

    private static long total(Object object) {
        if (object instanceof ByteBuf) {
            return ((ByteBuf)object).readableBytes();
        }
        if (object instanceof FileRegion) {
            return ((FileRegion)object).count();
        }
        if (object instanceof ByteBufHolder) {
            return ((ByteBufHolder)object).content().readableBytes();
        }
        return -1L;
    }

    public Object current() {
        Entry entry = this.flushedEntry;
        if (entry == null) {
            return null;
        }
        return entry.msg;
    }

    public void progress(long l) {
        Entry entry = this.flushedEntry;
        assert (entry != null);
        ChannelPromise channelPromise = entry.promise;
        if (channelPromise instanceof ChannelProgressivePromise) {
            long l2;
            entry.progress = l2 = entry.progress + l;
            ((ChannelProgressivePromise)channelPromise).tryProgress(l2, entry.total);
        }
    }

    public boolean remove() {
        Entry entry = this.flushedEntry;
        if (entry == null) {
            this.clearNioBuffers();
            return false;
        }
        Object object = entry.msg;
        ChannelPromise channelPromise = entry.promise;
        int n = entry.pendingSize;
        this.removeEntry(entry);
        if (!entry.cancelled) {
            ReferenceCountUtil.safeRelease(object);
            ChannelOutboundBuffer.safeSuccess(channelPromise);
            this.decrementPendingOutboundBytes(n, false, true);
        }
        entry.recycle();
        return true;
    }

    public boolean remove(Throwable throwable) {
        return this.remove0(throwable, true);
    }

    private boolean remove0(Throwable throwable, boolean bl) {
        Entry entry = this.flushedEntry;
        if (entry == null) {
            this.clearNioBuffers();
            return false;
        }
        Object object = entry.msg;
        ChannelPromise channelPromise = entry.promise;
        int n = entry.pendingSize;
        this.removeEntry(entry);
        if (!entry.cancelled) {
            ReferenceCountUtil.safeRelease(object);
            ChannelOutboundBuffer.safeFail(channelPromise, throwable);
            this.decrementPendingOutboundBytes(n, false, bl);
        }
        entry.recycle();
        return true;
    }

    private void removeEntry(Entry entry) {
        if (--this.flushed == 0) {
            this.flushedEntry = null;
            if (entry == this.tailEntry) {
                this.tailEntry = null;
                this.unflushedEntry = null;
            }
        } else {
            this.flushedEntry = entry.next;
        }
    }

    public void removeBytes(long l) {
        block5: {
            int n;
            ByteBuf byteBuf;
            while (true) {
                Object object;
                if (!((object = this.current()) instanceof ByteBuf)) {
                    assert (l == 0L);
                    break block5;
                }
                byteBuf = (ByteBuf)object;
                n = byteBuf.readerIndex();
                int n2 = byteBuf.writerIndex() - n;
                if ((long)n2 > l) break;
                if (l != 0L) {
                    this.progress(n2);
                    l -= (long)n2;
                }
                this.remove();
            }
            if (l != 0L) {
                byteBuf.readerIndex(n + (int)l);
                this.progress(l);
            }
        }
        this.clearNioBuffers();
    }

    private void clearNioBuffers() {
        int n = this.nioBufferCount;
        if (n > 0) {
            this.nioBufferCount = 0;
            Arrays.fill(NIO_BUFFERS.get(), 0, n, null);
        }
    }

    public ByteBuffer[] nioBuffers() {
        long l = 0L;
        int n = 0;
        InternalThreadLocalMap internalThreadLocalMap = InternalThreadLocalMap.get();
        ByteBuffer[] byteBufferArray = NIO_BUFFERS.get(internalThreadLocalMap);
        Entry entry = this.flushedEntry;
        while (this.isFlushedEntry(entry) && entry.msg instanceof ByteBuf) {
            if (!entry.cancelled) {
                ByteBuf byteBuf = (ByteBuf)entry.msg;
                int n2 = byteBuf.readerIndex();
                int n3 = byteBuf.writerIndex() - n2;
                if (n3 > 0) {
                    Object object;
                    int n4;
                    if ((long)(Integer.MAX_VALUE - n3) < l) break;
                    l += (long)n3;
                    int n5 = entry.count;
                    if (n5 == -1) {
                        entry.count = n5 = byteBuf.nioBufferCount();
                    }
                    if ((n4 = n + n5) > byteBufferArray.length) {
                        byteBufferArray = ChannelOutboundBuffer.expandNioBufferArray(byteBufferArray, n4, n);
                        NIO_BUFFERS.set(internalThreadLocalMap, byteBufferArray);
                    }
                    if (n5 == 1) {
                        object = entry.buf;
                        if (object == null) {
                            object = byteBuf.internalNioBuffer(n2, n3);
                            entry.buf = object;
                        }
                        byteBufferArray[n++] = object;
                    } else {
                        object = entry.bufs;
                        if (object == null) {
                            object = byteBuf.nioBuffers();
                            entry.bufs = object;
                        }
                        n = ChannelOutboundBuffer.fillBufferArray(object, byteBufferArray, n);
                    }
                }
            }
            entry = entry.next;
        }
        this.nioBufferCount = n;
        this.nioBufferSize = l;
        return byteBufferArray;
    }

    private static int fillBufferArray(ByteBuffer[] byteBufferArray, ByteBuffer[] byteBufferArray2, int n) {
        for (ByteBuffer byteBuffer : byteBufferArray) {
            if (byteBuffer == null) break;
            byteBufferArray2[n++] = byteBuffer;
        }
        return n;
    }

    private static ByteBuffer[] expandNioBufferArray(ByteBuffer[] byteBufferArray, int n, int n2) {
        int n3 = byteBufferArray.length;
        do {
            if ((n3 <<= 1) >= 0) continue;
            throw new IllegalStateException();
        } while (n > n3);
        ByteBuffer[] byteBufferArray2 = new ByteBuffer[n3];
        System.arraycopy(byteBufferArray, 0, byteBufferArray2, 0, n2);
        return byteBufferArray2;
    }

    public int nioBufferCount() {
        return this.nioBufferCount;
    }

    public long nioBufferSize() {
        return this.nioBufferSize;
    }

    public boolean isWritable() {
        return this.unwritable == 0;
    }

    public boolean getUserDefinedWritability(int n) {
        return (this.unwritable & ChannelOutboundBuffer.writabilityMask(n)) == 0;
    }

    public void setUserDefinedWritability(int n, boolean bl) {
        if (bl) {
            this.setUserDefinedWritability(n);
        } else {
            this.clearUserDefinedWritability(n);
        }
    }

    private void setUserDefinedWritability(int n) {
        block1: {
            int n2;
            int n3;
            int n4 = ~ChannelOutboundBuffer.writabilityMask(n);
            while (!UNWRITABLE_UPDATER.compareAndSet(this, n3 = this.unwritable, n2 = n3 & n4)) {
            }
            if (n3 == 0 || n2 != 0) break block1;
            this.fireChannelWritabilityChanged(true);
        }
    }

    private void clearUserDefinedWritability(int n) {
        block1: {
            int n2;
            int n3;
            int n4 = ChannelOutboundBuffer.writabilityMask(n);
            while (!UNWRITABLE_UPDATER.compareAndSet(this, n3 = this.unwritable, n2 = n3 | n4)) {
            }
            if (n3 != 0 || n2 == 0) break block1;
            this.fireChannelWritabilityChanged(true);
        }
    }

    private static int writabilityMask(int n) {
        if (n < 1 || n > 31) {
            throw new IllegalArgumentException("index: " + n + " (expected: 1~31)");
        }
        return 1 << n;
    }

    private void setWritable(boolean bl) {
        block1: {
            int n;
            int n2;
            while (!UNWRITABLE_UPDATER.compareAndSet(this, n2 = this.unwritable, n = n2 & 0xFFFFFFFE)) {
            }
            if (n2 == 0 || n != 0) break block1;
            this.fireChannelWritabilityChanged(bl);
        }
    }

    private void setUnwritable(boolean bl) {
        block1: {
            int n;
            int n2;
            while (!UNWRITABLE_UPDATER.compareAndSet(this, n2 = this.unwritable, n = n2 | 1)) {
            }
            if (n2 != 0 || n == 0) break block1;
            this.fireChannelWritabilityChanged(bl);
        }
    }

    private void fireChannelWritabilityChanged(boolean bl) {
        final ChannelPipeline channelPipeline = this.channel.pipeline();
        if (bl) {
            Runnable runnable = this.fireChannelWritabilityChangedTask;
            if (runnable == null) {
                this.fireChannelWritabilityChangedTask = runnable = new Runnable(){

                    @Override
                    public void run() {
                        channelPipeline.fireChannelWritabilityChanged();
                    }
                };
            }
            this.channel.eventLoop().execute(runnable);
        } else {
            channelPipeline.fireChannelWritabilityChanged();
        }
    }

    public int size() {
        return this.flushed;
    }

    public boolean isEmpty() {
        return this.flushed == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void failFlushed(Throwable throwable, boolean bl) {
        if (this.inFail) {
            return;
        }
        try {
            this.inFail = true;
            while (this.remove0(throwable, bl)) {
            }
        }
        finally {
            this.inFail = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close(final ClosedChannelException closedChannelException) {
        if (this.inFail) {
            this.channel.eventLoop().execute(new Runnable(){

                @Override
                public void run() {
                    ChannelOutboundBuffer.this.close(closedChannelException);
                }
            });
            return;
        }
        this.inFail = true;
        if (this.channel.isOpen()) {
            throw new IllegalStateException("close() must be invoked after the channel is closed.");
        }
        if (!this.isEmpty()) {
            throw new IllegalStateException("close() must be invoked after all flushed writes are handled.");
        }
        try {
            for (Entry entry = this.unflushedEntry; entry != null; entry = entry.recycleAndGetNext()) {
                int n = entry.pendingSize;
                TOTAL_PENDING_SIZE_UPDATER.addAndGet(this, -n);
                if (entry.cancelled) continue;
                ReferenceCountUtil.safeRelease(entry.msg);
                ChannelOutboundBuffer.safeFail(entry.promise, closedChannelException);
            }
        }
        finally {
            this.inFail = false;
        }
        this.clearNioBuffers();
    }

    private static void safeSuccess(ChannelPromise channelPromise) {
        if (!(channelPromise instanceof VoidChannelPromise) && !channelPromise.trySuccess()) {
            Throwable throwable = channelPromise.cause();
            if (throwable == null) {
                logger.warn("Failed to mark a promise as success because it has succeeded already: {}", (Object)channelPromise);
            } else {
                logger.warn("Failed to mark a promise as success because it has failed already: {}, unnotified cause {}", (Object)channelPromise, (Object)ThrowableUtil.stackTraceToString(throwable));
            }
        }
    }

    private static void safeFail(ChannelPromise channelPromise, Throwable throwable) {
        if (!(channelPromise instanceof VoidChannelPromise) && !channelPromise.tryFailure(throwable)) {
            Throwable throwable2 = channelPromise.cause();
            if (throwable2 == null) {
                logger.warn("Failed to mark a promise as failure because it has succeeded already: {}", (Object)channelPromise, (Object)throwable);
            } else {
                logger.warn("Failed to mark a promise as failure because it has failed already: {}, unnotified cause {}", channelPromise, ThrowableUtil.stackTraceToString(throwable2), throwable);
            }
        }
    }

    @Deprecated
    public void recycle() {
    }

    public long totalPendingWriteBytes() {
        return this.totalPendingSize;
    }

    public long bytesBeforeUnwritable() {
        long l = (long)this.channel.config().getWriteBufferHighWaterMark() - this.totalPendingSize;
        if (l > 0L) {
            return this.isWritable() ? l : 0L;
        }
        return 0L;
    }

    public long bytesBeforeWritable() {
        long l = this.totalPendingSize - (long)this.channel.config().getWriteBufferLowWaterMark();
        if (l > 0L) {
            return this.isWritable() ? 0L : l;
        }
        return 0L;
    }

    public void forEachFlushedMessage(MessageProcessor messageProcessor) throws Exception {
        if (messageProcessor == null) {
            throw new NullPointerException("processor");
        }
        Entry entry = this.flushedEntry;
        if (entry == null) {
            return;
        }
        do {
            if (entry.cancelled || messageProcessor.processMessage(entry.msg)) continue;
            return;
        } while (this.isFlushedEntry(entry = entry.next));
    }

    private boolean isFlushedEntry(Entry entry) {
        return entry != null && entry != this.unflushedEntry;
    }

    static {
        AtomicIntegerFieldUpdater<ChannelOutboundBuffer> atomicIntegerFieldUpdater = PlatformDependent.newAtomicIntegerFieldUpdater(ChannelOutboundBuffer.class, "unwritable");
        if (atomicIntegerFieldUpdater == null) {
            atomicIntegerFieldUpdater = AtomicIntegerFieldUpdater.newUpdater(ChannelOutboundBuffer.class, "unwritable");
        }
        UNWRITABLE_UPDATER = atomicIntegerFieldUpdater;
        AtomicLongFieldUpdater<ChannelOutboundBuffer> atomicLongFieldUpdater = PlatformDependent.newAtomicLongFieldUpdater(ChannelOutboundBuffer.class, "totalPendingSize");
        if (atomicLongFieldUpdater == null) {
            atomicLongFieldUpdater = AtomicLongFieldUpdater.newUpdater(ChannelOutboundBuffer.class, "totalPendingSize");
        }
        TOTAL_PENDING_SIZE_UPDATER = atomicLongFieldUpdater;
    }

    static final class Entry {
        private static final Recycler<Entry> RECYCLER = new Recycler<Entry>(){

            @Override
            protected Entry newObject(Recycler.Handle handle) {
                return new Entry(handle);
            }
        };
        private final Recycler.Handle<Entry> handle;
        Entry next;
        Object msg;
        ByteBuffer[] bufs;
        ByteBuffer buf;
        ChannelPromise promise;
        long progress;
        long total;
        int pendingSize;
        int count = -1;
        boolean cancelled;

        private Entry(Recycler.Handle<Entry> handle) {
            this.handle = handle;
        }

        static Entry newInstance(Object object, int n, long l, ChannelPromise channelPromise) {
            Entry entry = RECYCLER.get();
            entry.msg = object;
            entry.pendingSize = n;
            entry.total = l;
            entry.promise = channelPromise;
            return entry;
        }

        int cancel() {
            if (!this.cancelled) {
                this.cancelled = true;
                int n = this.pendingSize;
                ReferenceCountUtil.safeRelease(this.msg);
                this.msg = Unpooled.EMPTY_BUFFER;
                this.pendingSize = 0;
                this.total = 0L;
                this.progress = 0L;
                this.bufs = null;
                this.buf = null;
                return n;
            }
            return 0;
        }

        void recycle() {
            this.next = null;
            this.bufs = null;
            this.buf = null;
            this.msg = null;
            this.promise = null;
            this.progress = 0L;
            this.total = 0L;
            this.pendingSize = 0;
            this.count = -1;
            this.cancelled = false;
            this.handle.recycle(this);
        }

        Entry recycleAndGetNext() {
            Entry entry = this.next;
            this.recycle();
            return entry;
        }
    }

    public static interface MessageProcessor {
        public boolean processMessage(Object var1) throws Exception;
    }
}

