/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;

@ChannelHandler.Sharable
public abstract class ChannelInitializer<C extends Channel>
extends ChannelInboundHandlerAdapter {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ChannelInitializer.class);

    protected abstract void initChannel(C var1) throws Exception;

    @Override
    public final void channelRegistered(ChannelHandlerContext channelHandlerContext) throws Exception {
        this.initChannel(channelHandlerContext.channel());
        channelHandlerContext.pipeline().remove(this);
        channelHandlerContext.pipeline().fireChannelRegistered();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exceptionCaught(ChannelHandlerContext channelHandlerContext, Throwable throwable) throws Exception {
        logger.warn("Failed to initialize a channel. Closing: " + channelHandlerContext.channel(), throwable);
        try {
            ChannelPipeline channelPipeline = channelHandlerContext.pipeline();
            if (channelPipeline.context(this) != null) {
                channelPipeline.remove(this);
            }
        }
        finally {
            channelHandlerContext.close();
        }
    }
}

