/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.SwappedByteBuf;
import io.netty.buffer.WrappedByteBuf;
import java.nio.ByteOrder;

final class UnreleasableByteBuf
extends WrappedByteBuf {
    private SwappedByteBuf swappedBuf;

    UnreleasableByteBuf(ByteBuf byteBuf) {
        super(byteBuf);
    }

    @Override
    public ByteBuf order(ByteOrder byteOrder) {
        if (byteOrder == null) {
            throw new NullPointerException("endianness");
        }
        if (byteOrder == this.order()) {
            return this;
        }
        SwappedByteBuf swappedByteBuf = this.swappedBuf;
        if (swappedByteBuf == null) {
            this.swappedBuf = swappedByteBuf = new SwappedByteBuf(this);
        }
        return swappedByteBuf;
    }

    @Override
    public ByteBuf asReadOnly() {
        return new UnreleasableByteBuf(this.buf.asReadOnly());
    }

    @Override
    public ByteBuf readSlice(int n) {
        return new UnreleasableByteBuf(this.buf.readSlice(n));
    }

    @Override
    public ByteBuf readRetainedSlice(int n) {
        return new UnreleasableByteBuf(this.buf.readRetainedSlice(n));
    }

    @Override
    public ByteBuf slice() {
        return new UnreleasableByteBuf(this.buf.slice());
    }

    @Override
    public ByteBuf retainedSlice() {
        return new UnreleasableByteBuf(this.buf.retainedSlice());
    }

    @Override
    public ByteBuf slice(int n, int n2) {
        return new UnreleasableByteBuf(this.buf.slice(n, n2));
    }

    @Override
    public ByteBuf retainedSlice(int n, int n2) {
        return new UnreleasableByteBuf(this.buf.retainedSlice(n, n2));
    }

    @Override
    public ByteBuf duplicate() {
        return new UnreleasableByteBuf(this.buf.duplicate());
    }

    @Override
    public ByteBuf retainedDuplicate() {
        return new UnreleasableByteBuf(this.buf.retainedDuplicate());
    }

    @Override
    public ByteBuf retain(int n) {
        return this;
    }

    @Override
    public ByteBuf retain() {
        return this;
    }

    @Override
    public ByteBuf touch() {
        return this;
    }

    @Override
    public ByteBuf touch(Object object) {
        return this;
    }

    @Override
    public boolean release() {
        return false;
    }

    @Override
    public boolean release(int n) {
        return false;
    }
}

