/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica.styles;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.styles.StyleWrapper;
import de.javasoft.util.JavaVersion;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthStyle;

public class ToolBarStyle
extends StyleWrapper {
    private static final String ORG_FILLERS = "Synthetica.toolBarStyle.orgFillers";
    private static final String ORG_X_ALIGNMENTS = "Synthetica.toolBarStyle.orgXAlignments";
    private static final String ORG_Y_ALIGNMENTS = "Synthetica.toolBarStyle.orgYAlignments";
    private static final String ORG_MARGIN = "Synthetica.toolBarStyle.orgMargin";
    private static final String ORG_LAYOUT_MANAGER = "Synthetica.toolBarStyle.orgLayoutManager";
    private static final String ORIENTATION_LISTENER = "Synthetica.toolBarStyle.orientationListener";
    private static final String CONTAINER_LISTENER = "Synthetica.toolBarStyle.containerListener";
    private static ToolBarStyle instance = new ToolBarStyle();

    private ToolBarStyle() {
    }

    public static SynthStyle getStyle(SynthStyle synthStyle, JComponent jComponent, Region region) {
        if (SyntheticaLookAndFeel.getStyleName(jComponent) == null) {
            instance.setStyle(synthStyle);
            return instance;
        }
        ToolBarStyle toolBarStyle = new ToolBarStyle();
        toolBarStyle.setStyle(synthStyle);
        return toolBarStyle;
    }

    public void installDefaults(SynthContext synthContext) {
        this.synthStyle.installDefaults(synthContext);
        JToolBar jToolBar = (JToolBar)synthContext.getComponent();
        if (jToolBar.getClientProperty(ORG_FILLERS) == null) {
            jToolBar.putClientProperty(ORG_FILLERS, new HashMap());
        }
        HashMap hashMap = (HashMap)jToolBar.getClientProperty(ORG_FILLERS);
        if (jToolBar.getClientProperty(ORG_X_ALIGNMENTS) == null) {
            jToolBar.putClientProperty(ORG_X_ALIGNMENTS, new HashMap());
        }
        HashMap hashMap2 = (HashMap)jToolBar.getClientProperty(ORG_X_ALIGNMENTS);
        if (jToolBar.getClientProperty(ORG_Y_ALIGNMENTS) == null) {
            jToolBar.putClientProperty(ORG_Y_ALIGNMENTS, new HashMap());
        }
        HashMap hashMap3 = (HashMap)jToolBar.getClientProperty(ORG_Y_ALIGNMENTS);
        jToolBar.putClientProperty(ORG_LAYOUT_MANAGER, jToolBar.getLayout());
        jToolBar.putClientProperty(ORG_MARGIN, jToolBar.getMargin());
        jToolBar.addPropertyChangeListener(this.getOrientationListener(jToolBar));
        Component[] componentArray = jToolBar.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            Component component = componentArray[n];
            hashMap2.put(component, Float.valueOf(component.getAlignmentX()));
            hashMap3.put(component, Float.valueOf(component.getAlignmentY()));
            if (component instanceof Box.Filler) {
                hashMap.put(n, component);
            }
            ((JComponent)component).setAlignmentX(0.5f);
            ((JComponent)component).setAlignmentY(0.5f);
            ++n;
        }
        jToolBar.addContainerListener(this.getContainerListener(jToolBar));
        this.setLayoutManager(jToolBar);
    }

    private PropertyChangeListener getOrientationListener(final JToolBar jToolBar) {
        PropertyChangeListener propertyChangeListener = (PropertyChangeListener)jToolBar.getClientProperty(ORIENTATION_LISTENER);
        if (propertyChangeListener == null) {
            propertyChangeListener = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    String string = propertyChangeEvent.getPropertyName();
                    if (string.equals("orientation")) {
                        ToolBarStyle.this.setLayoutManager(jToolBar);
                    } else if (string.equals("floatable")) {
                        ToolBarStyle.this.setMargin(jToolBar, (Boolean)propertyChangeEvent.getNewValue());
                    } else if (string.equals("componentOrientation")) {
                        ToolBarStyle.this.setMargin(jToolBar, jToolBar.isFloatable());
                    }
                }
            };
            jToolBar.putClientProperty(ORIENTATION_LISTENER, propertyChangeListener);
        }
        return propertyChangeListener;
    }

    private ContainerListener getContainerListener(final JToolBar jToolBar) {
        ContainerListener containerListener = (ContainerListener)jToolBar.getClientProperty(CONTAINER_LISTENER);
        if (containerListener == null) {
            containerListener = new ContainerListener(){

                public void componentAdded(ContainerEvent containerEvent) {
                    HashMap hashMap = (HashMap)jToolBar.getClientProperty(ToolBarStyle.ORG_FILLERS);
                    HashMap hashMap2 = (HashMap)jToolBar.getClientProperty(ToolBarStyle.ORG_X_ALIGNMENTS);
                    HashMap hashMap3 = (HashMap)jToolBar.getClientProperty(ToolBarStyle.ORG_Y_ALIGNMENTS);
                    Component component = containerEvent.getChild();
                    hashMap2.put(component, Float.valueOf(component.getAlignmentX()));
                    hashMap3.put(component, Float.valueOf(component.getAlignmentY()));
                    if (component instanceof Box.Filler) {
                        hashMap.put(jToolBar.getComponents().length - 1, component);
                    }
                    if (component instanceof JComponent) {
                        ((JComponent)component).setAlignmentX(0.5f);
                        ((JComponent)component).setAlignmentY(0.5f);
                    }
                }

                public void componentRemoved(ContainerEvent containerEvent) {
                    HashMap hashMap = (HashMap)jToolBar.getClientProperty(ToolBarStyle.ORG_X_ALIGNMENTS);
                    hashMap.remove(containerEvent.getChild());
                    HashMap hashMap2 = (HashMap)jToolBar.getClientProperty(ToolBarStyle.ORG_Y_ALIGNMENTS);
                    hashMap2.remove(containerEvent.getChild());
                }
            };
            jToolBar.putClientProperty(CONTAINER_LISTENER, containerListener);
        }
        return containerListener;
    }

    public void uninstallDefaults(SynthContext synthContext) {
        this.synthStyle.uninstallDefaults(synthContext);
        JToolBar jToolBar = (JToolBar)synthContext.getComponent();
        jToolBar.removePropertyChangeListener(this.getOrientationListener(jToolBar));
        jToolBar.removeContainerListener(this.getContainerListener(jToolBar));
        HashMap hashMap = (HashMap)jToolBar.getClientProperty(ORG_FILLERS);
        HashMap hashMap2 = (HashMap)jToolBar.getClientProperty(ORG_X_ALIGNMENTS);
        HashMap hashMap3 = (HashMap)jToolBar.getClientProperty(ORG_Y_ALIGNMENTS);
        for (Map.Entry entry : hashMap.entrySet()) {
            int n = (Integer)entry.getKey();
            Component component = (Component)entry.getValue();
            jToolBar.remove(n);
            jToolBar.add(component, n);
        }
        for (Map.Entry entry : hashMap2.entrySet()) {
            JComponent jComponent = (JComponent)entry.getKey();
            float f = ((Float)entry.getValue()).floatValue();
            jComponent.setAlignmentX(f);
        }
        for (Map.Entry entry : hashMap3.entrySet()) {
            JComponent jComponent = (JComponent)entry.getKey();
            float f = ((Float)entry.getValue()).floatValue();
            jComponent.setAlignmentY(f);
        }
        jToolBar.setMargin((Insets)jToolBar.getClientProperty(ORG_MARGIN));
        jToolBar.setLayout((LayoutManager)jToolBar.getClientProperty(ORG_LAYOUT_MANAGER));
        jToolBar.putClientProperty(ORG_FILLERS, null);
        jToolBar.putClientProperty(ORG_X_ALIGNMENTS, null);
        jToolBar.putClientProperty(ORG_Y_ALIGNMENTS, null);
        jToolBar.putClientProperty(ORG_MARGIN, null);
        jToolBar.putClientProperty(ORG_LAYOUT_MANAGER, null);
        jToolBar.putClientProperty(ORIENTATION_LISTENER, null);
        jToolBar.putClientProperty(CONTAINER_LISTENER, null);
    }

    private void setLayoutManager(JToolBar jToolBar) {
        int n;
        if (this.useSynthLayout(jToolBar)) {
            return;
        }
        HashMap hashMap = (HashMap)jToolBar.getClientProperty(ORG_FILLERS);
        jToolBar.removeContainerListener(this.getContainerListener(jToolBar));
        Component[] componentArray = jToolBar.getComponents();
        SyntheticaToolBarLayout syntheticaToolBarLayout = null;
        if (jToolBar.getOrientation() == 0) {
            syntheticaToolBarLayout = new SyntheticaToolBarLayout(jToolBar, 2);
            n = 0;
            while (n < componentArray.length) {
                if (componentArray[n] instanceof Box.Filler && this.fillerIsGlue((Box.Filler)componentArray[n])) {
                    jToolBar.remove(componentArray[n]);
                    jToolBar.add(Box.createHorizontalGlue(), n);
                } else if (componentArray[n] instanceof Box.Filler && !this.fillerIsGlue((Box.Filler)componentArray[n])) {
                    jToolBar.remove(componentArray[n]);
                    Component component = (Component)hashMap.get(n);
                    Dimension dimension = component.getPreferredSize();
                    int n2 = Math.max(dimension.width, dimension.height);
                    jToolBar.add(Box.createHorizontalStrut(n2), n);
                }
                ++n;
            }
            this.setMargin(jToolBar, jToolBar.isFloatable());
            n = 0;
            while (n < componentArray.length) {
                ((JComponent)componentArray[n]).setAlignmentY(0.5f);
                ++n;
            }
        } else {
            syntheticaToolBarLayout = new SyntheticaToolBarLayout(jToolBar, 3);
            n = 0;
            while (n < componentArray.length) {
                if (componentArray[n] instanceof Box.Filler && this.fillerIsGlue((Box.Filler)componentArray[n])) {
                    jToolBar.remove(componentArray[n]);
                    jToolBar.add(Box.createVerticalGlue(), n);
                } else if (componentArray[n] instanceof Box.Filler && !this.fillerIsGlue((Box.Filler)componentArray[n])) {
                    jToolBar.remove(componentArray[n]);
                    Component component = (Component)hashMap.get(n);
                    Dimension dimension = component.getPreferredSize();
                    int n3 = Math.max(dimension.width, dimension.height);
                    jToolBar.add(Box.createVerticalStrut(n3), n);
                }
                ++n;
            }
            this.setMargin(jToolBar, jToolBar.isFloatable());
            n = 0;
            while (n < componentArray.length) {
                ((JComponent)componentArray[n]).setAlignmentX(0.5f);
                ++n;
            }
        }
        LayoutManager layoutManager = jToolBar.getLayout();
        if (layoutManager != null && (layoutManager.getClass().getName().contains("SynthToolBar") || layoutManager instanceof SyntheticaToolBarLayout)) {
            jToolBar.setLayout(syntheticaToolBarLayout);
        }
        jToolBar.addContainerListener(this.getContainerListener(jToolBar));
    }

    private void setMargin(JToolBar jToolBar, boolean bl) {
        if (this.useSynthLayout(jToolBar)) {
            return;
        }
        Insets insets = null;
        if (jToolBar.getOrientation() == 0) {
            insets = (Insets)SyntheticaLookAndFeel.getInsets("Synthetica.toolBar.margin.horizontal", jToolBar).clone();
            if (bl && jToolBar.getComponentOrientation().isLeftToRight()) {
                insets.left += SyntheticaLookAndFeel.getInt("Synthetica.toolBar.handle.size", jToolBar, 0);
            } else if (bl) {
                insets.right += SyntheticaLookAndFeel.getInt("Synthetica.toolBar.handle.size", jToolBar, 0);
            }
        } else {
            insets = (Insets)SyntheticaLookAndFeel.getInsets("Synthetica.toolBar.margin.vertical", jToolBar).clone();
            if (bl) {
                insets.top += SyntheticaLookAndFeel.getInt("Synthetica.toolBar.handle.size", jToolBar, 0);
            }
        }
        Insets insets2 = (Insets)jToolBar.getClientProperty(ORG_MARGIN);
        if (insets2 != null && insets != null) {
            insets.bottom += insets2.bottom;
            insets.left += insets2.left;
            insets.top += insets2.top;
            insets.right += insets2.right;
            jToolBar.setMargin(insets);
        }
    }

    private boolean useSynthLayout(JComponent jComponent) {
        return SyntheticaLookAndFeel.getBoolean("Synthetica.toolBar.useSynthLayoutManager", jComponent, JavaVersion.JAVA5 ? false : false);
    }

    private boolean fillerIsGlue(Box.Filler filler) {
        Dimension dimension = new Dimension(0, 0);
        return filler.getMinimumSize().equals(dimension) && filler.getPreferredSize().equals(dimension);
    }

    private static class SyntheticaToolBarLayout
    extends BoxLayout {
        private static final long serialVersionUID = 6806218476946368742L;

        SyntheticaToolBarLayout(Container container, int n) {
            super(container, n);
        }
    }
}

