/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.util.pattern;

import de.dal33t.powerfolder.util.Reject;
import de.dal33t.powerfolder.util.pattern.AbstractPattern;

public class StartMatchPattern
extends AbstractPattern {
    private char[] matchLower;
    private char[] matchUpper;

    public StartMatchPattern(String string) {
        super(string);
        Reject.ifFalse(string.indexOf("*") == string.length() - 1, "Pattern must end with * and should not contain any other stars");
        this.matchLower = this.getPatternText().replaceAll("\\*", "").toLowerCase().toCharArray();
        this.matchUpper = this.getPatternText().replaceAll("\\*", "").replace("\u00df", "s").toUpperCase().toCharArray();
    }

    @Override
    public boolean isMatch(String string) {
        if (string.length() < this.matchLower.length) {
            return false;
        }
        for (int i = 0; i < this.matchLower.length; ++i) {
            char c = string.charAt(i);
            if (StartMatchPattern.equalChar(c, this.matchLower[i], this.matchUpper[i])) continue;
            return false;
        }
        return true;
    }
}

