/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.util.os;

import de.dal33t.powerfolder.util.os.OSUtil;
import de.dal33t.powerfolder.util.os.Win32.RecycleDeleteImpl;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;

public class RecycleDelete {
    private static boolean isWinLibLoaded = false;

    public static boolean isSupported() {
        return OSUtil.isWindowsSystem() && !OSUtil.isWindowsMEorOlder() && isWinLibLoaded;
    }

    public static boolean progressSupported() {
        return OSUtil.isWindowsSystem() && isWinLibLoaded;
    }

    public static boolean confirmSupported() {
        return OSUtil.isWindowsSystem() && isWinLibLoaded;
    }

    public static void delete(String string) {
        if (!RecycleDelete.isSupported()) {
            throw new UnsupportedOperationException("delete not supported on this platform");
        }
        Path path = Paths.get(string, new String[0]);
        if (Files.notExists(path, new LinkOption[0])) {
            throw new IllegalStateException("file does not exists");
        }
        RecycleDeleteImpl.delete(string);
    }

    public static void delete(String string, boolean bl) {
        if (!RecycleDelete.confirmSupported()) {
            throw new UnsupportedOperationException("delete with confirm not supported on this platform");
        }
        if (!RecycleDelete.isSupported()) {
            throw new UnsupportedOperationException("delete not supported on this platform");
        }
        Path path = Paths.get(string, new String[0]);
        if (Files.notExists(path, new LinkOption[0])) {
            throw new IllegalStateException("file does not exists");
        }
        RecycleDeleteImpl.delete(string, bl);
    }

    public static void delete(String string, boolean bl, boolean bl2) {
        if (!RecycleDelete.confirmSupported()) {
            throw new UnsupportedOperationException("delete with confirm not supported on this platform");
        }
        if (!RecycleDelete.isSupported()) {
            throw new UnsupportedOperationException("delete not supported on this platform");
        }
        if (!RecycleDelete.progressSupported()) {
            throw new UnsupportedOperationException("delete with progress bar not supported on this platform");
        }
        Path path = Paths.get(string, new String[0]);
        if (Files.notExists(path, new LinkOption[0])) {
            throw new IllegalStateException("file does not exists");
        }
        RecycleDeleteImpl.delete(string, bl, bl2);
    }

    static {
        if (OSUtil.isWindowsSystem()) {
            isWinLibLoaded = RecycleDeleteImpl.loadLibrary();
        }
    }
}

