/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.util.net;

import de.dal33t.powerfolder.util.os.OSUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;

public class UDTSocket {
    private static final Logger LOG = Logger.getLogger(UDTSocket.class.getName());
    private static boolean supported = false;
    public static final AtomicInteger openSockets = new AtomicInteger(0);
    private volatile boolean closed = false;
    private volatile boolean connected = false;
    private InputStream in;
    private OutputStream out;
    private int sock = -1;
    private InetSocketAddress remoteAddress;

    public static boolean isSupported() {
        return supported;
    }

    public UDTSocket() {
        this.sock = UDTSocket.socket();
        if (openSockets.incrementAndGet() > 20) {
            LOG.warning("Many open UDT sockets (" + openSockets.get() + ")");
        }
    }

    private UDTSocket(int n) {
        this.sock = n;
        this.connected = true;
    }

    public UDTSocket accept() throws IOException {
        UDTSocket uDTSocket = this.acceptImpl();
        uDTSocket.remoteAddress = uDTSocket.getRemoteAddressImpl();
        return uDTSocket;
    }

    public native void bind(InetSocketAddress var1) throws IOException;

    public void close() throws IOException {
        this.closed = true;
        this.connected = false;
        this.closeImpl();
        openSockets.decrementAndGet();
    }

    public void connect(InetSocketAddress inetSocketAddress) throws IOException {
        this.connectImpl(inetSocketAddress);
        this.connected = true;
        this.remoteAddress = this.getRemoteAddressImpl();
    }

    public InputStream getInputStream() throws IOException {
        if (this.in == null) {
            this.in = new UDTInputStream();
        }
        return this.in;
    }

    public native InetSocketAddress getLocalAddress();

    public OutputStream getOutputStream() throws IOException {
        if (this.out == null) {
            this.out = new UDTOutputStream();
        }
        return this.out;
    }

    public InetSocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public native void listen(int var1) throws IOException;

    public native void setSoRendezvous(boolean var1);

    public native boolean getSoRendezvous();

    public native void setSoLinger(boolean var1, int var2);

    public native int getSoLinger();

    public native void setSoReceiverBufferLimit(int var1) throws IOException;

    public native int getSoReceiverBufferLimit() throws IOException;

    public native void setSoSenderBufferLimit(int var1) throws IOException;

    public native int getSoSenderBufferLimit() throws IOException;

    public native void setSoUDPReceiverBufferSize(int var1) throws IOException;

    public native int getSoUDPReceiverBufferSize() throws IOException;

    public native void setSoUDPSenderBufferSize(int var1) throws IOException;

    public native int getSoUDPSenderBufferSize() throws IOException;

    public String toString() {
        return "{UDTSocket: closed: " + this.closed + ", connected:" + this.connected + ", fd:" + this.sock + "}";
    }

    private native UDTSocket acceptImpl() throws IOException;

    private native void closeImpl() throws IOException;

    private native void connectImpl(InetSocketAddress var1) throws IOException;

    private native InetSocketAddress getRemoteAddressImpl();

    private native int recv(byte[] var1, int var2, int var3) throws IOException;

    private native void send(byte[] var1, int var2, int var3) throws IOException;

    private static native void initIDs();

    private static native int socket();

    static {
        if (OSUtil.isWindowsSystem() && OSUtil.loadLibrary(UDTSocket.class, "udt") && OSUtil.loadLibrary(UDTSocket.class, "udt4j")) {
            UDTSocket.initIDs();
            supported = true;
        }
    }

    private class UDTInputStream
    extends InputStream {
        private UDTInputStream() {
        }

        @Override
        public int read() throws IOException {
            byte[] byArray = new byte[1];
            try {
                return UDTSocket.this.recv(byArray, 0, 1);
            }
            catch (IOException iOException) {
                UDTSocket.this.connected = false;
                throw iOException;
            }
        }

        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            if (n < 0 || n2 < 0 || n2 > byArray.length - n) {
                throw new IndexOutOfBoundsException(byArray.length + " from:" + n + " len:" + n2);
            }
            try {
                return UDTSocket.this.recv(byArray, n, n2);
            }
            catch (IOException iOException) {
                UDTSocket.this.connected = false;
                throw iOException;
            }
        }
    }

    private class UDTOutputStream
    extends OutputStream {
        private UDTOutputStream() {
        }

        @Override
        public void write(byte[] byArray, int n, int n2) throws IOException {
            if (n < 0 || n2 < 0 || n2 > byArray.length - n) {
                throw new IndexOutOfBoundsException(byArray.length + " from:" + n + " len:" + n2);
            }
            try {
                UDTSocket.this.send(byArray, n, n2);
            }
            catch (IOException iOException) {
                UDTSocket.this.connected = false;
                throw iOException;
            }
        }

        @Override
        public void write(int n) throws IOException {
            byte[] byArray = new byte[]{(byte)n};
            try {
                UDTSocket.this.send(byArray, 0, 1);
            }
            catch (IOException iOException) {
                UDTSocket.this.connected = false;
                throw iOException;
            }
        }
    }
}

