/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.util.net;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.text.ParseException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class AddressRange {
    private static Pattern addressPattern = Pattern.compile("\\s*((?:\\d{1,3})(?:\\.(?:\\d){1,3}){3})\\s*(?:-\\s*((?:\\d{1,3})(?:\\.(?:\\d){1,3}){3}))?\\s*");
    private Inet4Address start;
    private Inet4Address end;

    public AddressRange(Inet4Address inet4Address, Inet4Address inet4Address2) {
        this.start = inet4Address;
        this.end = inet4Address2;
    }

    public static AddressRange parseRange(String string) throws ParseException {
        try {
            Matcher matcher = addressPattern.matcher(string);
            matcher.matches();
            String string2 = matcher.group(2);
            if (string2 == null) {
                string2 = matcher.group(1);
            }
            return new AddressRange((Inet4Address)InetAddress.getByName(matcher.group(1)), (Inet4Address)InetAddress.getByName(string2));
        }
        catch (Throwable throwable) {
            throw new ParseException(string, 0);
        }
    }

    public Inet4Address getEnd() {
        return this.end;
    }

    public boolean contains(InetAddress inetAddress) {
        if (inetAddress instanceof Inet4Address) {
            return this.contains((Inet4Address)inetAddress);
        }
        return false;
    }

    public boolean contains(Inet4Address inet4Address) {
        byte[] byArray = this.start.getAddress();
        byte[] byArray2 = this.end.getAddress();
        byte[] byArray3 = inet4Address.getAddress();
        for (int i = 0; i < byArray.length; ++i) {
            int n = byArray3[i] & 0xFF;
            int n2 = byArray[i] & 0xFF;
            int n3 = byArray2[i] & 0xFF;
            if (n > n3 || n < n2) {
                return false;
            }
            if (n <= n2 || n >= n3) continue;
            return true;
        }
        return true;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.end == null ? 0 : this.end.hashCode());
        n = 31 * n + (this.start == null ? 0 : this.start.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        AddressRange addressRange = (AddressRange)object;
        if (this.end == null ? addressRange.end != null : !this.end.equals(addressRange.end)) {
            return false;
        }
        return !(this.start == null ? addressRange.start != null : !this.start.equals(addressRange.start));
    }

    public Inet4Address getStart() {
        return this.start;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        String string = this.start.toString();
        stringBuilder.append(string.substring(string.indexOf(47) + 1));
        if (!this.end.equals(this.start)) {
            stringBuilder.append('-');
            string = this.end.toString();
            stringBuilder.append(string.substring(string.indexOf(47) + 1));
        }
        return stringBuilder.toString();
    }
}

