/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.util.logging;

import de.dal33t.powerfolder.ConfigurationEntry;
import de.dal33t.powerfolder.Constants;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.PreferencesEntry;
import de.dal33t.powerfolder.util.PathUtils;
import de.dal33t.powerfolder.util.Reject;
import de.dal33t.powerfolder.util.Util;
import de.dal33t.powerfolder.util.logging.LoggingFormatter;
import de.dal33t.powerfolder.util.logging.handlers.AbstractSyslogHandler;
import de.dal33t.powerfolder.util.logging.handlers.BufferedHandler;
import de.dal33t.powerfolder.util.logging.handlers.ConsoleHandler;
import de.dal33t.powerfolder.util.logging.handlers.CountingHandler;
import de.dal33t.powerfolder.util.logging.handlers.DocumentHandler;
import de.dal33t.powerfolder.util.logging.handlers.TCPTLSSyslogHandler;
import de.dal33t.powerfolder.util.logging.handlers.UDPSyslogHandler;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.FileHandler;
import java.util.logging.Filter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.text.StyledDocument;

public class LoggingManager {
    private static final String DEBUG_DIR = "logs";
    private static String LOGFILE_PREFIX = Constants.MISC_DIR_NAME;
    private static String LOGFILE_SUFFIX = "-log.txt";
    private static final DocumentHandler documentHandler;
    private static final ConsoleHandler consoleHandler;
    private static final BufferedHandler bufferedHandler;
    private static final CountingHandler countingHandler;
    private static FileHandler fileHandler;
    private static AbstractSyslogHandler syslogHandler;
    private static final Object fileHandlerLock;
    private static Level documentLoggingLevel;
    private static Level consoleLoggingLevel;
    private static Level fileLoggingLevel;
    private static String fileLoggingFileName;
    private static Level syslogLoggingLevel;
    private static boolean fileRotate;
    private static Level bufferedLoggingLevel;
    private static Filter DEFAULT_FILTER;

    public static void setConsoleLogging(Level level) {
        if (consoleLoggingLevel == null) {
            LoggingManager.getRootLogger().addHandler(consoleHandler);
        }
        consoleLoggingLevel = level;
        consoleHandler.setLevel(level);
        LoggingManager.setMinimumBaseLoggingLevel();
    }

    public static void setDocumentLogging(Level level, Controller controller) {
        if (documentLoggingLevel == null) {
            LoggingManager.getRootLogger().addHandler(documentHandler);
        }
        documentLoggingLevel = level;
        documentHandler.setLevel(level);
        PreferencesEntry.DOCUMENT_LOGGING.setValue(controller, level.getName());
        LoggingManager.setMinimumBaseLoggingLevel();
    }

    public static void setFileLogging(Level level, boolean bl) {
        fileLoggingLevel = level;
        fileRotate = bl;
        if (fileHandler == null) {
            LoggingManager.createFileHandler(fileLoggingLevel);
        }
        LoggingManager.setMinimumBaseLoggingLevel();
    }

    public static void setBufferedLogging(Level level) {
        if (bufferedLoggingLevel == null) {
            LoggingManager.getRootLogger().addHandler(bufferedHandler);
        }
        bufferedLoggingLevel = level;
        bufferedHandler.setLevel(level);
        LoggingManager.setMinimumBaseLoggingLevel();
    }

    public static void setSyslogLogging(Level level, Controller controller) {
        String string;
        if (syslogHandler != null) {
            LoggingManager.getRootLogger().removeHandler(syslogHandler);
        }
        try {
            string = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            string = ConfigurationEntry.HOSTNAME.getValue(controller);
        }
        String string2 = ConfigurationEntry.LOG_SYSLOG_HOST.getValue(controller);
        int n = ConfigurationEntry.LOG_SYSLOG_PORT.getValueInt(controller);
        String string3 = ConfigurationEntry.LOG_SYSLOG_CONNECTION.getValue(controller);
        boolean bl = string3.toUpperCase().contains("TLS");
        if ("TCP".equalsIgnoreCase(string3) || bl) {
            TCPTLSSyslogHandler tCPTLSSyslogHandler = new TCPTLSSyslogHandler();
            tCPTLSSyslogHandler.init(string, string2, n, bl);
            syslogHandler = tCPTLSSyslogHandler;
        } else {
            UDPSyslogHandler uDPSyslogHandler = new UDPSyslogHandler();
            uDPSyslogHandler.init(string, string2, n);
            syslogHandler = uDPSyslogHandler;
        }
        syslogLoggingLevel = level;
        syslogHandler.setLevel(level);
        LoggingManager.getRootLogger().addHandler(syslogHandler);
        LoggingManager.setMinimumBaseLoggingLevel();
    }

    public static void clearBuffer() {
        if (bufferedHandler != null) {
            bufferedHandler.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createFileHandler(Level level) {
        Object object = fileHandlerLock;
        synchronized (object) {
            try {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
                Object object2 = LOGFILE_PREFIX;
                if (fileRotate) {
                    object2 = (String)object2 + "-";
                    object2 = (String)object2 + simpleDateFormat.format(new Date());
                }
                object2 = (String)object2 + LOGFILE_SUFFIX;
                fileLoggingFileName = LoggingManager.getDebugDir().resolve(PathUtils.removeInvalidFilenameChars((String)object2)).toAbsolutePath().toString();
                fileHandler = new FileHandler(fileLoggingFileName, true);
                fileHandler.setFormatter(new LoggingFormatter(!fileRotate));
                LoggingManager.getRootLogger().addHandler(fileHandler);
                fileHandler.setFilter(DEFAULT_FILTER);
                fileHandler.setLevel(level);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public static StyledDocument getLogBuffer() {
        Reject.ifNull(documentHandler.getLogBuffer(), "DocumentHandler not set");
        return documentHandler.getLogBuffer();
    }

    public static BufferedHandler getBufferedHandler() {
        return bufferedHandler;
    }

    public static CountingHandler getCountingHandler() {
        return countingHandler;
    }

    public static boolean isLogToFile() {
        return fileLoggingLevel != null;
    }

    public static Level getDocumentLoggingLevel() {
        if (documentLoggingLevel == null) {
            return Level.OFF;
        }
        return documentLoggingLevel;
    }

    public static Level getMinimumLoggingLevel() {
        Level level = Level.OFF;
        if (documentLoggingLevel != null && documentLoggingLevel.intValue() < level.intValue()) {
            level = documentLoggingLevel;
        }
        if (consoleLoggingLevel != null && consoleLoggingLevel.intValue() < level.intValue()) {
            level = consoleLoggingLevel;
        }
        if (fileLoggingLevel != null && fileLoggingLevel.intValue() < level.intValue()) {
            level = fileLoggingLevel;
        }
        if (bufferedLoggingLevel != null && bufferedLoggingLevel.intValue() < level.intValue()) {
            level = bufferedLoggingLevel;
        }
        return level;
    }

    private static Logger getRootLogger() {
        return Logger.getLogger("");
    }

    public static Path getDebugDir() {
        Path path = Controller.getMiscFilesLocation().resolve(DEBUG_DIR);
        if (Files.exists(path, new LinkOption[0]) && Files.isDirectory(path, new LinkOption[0])) {
            return path;
        }
        try {
            Files.createDirectories(path, new FileAttribute[0]);
        }
        catch (IOException iOException) {
            return null;
        }
        if (Files.exists(path, new LinkOption[0]) && Files.isDirectory(path, new LinkOption[0])) {
            return path;
        }
        return null;
    }

    public static void setPrefix(String string) {
        assert (string != null);
        LOGFILE_PREFIX = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getLoggingFileName() {
        Object object = fileHandlerLock;
        synchronized (object) {
            return fileLoggingFileName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setMinimumBaseLoggingLevel() {
        Level level = Level.SEVERE;
        if (documentLoggingLevel != null && documentLoggingLevel.intValue() < level.intValue()) {
            level = documentLoggingLevel;
        }
        if (consoleLoggingLevel != null && consoleLoggingLevel.intValue() < level.intValue()) {
            level = consoleLoggingLevel;
        }
        Object object = fileHandlerLock;
        synchronized (object) {
            if (fileLoggingLevel != null && fileLoggingLevel.intValue() < level.intValue()) {
                level = fileLoggingLevel;
            }
        }
        if (bufferedLoggingLevel != null && bufferedLoggingLevel.intValue() < level.intValue()) {
            level = bufferedLoggingLevel;
        }
        LoggingManager.getRootLogger().setLevel(level);
    }

    public static Level levelForName(String string) {
        if (string == null) {
            return null;
        }
        if (string.equalsIgnoreCase(Level.ALL.getName())) {
            return Level.ALL;
        }
        if (string.equalsIgnoreCase(Level.CONFIG.getName())) {
            return Level.CONFIG;
        }
        if (string.equalsIgnoreCase(Level.FINE.getName())) {
            return Level.FINE;
        }
        if (string.equalsIgnoreCase(Level.FINER.getName())) {
            return Level.FINER;
        }
        if (string.equalsIgnoreCase(Level.FINEST.getName())) {
            return Level.FINEST;
        }
        if (string.equalsIgnoreCase(Level.INFO.getName())) {
            return Level.INFO;
        }
        if (string.equalsIgnoreCase(Level.OFF.getName())) {
            return Level.OFF;
        }
        if (string.equalsIgnoreCase(Level.SEVERE.getName())) {
            return Level.SEVERE;
        }
        if (string.equalsIgnoreCase(Level.WARNING.getName()) || string.equalsIgnoreCase("WARN")) {
            return Level.WARNING;
        }
        return null;
    }

    public static void resetFileLogging() {
        if (fileLoggingLevel != null && fileHandler != null) {
            fileHandler.flush();
            fileHandler.close();
            LoggingManager.createFileHandler(fileLoggingLevel);
        }
    }

    public static synchronized void closeFileLogging() {
        if (fileLoggingLevel != null && fileHandler != null) {
            fileHandler.flush();
            fileHandler.close();
            fileHandler = null;
        }
    }

    public static void removeOldLogs(final int n) {
        DirectoryStream.Filter<Path> filter = new DirectoryStream.Filter<Path>(){

            @Override
            public boolean accept(Path path) {
                if (!Files.isRegularFile(path, new LinkOption[0])) {
                    return false;
                }
                if (!path.getFileName().toString().startsWith(LOGFILE_PREFIX)) {
                    return false;
                }
                if (!path.getFileName().toString().contains(LOGFILE_SUFFIX)) {
                    return false;
                }
                try {
                    long l = System.currentTimeMillis() - Files.getLastModifiedTime(path, new LinkOption[0]).toMillis();
                    int n2 = (int)(l / 1000L / 60L / 60L / 24L);
                    return n2 >= n;
                }
                catch (IOException iOException) {
                    return false;
                }
            }
        };
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(LoggingManager.getDebugDir(), (DirectoryStream.Filter<? super Path>)filter);){
            for (Path path : directoryStream) {
                Files.delete(path);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static {
        fileHandlerLock = new Object();
        DEFAULT_FILTER = new Filter(){

            @Override
            public boolean isLoggable(LogRecord logRecord) {
                String string = logRecord.getLoggerName();
                if (string == null) {
                    return false;
                }
                if (string.contains("EhCacheProvider") && logRecord.getMessage() != null && logRecord.getMessage().contains("Could not find configuration")) {
                    return false;
                }
                if (string.contains("JDBCTransaction") || string.contains("JDBCExceptionReporter")) {
                    if (Util.isMySQLDeadlock(logRecord)) {
                        return false;
                    }
                    if (logRecord.getMessage() != null && logRecord.getMessage().contains("SQL Error: 1213, SQLState: 40001")) {
                        return false;
                    }
                }
                if (string.contains("AbstractBatcher") && Util.isStaleStateException(logRecord.getThrown())) {
                    return false;
                }
                if (string.contains("SchemaExport") && logRecord.getLevel() == Level.SEVERE && logRecord.getMessage() != null) {
                    String string2 = logRecord.getMessage();
                    if (string2.startsWith("Index column size too large. The maximum column size is")) {
                        return false;
                    }
                    if (string2.startsWith("Unsuccessful: create index") && (string2.contains("IDX_GROUP_LDAPDN") || string2.contains("IDX_LDAPDN") || string2.contains("IDX_SHIB_PID") || string2.contains("IDX_FIL_REL_NAME") || string2.contains("IDX_ORGANIZATION_LDAPDN"))) {
                        return false;
                    }
                }
                if ((string.startsWith("org.hibernate") || string.startsWith("com.mchange")) && logRecord.getLevel().intValue() > Level.FINE.intValue()) {
                    if (string.endsWith("ReadWriteCache") && logRecord.getLevel() == Level.WARNING) {
                        logRecord.setLevel(Level.FINE);
                    } else if (logRecord.getLevel() == Level.INFO) {
                        logRecord.setLevel(Level.FINE);
                    }
                    return true;
                }
                return string.startsWith("de.dal33t") || string.startsWith("net.sf.webdav") || string.startsWith("edu.kit");
            }
        };
        Logger logger = LoggingManager.getRootLogger();
        logger.setLevel(Level.SEVERE);
        for (Handler handler : logger.getHandlers()) {
            handler.flush();
            handler.close();
            logger.removeHandler(handler);
        }
        consoleHandler = new ConsoleHandler();
        documentHandler = new DocumentHandler();
        bufferedHandler = new BufferedHandler(200);
        countingHandler = new CountingHandler();
        syslogHandler = new UDPSyslogHandler();
        logger.setFilter(DEFAULT_FILTER);
        consoleHandler.setFilter(DEFAULT_FILTER);
        documentHandler.setFilter(DEFAULT_FILTER);
        bufferedHandler.setFilter(DEFAULT_FILTER);
        countingHandler.setFilter(DEFAULT_FILTER);
        syslogHandler.setFilter(DEFAULT_FILTER);
        countingHandler.setLevel(Level.WARNING);
        logger.addHandler(countingHandler);
    }
}

