/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.util.compare;

import de.dal33t.powerfolder.Member;
import de.dal33t.powerfolder.light.AccountInfo;
import de.dal33t.powerfolder.message.TransferStatus;
import de.dal33t.powerfolder.util.Reject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.logging.Logger;

public class MemberComparator
implements Comparator<Member> {
    private static final Logger LOG = Logger.getLogger(MemberComparator.class.getName());
    public static final MemberComparator IN_GUI = new MemberComparator(0);
    public static final MemberComparator BY_LAST_CONNECT_DATE = new MemberComparator(1);
    public static final MemberComparator BY_CONNECTION_TYPE = new MemberComparator(2);
    public static final MemberComparator BY_RECONNECTION_PRIORITY = new MemberComparator(3);
    public static final MemberComparator BY_UPLOAD_AVAILIBILITY = new MemberComparator(4);
    public static final MemberComparator NICK = new MemberComparator(5);
    public static final MemberComparator HOSTNAME = new MemberComparator(6);
    public static final MemberComparator IP = new MemberComparator(7);
    public static final MemberComparator DISPLAY_NAME = new MemberComparator(8);
    private int type;

    private MemberComparator(int n) {
        this.type = n;
    }

    @Override
    public int compare(Member member, Member member2) {
        int n = 0;
        if (this.type == 0) {
            if (member.isMySelf()) {
                n -= 2000;
            }
            if (member2.isMySelf()) {
                n += 2000;
            }
            if (member.isFriend()) {
                n -= 1000;
            }
            if (member2.isFriend()) {
                n += 1000;
            }
            if (member.isCompletelyConnected()) {
                n -= 500;
            }
            if (member2.isCompletelyConnected()) {
                n += 500;
            }
            if (member.isConnectedToNetwork()) {
                n -= 100;
            }
            if (member2.isConnectedToNetwork()) {
                n += 100;
            }
            n += member.getNick().toLowerCase().compareTo(member2.getNick().toLowerCase());
        } else if (this.type == 1) {
            n = this.compareDates(member.getInfo().getLastConnectTime(), member2.getInfo().getLastConnectTime());
        } else if (this.type == 2) {
            n -= member.isOnLAN() ? 100 : 0;
            n += member2.isOnLAN() ? 100 : 0;
        } else if (this.type == 3) {
            n = this.compareDates(member.getLastNetworkConnectTime(), member2.getLastNetworkConnectTime());
            if (member.isFriend()) {
                n -= 8;
            }
            if (member2.isFriend()) {
                n += 8;
            }
            if (member.isSupernode()) {
                n -= 4;
            }
            if (member2.isSupernode()) {
                n += 4;
            }
            if (member.isConnectedToNetwork()) {
                n -= 2;
            }
            if (member2.isConnectedToNetwork()) {
                n += 2;
            }
        } else if (this.type == 4) {
            n += member.isOnLAN() ? 10000 : 0;
            n -= member2.isOnLAN() ? 10000 : 0;
            long l = this.compareTransferStatus(member.getLastTransferStatus(), member2.getLastTransferStatus());
            n = (int)((long)n + l);
        } else {
            if (this.type == 5) {
                return member.getNick().toLowerCase().compareTo(member2.getNick().toLowerCase());
            }
            if (this.type == 6) {
                return member.getHostName().toLowerCase().compareTo(member2.getHostName().toLowerCase());
            }
            if (this.type == 7) {
                String string;
                String string2 = member.getIP();
                if (string2 == null) {
                    string2 = "";
                }
                if ((string = member2.getIP()) == null) {
                    string = "";
                }
                return MemberComparator.compareIPs(string2, string);
            }
            if (this.type == 8) {
                AccountInfo accountInfo = member.getAccountInfo();
                AccountInfo accountInfo2 = member2.getAccountInfo();
                if (accountInfo == null) {
                    return accountInfo2 == null ? 0 : 1;
                }
                if (accountInfo2 == null) {
                    return -1;
                }
                if (accountInfo.getDisplayName() == null) {
                    return accountInfo2.getDisplayName() == null ? 0 : 1;
                }
                if (accountInfo2.getDisplayName() == null) {
                    return -1;
                }
                return accountInfo.getDisplayName().compareTo(accountInfo2.getDisplayName());
            }
            LOG.severe("Unknow comparing type: " + this.type);
        }
        return n;
    }

    public List<Member> sortedCopy(Collection<Member> collection) {
        Reject.ifNull(collection, "Input is null");
        ArrayList<Member> arrayList = new ArrayList<Member>(collection);
        Collections.sort(arrayList, this);
        return arrayList;
    }

    private int compareTransferStatus(TransferStatus transferStatus, TransferStatus transferStatus2) {
        if (transferStatus == null) {
            return transferStatus2 == null ? 0 : -5000;
        }
        if (transferStatus2 == null) {
            return 5000;
        }
        int n = 0;
        long l = transferStatus.getAvailbleUploadCPS() - transferStatus2.getAvailbleUploadCPS();
        n = (int)((long)n + Math.max(Math.min(l / 10L, 1000L), -1000L));
        return n;
    }

    private int compareDates(Date date, Date date2) {
        long l;
        long l2 = date != null ? date.getTime() : 0L;
        long l3 = l = date2 != null ? date2.getTime() : 0L;
        if (l2 == l) {
            return 0;
        }
        return l2 - l > 0L ? -1 : 1;
    }

    private static int compareIPs(String string, String string2) {
        if (string.trim().equals("") && string2.trim().equals("")) {
            return 0;
        }
        if (string.trim().equals("")) {
            return -1;
        }
        if (string2.trim().equals("")) {
            return 1;
        }
        String[] stringArray = string.split("\\.");
        String[] stringArray2 = string2.split("\\.");
        for (int i = 0; i <= 3; ++i) {
            int n;
            int n2 = Integer.parseInt(stringArray[i]);
            if (n2 == (n = Integer.parseInt(stringArray2[i]))) continue;
            if (n2 < n) {
                return -1;
            }
            if (n2 <= n) continue;
            return 1;
        }
        return 0;
    }
}

