/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.util.compare;

import de.dal33t.powerfolder.light.DirectoryInfo;
import de.dal33t.powerfolder.light.DiskItem;
import de.dal33t.powerfolder.light.FileInfo;
import java.io.Serializable;
import java.util.Comparator;

public class FileInfoComparator
implements Comparator<FileInfo>,
Serializable {
    private static final long serialVersionUID = 100L;
    public static final int BY_FILE_TYPE = 0;
    public static final int BY_NAME = 1;
    public static final int BY_RELATIVE_NAME = 2;
    public static final int BY_SIZE = 3;
    public static final int BY_MEMBER = 4;
    public static final int BY_MODIFIED_DATE = 5;
    public static final int BY_FOLDER = 6;
    public static final int BY_VERSION = 7;
    private static final int BEFORE = -1;
    private static final int AFTER = 1;
    private int sortBy;
    private static final FileInfoComparator[] comparators = new FileInfoComparator[8];

    public FileInfoComparator(int n) {
        this.sortBy = n;
    }

    public static FileInfoComparator getComparator(int n) {
        return comparators[n];
    }

    @Override
    public int compare(FileInfo fileInfo, FileInfo fileInfo2) {
        switch (this.sortBy) {
            case 0: {
                String string = fileInfo.getExtension();
                String string2 = fileInfo2.getExtension();
                if (string == null || string2 == null) {
                    return FileInfoComparator.sortByFileName(fileInfo, fileInfo2, false);
                }
                int n = string.compareTo(string2);
                if (n == 0) {
                    return FileInfoComparator.sortByFileName(fileInfo, fileInfo2, false);
                }
                return n;
            }
            case 1: {
                if (fileInfo.isDiretory() && !fileInfo2.isDiretory()) {
                    return Integer.MIN_VALUE;
                }
                if (fileInfo2.isDiretory() && !fileInfo.isDiretory()) {
                    return Integer.MAX_VALUE;
                }
                return FileInfoComparator.sortByFileName(fileInfo, fileInfo2, false);
            }
            case 2: {
                return FileInfoComparator.sortByFileName(fileInfo, fileInfo2, true);
            }
            case 3: {
                if (fileInfo.isLookupInstance() || fileInfo2.isLookupInstance()) {
                    return FileInfoComparator.sortByFileName(fileInfo, fileInfo2, false);
                }
                if (fileInfo.getSize() < fileInfo2.getSize()) {
                    return -1;
                }
                if (fileInfo.getSize() > fileInfo2.getSize()) {
                    return 1;
                }
                return FileInfoComparator.sortByFileName(fileInfo, fileInfo2, false);
            }
            case 4: {
                if (fileInfo.getModifiedBy() == null && fileInfo2.getModifiedBy() == null) {
                    return FileInfoComparator.sortByFileName(fileInfo, fileInfo2, false);
                }
                if (fileInfo.getModifiedBy() == null) {
                    return -1;
                }
                if (fileInfo2.getModifiedBy() == null) {
                    return 1;
                }
                int n = fileInfo.getModifiedBy().nick.toLowerCase().compareTo(fileInfo2.getModifiedBy().nick.toLowerCase());
                if (n == 0) {
                    return FileInfoComparator.sortByFileName(fileInfo, fileInfo2, false);
                }
                return n;
            }
            case 5: {
                if (fileInfo.getModifiedDate() == null && fileInfo2.getModifiedDate() == null) {
                    return FileInfoComparator.sortByFileName(fileInfo, fileInfo2, false);
                }
                if (fileInfo.getModifiedDate() == null) {
                    return -1;
                }
                if (fileInfo2.getModifiedDate() == null) {
                    return 1;
                }
                int n = fileInfo2.getModifiedDate().compareTo(fileInfo.getModifiedDate());
                if (n == 0) {
                    return FileInfoComparator.sortByFileName(fileInfo, fileInfo2, false);
                }
                return n;
            }
            case 6: {
                if (fileInfo.getFolderInfo() == null && fileInfo2.getFolderInfo() == null) {
                    return FileInfoComparator.sortByFileName(fileInfo, fileInfo2, false);
                }
                if (fileInfo.getFolderInfo() == null) {
                    return -1;
                }
                if (fileInfo2.getFolderInfo() == null) {
                    return 1;
                }
                int n = fileInfo.getFolderInfo().getName().compareToIgnoreCase(fileInfo2.getFolderInfo().getName());
                if (n == 0) {
                    return FileInfoComparator.sortByFileName(fileInfo, fileInfo2, false);
                }
                return n;
            }
            case 7: {
                if (fileInfo.getFolderInfo() == null && fileInfo2.getFolderInfo() == null) {
                    return FileInfoComparator.sortByFileName(fileInfo, fileInfo2, false);
                }
                if (fileInfo.getFolderInfo() == null) {
                    return -1;
                }
                if (fileInfo2.getFolderInfo() == null) {
                    return 1;
                }
                if (fileInfo instanceof DirectoryInfo || fileInfo2 instanceof DirectoryInfo) {
                    return FileInfoComparator.sortByFileName(fileInfo, fileInfo2, false);
                }
                int n = fileInfo.getVersion() - fileInfo2.getVersion();
                if (n == 0) {
                    return FileInfoComparator.sortByFileName(fileInfo, fileInfo2, false);
                }
                return n;
            }
        }
        return 0;
    }

    private static int sortByFileName(DiskItem diskItem, DiskItem diskItem2, boolean bl) {
        if (diskItem.isDiretory() && diskItem2.isFile()) {
            return -1;
        }
        if (diskItem.isFile() && diskItem2.isDiretory()) {
            return 1;
        }
        if (bl) {
            return diskItem.getRelativeName().compareToIgnoreCase(diskItem2.getRelativeName());
        }
        return diskItem.getFilenameOnly().compareToIgnoreCase(diskItem2.getFilenameOnly());
    }

    public String toString() {
        Object object;
        String string = "FileInfo comparator, sorting by ";
        switch (this.sortBy) {
            case 0: {
                object = string + "file type";
                break;
            }
            case 1: {
                object = string + "name";
                break;
            }
            case 3: {
                object = string + "size";
                break;
            }
            case 4: {
                object = string + "member";
                break;
            }
            case 5: {
                object = string + "modified date";
                break;
            }
            default: {
                object = "???";
            }
        }
        return object;
    }

    static {
        FileInfoComparator.comparators[0] = new FileInfoComparator(0);
        FileInfoComparator.comparators[1] = new FileInfoComparator(1);
        FileInfoComparator.comparators[2] = new FileInfoComparator(2);
        FileInfoComparator.comparators[3] = new FileInfoComparator(3);
        FileInfoComparator.comparators[4] = new FileInfoComparator(4);
        FileInfoComparator.comparators[5] = new FileInfoComparator(5);
        FileInfoComparator.comparators[6] = new FileInfoComparator(6);
        FileInfoComparator.comparators[7] = new FileInfoComparator(7);
    }
}

