/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.util.collection;

import de.dal33t.powerfolder.util.collection.EmptyIterator;
import de.dal33t.powerfolder.util.collection.IteratorChain;
import de.dal33t.powerfolder.util.collection.UnmodifiableList;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;

public class CompositeCollection<T>
implements Collection<T> {
    protected CollectionMutator mutator;
    protected Collection<T>[] all = new Collection[0];

    public CompositeCollection() {
    }

    public CompositeCollection(Collection<T> collection) {
        this();
        this.addComposited((Collection)collection);
    }

    public CompositeCollection(Collection<T> ... collectionArray) {
        this();
        this.addComposited(collectionArray);
    }

    @Override
    public int size() {
        int n = 0;
        for (int i = this.all.length - 1; i >= 0; --i) {
            n += this.all[i].size();
        }
        return n;
    }

    @Override
    public boolean isEmpty() {
        for (int i = this.all.length - 1; i >= 0; --i) {
            if (this.all[i].isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean contains(Object object) {
        for (int i = this.all.length - 1; i >= 0; --i) {
            if (!this.all[i].contains(object)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator iterator() {
        if (this.all.length == 0) {
            return EmptyIterator.INSTANCE;
        }
        IteratorChain iteratorChain = new IteratorChain();
        for (int i = 0; i < this.all.length; ++i) {
            iteratorChain.addIterator(this.all[i].iterator());
        }
        return iteratorChain;
    }

    @Override
    public Object[] toArray() {
        Object[] objectArray = new Object[this.size()];
        int n = 0;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            objectArray[n] = iterator.next();
            ++n;
        }
        return objectArray;
    }

    @Override
    public Object[] toArray(Object[] objectArray) {
        int n = this.size();
        Object[] objectArray2 = null;
        objectArray2 = objectArray.length >= n ? objectArray : (Object[])Array.newInstance(objectArray.getClass().getComponentType(), n);
        int n2 = 0;
        for (int i = 0; i < this.all.length; ++i) {
            Iterator<T> iterator = this.all[i].iterator();
            while (iterator.hasNext()) {
                objectArray2[n2++] = iterator.next();
            }
        }
        if (objectArray2.length > n) {
            objectArray2[n] = null;
        }
        return objectArray2;
    }

    @Override
    public boolean add(Object object) {
        if (this.mutator == null) {
            throw new UnsupportedOperationException("add() is not supported on CompositeCollection without a CollectionMutator strategy");
        }
        return this.mutator.add(this, this.all, object);
    }

    @Override
    public boolean remove(Object object) {
        if (this.mutator == null) {
            throw new UnsupportedOperationException("remove() is not supported on CompositeCollection without a CollectionMutator strategy");
        }
        return this.mutator.remove(this, this.all, object);
    }

    @Override
    public boolean containsAll(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (this.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection collection) {
        if (this.mutator == null) {
            throw new UnsupportedOperationException("addAll() is not supported on CompositeCollection without a CollectionMutator strategy");
        }
        return this.mutator.addAll(this, this.all, collection);
    }

    @Override
    public boolean removeAll(Collection collection) {
        if (collection.size() == 0) {
            return false;
        }
        boolean bl = false;
        for (int i = this.all.length - 1; i >= 0; --i) {
            bl = this.all[i].removeAll(collection) || bl;
        }
        return bl;
    }

    @Override
    public boolean retainAll(Collection collection) {
        boolean bl = false;
        for (int i = this.all.length - 1; i >= 0; --i) {
            bl = this.all[i].retainAll(collection) || bl;
        }
        return bl;
    }

    @Override
    public void clear() {
        for (int i = 0; i < this.all.length; ++i) {
            this.all[i].clear();
        }
    }

    public void setMutator(CollectionMutator collectionMutator) {
        this.mutator = collectionMutator;
    }

    public void addComposited(Collection ... collectionArray) {
        ArrayList<Collection<Collection>> arrayList = new ArrayList<Collection<Collection>>(Arrays.asList(this.all));
        arrayList.addAll(Arrays.asList(collectionArray));
        this.all = arrayList.toArray(new Collection[arrayList.size()]);
    }

    public void addComposited(Collection collection) {
        this.addComposited(new Collection[]{collection});
    }

    public void addComposited(Collection collection, Collection collection2) {
        this.addComposited(new Collection[]{collection, collection2});
    }

    public void removeComposited(Collection collection) {
        ArrayList<Collection<T>> arrayList = new ArrayList<Collection<T>>(this.all.length);
        arrayList.addAll(Arrays.asList(this.all));
        arrayList.remove(collection);
        this.all = arrayList.toArray(new Collection[arrayList.size()]);
    }

    public Collection toCollection() {
        return new ArrayList(this);
    }

    public Collection getCollections() {
        return UnmodifiableList.decorate(Arrays.asList(this.all));
    }

    public static interface CollectionMutator {
        public boolean add(CompositeCollection var1, Collection[] var2, Object var3);

        public boolean addAll(CompositeCollection var1, Collection[] var2, Collection var3);

        public boolean remove(CompositeCollection var1, Collection[] var2, Object var3);
    }
}

