/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.util;

import de.dal33t.powerfolder.util.Profiling;
import de.dal33t.powerfolder.util.ProfilingEntry;
import de.dal33t.powerfolder.util.Reject;
import de.dal33t.powerfolder.util.WrappedRunnable;
import de.dal33t.powerfolder.util.WrapperExecutorService;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.RunnableScheduledFuture;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WrappedScheduledThreadPoolExecutor
extends ScheduledThreadPoolExecutor {
    private static final Logger LOG = Logger.getLogger(WrappedScheduledThreadPoolExecutor.class.getName());
    public static int WARN_NUMBER_WORKERS;
    public static int SEVERE_NUMBER_WORKERS;
    private WrapperExecutorService wrappingThreadPool;
    private ThreadPoolExecutor executingThreadPool;
    private Map<Class, Integer> classCountRunning;
    private Date lastDump = new Date(System.currentTimeMillis() - 30000L);

    public WrappedScheduledThreadPoolExecutor(int n, ThreadFactory threadFactory) {
        super(n, threadFactory);
        this.executingThreadPool = (ThreadPoolExecutor)Executors.newCachedThreadPool(threadFactory);
        this.wrappingThreadPool = new WrapperExecutorService(this.executingThreadPool);
        Comparator comparator = (clazz, clazz2) -> clazz.getName().compareTo(clazz2.getName());
        this.classCountRunning = Collections.synchronizedMap(new TreeMap(comparator));
    }

    public static void setWarningLevel(int n) {
        WARN_NUMBER_WORKERS = Math.max(500, n);
        SEVERE_NUMBER_WORKERS = 3 * WARN_NUMBER_WORKERS;
    }

    @Override
    public void execute(Runnable runnable) {
        if (runnable instanceof WrappedRunnable || runnable instanceof ScheduledRunnable) {
            super.execute(runnable);
            return;
        }
        if (LOG.isLoggable(Level.FINER)) {
            LOG.log(Level.FINER, "Decorating exec: " + runnable);
        }
        super.execute(new ScheduledRunnable(runnable, true));
    }

    @Override
    protected <V> RunnableScheduledFuture<V> decorateTask(Runnable runnable, RunnableScheduledFuture<V> runnableScheduledFuture) {
        if (runnable instanceof WrappedRunnable || runnable instanceof ScheduledRunnable) {
            return super.decorateTask(runnable, runnableScheduledFuture);
        }
        LOG.warning("Decorating task: " + runnable);
        return super.decorateTask(new ScheduledRunnable(runnable, true), runnableScheduledFuture);
    }

    @Override
    public void shutdown() {
        try {
            super.shutdown();
        }
        finally {
            this.wrappingThreadPool.shutdown();
        }
    }

    @Override
    public List<Runnable> shutdownNow() {
        LinkedList<Runnable> linkedList = new LinkedList<Runnable>();
        try {
            linkedList.addAll(super.shutdownNow());
        }
        finally {
            linkedList.addAll(this.wrappingThreadPool.shutdownNow());
        }
        return linkedList;
    }

    @Override
    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long l, TimeUnit timeUnit) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable runnable, long l, TimeUnit timeUnit) {
        this.checkBusyness();
        return super.schedule(new ScheduledRunnable(runnable, true), l, timeUnit);
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable runnable, long l, long l2, TimeUnit timeUnit) {
        this.checkBusyness();
        return super.scheduleAtFixedRate(new ScheduledRunnable(runnable, true), l, l2, timeUnit);
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable runnable, long l, long l2, TimeUnit timeUnit) {
        this.checkBusyness();
        return super.scheduleWithFixedDelay(new ScheduledRunnable(runnable, false), l, l2, timeUnit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkBusyness() {
        int n = this.getActiveCount();
        if (n == 0) {
            return;
        }
        if (this.lastDump.after(new Date(System.currentTimeMillis() - 30000L))) {
            return;
        }
        Level level = Level.FINER;
        if (n > SEVERE_NUMBER_WORKERS) {
            level = Level.SEVERE;
        } else if (n > WARN_NUMBER_WORKERS) {
            level = Level.WARNING;
        }
        if (LOG.isLoggable(level)) {
            StringBuffer stringBuffer = new StringBuffer("Active tasks:");
            Map<Class, Integer> map = this.classCountRunning;
            synchronized (map) {
                for (Class clazz : this.classCountRunning.keySet()) {
                    stringBuffer.append("\n");
                    stringBuffer.append(clazz.getName());
                    stringBuffer.append("\t");
                    stringBuffer.append(this.classCountRunning.get(clazz));
                }
            }
            LOG.log(level, "Scheduled threadpool status: Currently active threads: " + n + "/" + this.getPoolSize() + "\n" + stringBuffer);
            this.lastDump = new Date();
        }
    }

    @Override
    public int getCorePoolSize() {
        return super.getCorePoolSize() + this.executingThreadPool.getCorePoolSize();
    }

    @Override
    public int getPoolSize() {
        return super.getPoolSize() + this.executingThreadPool.getPoolSize();
    }

    @Override
    public int getActiveCount() {
        return super.getActiveCount() + this.executingThreadPool.getActiveCount();
    }

    static {
        WrappedScheduledThreadPoolExecutor.setWarningLevel(500);
    }

    private class ScheduledRunnable
    implements Runnable {
        private Runnable task;
        private boolean concurrentExecutionAllowed;
        private AtomicBoolean running = new AtomicBoolean(false);

        public ScheduledRunnable(Runnable runnable, boolean bl) {
            Reject.ifNull(runnable, "Runnable to be execute is null");
            this.task = runnable;
            this.concurrentExecutionAllowed = bl;
        }

        @Override
        public void run() {
            WrappedScheduledThreadPoolExecutor.this.checkBusyness();
            WrappedScheduledThreadPoolExecutor.this.wrappingThreadPool.submit(() -> {
                if (this.concurrentExecutionAllowed || this.running.compareAndSet(false, true)) {
                    Integer n;
                    ProfilingEntry profilingEntry = null;
                    try {
                        n = (Integer)WrappedScheduledThreadPoolExecutor.this.classCountRunning.get(this.task.getClass());
                        WrappedScheduledThreadPoolExecutor.this.classCountRunning.put(this.task.getClass(), n == null ? 1 : n + 1);
                        profilingEntry = Profiling.start(this.task.getClass(), "run");
                        this.task.run();
                        this.running.set(false);
                    }
                    catch (Throwable throwable) {
                        this.running.set(false);
                        Profiling.end(profilingEntry);
                        Integer n2 = (Integer)WrappedScheduledThreadPoolExecutor.this.classCountRunning.get(this.task.getClass());
                        Integer n3 = n2 = Integer.valueOf(n2 == null ? 1 : n2);
                        n2 = n2 - 1;
                        if (n2 == 0) {
                            WrappedScheduledThreadPoolExecutor.this.classCountRunning.remove(this.task.getClass());
                        } else {
                            WrappedScheduledThreadPoolExecutor.this.classCountRunning.put(this.task.getClass(), n2);
                        }
                        throw throwable;
                    }
                    Profiling.end(profilingEntry);
                    n = (Integer)WrappedScheduledThreadPoolExecutor.this.classCountRunning.get(this.task.getClass());
                    Integer n4 = n = Integer.valueOf(n == null ? 1 : n);
                    n = n - 1;
                    if (n == 0) {
                        WrappedScheduledThreadPoolExecutor.this.classCountRunning.remove(this.task.getClass());
                    } else {
                        WrappedScheduledThreadPoolExecutor.this.classCountRunning.put(this.task.getClass(), n);
                    }
                }
            });
        }
    }
}

