/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.util;

import de.dal33t.powerfolder.util.Reject;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WrappedCallable<V>
implements Callable<V> {
    private static final Logger log = Logger.getLogger(WrappedCallable.class.getName());
    private Callable<V> deligate;

    public WrappedCallable(Callable<V> callable) {
        Reject.ifNull(callable, "Deligate is null");
        this.deligate = callable;
    }

    @Override
    public V call() throws Exception {
        try {
            return this.deligate.call();
        }
        catch (Error error) {
            error.printStackTrace();
            log.log(Level.SEVERE, "Error in " + this.deligate + ": " + error.toString(), error);
            throw error;
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
            log.log(Level.SEVERE, "RuntimeException in " + this.deligate + ": " + runtimeException.toString(), runtimeException);
            throw runtimeException;
        }
    }
}

