/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.util;

import de.dal33t.powerfolder.util.Convert;
import de.dal33t.powerfolder.util.Reject;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.logging.Logger;

public class StreamUtils {
    private static final Logger log = Logger.getLogger(StreamUtils.class.getName());
    private static final int BUFFER_SIZE = 8024;

    private StreamUtils() {
    }

    public static void copyToStream(Path path, OutputStream outputStream) throws IOException {
        if (path.toString().contains(".crypto")) {
            Files.copy(path, outputStream);
        } else {
            StreamUtils.copyToStream(path, outputStream, 0L, -1L);
        }
    }

    public static void copyToStream(Path path, OutputStream outputStream, long l, long l2) throws IOException {
        Reject.ifNull(path, "Source is null");
        Reject.ifNull(outputStream, "Destination is null");
        Reject.ifFalse(Files.exists(path, new LinkOption[0]), "Source file does not exist");
        Reject.ifFalse(Files.isReadable(path), "Unable to read source file");
        try (InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);){
            inputStream.skip(l);
            StreamUtils.copyToStream(inputStream, outputStream, l2);
        }
    }

    public static long copyToStream(InputStream inputStream, OutputStream outputStream) throws IOException {
        return StreamUtils.copyToStream(inputStream, outputStream, -1L);
    }

    public static long copyToStream(InputStream inputStream, OutputStream outputStream, long l) throws IOException {
        Reject.ifNull(inputStream, "Source is null");
        Reject.ifNull(outputStream, "Destination is null");
        byte[] byArray = new byte[8024];
        int n = -1;
        long l2 = 0L;
        do {
            long l3;
            long l4 = l3 = l >= 0L ? l - l2 : Long.MAX_VALUE;
            if (l3 >= 8024L) {
                n = inputStream.read(byArray);
            } else if (l3 > 0L) {
                n = inputStream.read(byArray, 0, (int)l3);
            }
            if (n < 0) break;
            outputStream.write(byArray, 0, n);
        } while (l < 0L || (l2 += (long)n) < l);
        return l2;
    }

    public static int read(InputStream inputStream, byte[] byArray, int n, int n2) throws IOException {
        int n3 = 0;
        int n4 = 0;
        do {
            try {
                n4 = inputStream.read(byArray, n + n3, n2 - n3);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                log.severe("buffer.length: " + byArray.length + ", offset");
                throw indexOutOfBoundsException;
            }
            if (n4 >= 0) continue;
            throw new EOFException("EOF, nothing more to read");
        } while ((n3 += n4) < n2);
        return n3;
    }

    public static byte[] readIntoByteArray(InputStream inputStream) throws IOException {
        Reject.ifNull(inputStream, "Input stream is null");
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(inputStream.available());
        StreamUtils.copyToStream(inputStream, (OutputStream)byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static int readInt(InputStream inputStream) throws IOException {
        byte[] byArray = new byte[4];
        StreamUtils.read(inputStream, byArray, 0, byArray.length);
        return Convert.convert2Int(byArray);
    }
}

