/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.util;

import com.google.protobuf.AbstractMessage;
import de.dal33t.powerfolder.d2d.D2DObject;
import de.dal33t.powerfolder.protocol.DataRangeProto;
import java.io.Serializable;

public final class Range
implements Serializable,
D2DObject {
    private static final long serialVersionUID = 100L;
    private long start;
    private long length;

    public static Range getRangeByLength(long l, long l2) {
        return new Range(l, l2);
    }

    public static Range getRangeByNumbers(long l, long l2) {
        long l3 = Math.min(l, l2);
        return new Range(l3, Math.max(l, l2) - l3 + 1L);
    }

    private Range(long l, long l2) {
        if (l2 < 0L) {
            throw new NegativeArraySizeException();
        }
        this.start = l;
        this.length = l2;
    }

    public Range(AbstractMessage abstractMessage) {
        this.initFromD2D(abstractMessage);
    }

    public boolean contains(Range range) {
        return this.getStart() <= range.getStart() && this.getEnd() >= range.getEnd();
    }

    public boolean equals(Object object) {
        if (object instanceof Range) {
            Range range = (Range)object;
            return this.getStart() == range.getStart() && this.getLength() == range.getLength();
        }
        return false;
    }

    public long getEnd() {
        return this.start + this.length - 1L;
    }

    public long getLength() {
        return this.length;
    }

    public long getStart() {
        return this.start;
    }

    public int hashCode() {
        return (int)(this.getStart() * 13L & this.getEnd() * 137L);
    }

    public Range intersection(Range range) {
        if (!this.intersects(range)) {
            return null;
        }
        return Range.getRangeByNumbers(Math.max(this.getStart(), range.getStart()), Math.min(this.getEnd(), range.getEnd()));
    }

    public long intersectionLength(Range range) {
        if (!this.intersects(range)) {
            return 0L;
        }
        return Math.min(this.getEnd(), range.getEnd()) - Math.max(this.getStart(), range.getStart()) + 1L;
    }

    public boolean intersects(Range range) {
        return this.getStart() <= range.getEnd() && this.getEnd() >= range.getStart();
    }

    public String toString() {
        return "[" + this.getStart() + " - " + this.getEnd() + "]";
    }

    @Override
    public void initFromD2D(AbstractMessage abstractMessage) {
        if (abstractMessage instanceof DataRangeProto.DataRange) {
            DataRangeProto.DataRange dataRange = (DataRangeProto.DataRange)abstractMessage;
            this.start = dataRange.getStart();
            this.length = dataRange.getLength();
        }
    }

    @Override
    public AbstractMessage toD2D() {
        DataRangeProto.DataRange.Builder builder = DataRangeProto.DataRange.newBuilder();
        builder.setClazzName("DataRange");
        builder.setStart(this.start);
        builder.setLength(this.length);
        return builder.build();
    }
}

