/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.util;

import de.dal33t.powerfolder.util.MathUtil;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Properties;

public class PropertiesUtil {
    private PropertiesUtil() {
    }

    public static void saveConfig(Path path, Properties properties, String string) throws IOException {
        BufferedWriter bufferedWriter = Files.newBufferedWriter(path, Charset.forName("8859_1"), new OpenOption[0]);
        PropertiesUtil.store0(properties, bufferedWriter, string, true);
        bufferedWriter.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void store0(Properties properties, BufferedWriter bufferedWriter, String string, boolean bl) throws IOException {
        if (string != null) {
            PropertiesUtil.writeComments(bufferedWriter, string);
        }
        bufferedWriter.write("#" + new Date().toString());
        bufferedWriter.newLine();
        Properties properties2 = properties;
        synchronized (properties2) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Object object : properties.keySet()) {
                arrayList.add((String)object);
            }
            Collections.sort(arrayList);
            for (String string2 : arrayList) {
                String string3 = (String)properties.get(string2);
                String string4 = PropertiesUtil.saveConvert(string2, true, true, bl);
                string3 = PropertiesUtil.saveConvert(string3, false, false, bl);
                bufferedWriter.write(string4 + "=" + string3);
                bufferedWriter.newLine();
            }
        }
        bufferedWriter.flush();
    }

    private static String saveConvert(String string, boolean bl, boolean bl2, boolean bl3) {
        int n = string.length();
        int n2 = n * 2;
        if (n2 < 0) {
            n2 = Integer.MAX_VALUE;
        }
        StringBuilder stringBuilder = new StringBuilder(n2);
        block8: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c > '=' && c < '\u007f') {
                if (c == '\\') {
                    stringBuilder.append('\\');
                    stringBuilder.append('\\');
                    continue;
                }
                stringBuilder.append(c);
                continue;
            }
            switch (c) {
                case ' ': {
                    if (i == 0 || bl) {
                        stringBuilder.append('\\');
                    }
                    stringBuilder.append(' ');
                    continue block8;
                }
                case '\t': {
                    stringBuilder.append('\\');
                    stringBuilder.append('t');
                    continue block8;
                }
                case '\n': {
                    stringBuilder.append('\\');
                    stringBuilder.append('n');
                    continue block8;
                }
                case '\r': {
                    stringBuilder.append('\\');
                    stringBuilder.append('r');
                    continue block8;
                }
                case '\f': {
                    stringBuilder.append('\\');
                    stringBuilder.append('f');
                    continue block8;
                }
                case '!': 
                case '#': 
                case ':': 
                case '=': {
                    if (bl2) {
                        stringBuilder.append('\\');
                    }
                    stringBuilder.append(c);
                    continue block8;
                }
                default: {
                    if ((c < ' ' || c > '~') & bl3) {
                        stringBuilder.append('\\');
                        stringBuilder.append('u');
                        stringBuilder.append(MathUtil.toHexNibble(c >> 12 & 0xF));
                        stringBuilder.append(MathUtil.toHexNibble(c >> 8 & 0xF));
                        stringBuilder.append(MathUtil.toHexNibble(c >> 4 & 0xF));
                        stringBuilder.append(MathUtil.toHexNibble(c & 0xF));
                        continue block8;
                    }
                    stringBuilder.append(c);
                }
            }
        }
        return stringBuilder.toString();
    }

    private static void writeComments(BufferedWriter bufferedWriter, String string) throws IOException {
        int n;
        bufferedWriter.write("#");
        int n2 = string.length();
        char[] cArray = new char[6];
        cArray[0] = 92;
        cArray[1] = 117;
        int n3 = 0;
        for (n = 0; n < n2; ++n) {
            char c = string.charAt(n);
            if (c <= '\u00ff' && c != '\n' && c != '\r') continue;
            if (n3 != n) {
                bufferedWriter.write(string.substring(n3, n));
            }
            if (c > '\u00ff') {
                cArray[2] = MathUtil.toHexNibble(c >> 12 & 0xF);
                cArray[3] = MathUtil.toHexNibble(c >> 8 & 0xF);
                cArray[4] = MathUtil.toHexNibble(c >> 4 & 0xF);
                cArray[5] = MathUtil.toHexNibble(c & 0xF);
                bufferedWriter.write(new String(cArray));
            } else {
                bufferedWriter.newLine();
                if (c == '\r' && n != n2 - 1 && string.charAt(n + 1) == '\n') {
                    ++n;
                }
                if (n == n2 - 1 || string.charAt(n + 1) != '#' && string.charAt(n + 1) != '!') {
                    bufferedWriter.write("#");
                }
            }
            n3 = n + 1;
        }
        if (n3 != n) {
            bufferedWriter.write(string.substring(n3, n));
        }
        bufferedWriter.newLine();
    }
}

