/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.util;

import de.dal33t.powerfolder.util.Range;
import java.io.Serializable;
import java.util.logging.Logger;

public class Partitions<T>
implements Serializable {
    private static final Logger log = Logger.getLogger(Partitions.class.getName());
    private static final long serialVersionUID = 1L;
    private Partitions<T> parent;
    private Partitions<T> a;
    private Partitions<T> b;
    private Range range;
    private T content;

    public Partitions(Range range, T t) {
        this.range = range;
        this.content = t;
    }

    private Partitions(Partitions<T> partitions, Range range, T t) {
        this.parent = partitions;
        this.range = range;
        this.content = t;
    }

    private boolean isLeaf() {
        return this.a == null;
    }

    private boolean isRoot() {
        return this.parent == null;
    }

    public int depth() {
        if (this.isLeaf()) {
            return 0;
        }
        return Math.max(this.a.depth(), this.b.depth()) + 1;
    }

    public Range getPartionedRange() {
        return this.range;
    }

    public void insert(Range range, T t) {
        if (!range.intersects(this.range)) {
            return;
        }
        if (range.contains(this.range)) {
            this.content = t;
            this.b = null;
            this.a = null;
            if (!this.isRoot()) {
                super.checkMergeChildren();
            }
            return;
        }
        if (this.isLeaf() && this.sameValue(t, this.content)) {
            return;
        }
        if (this.isLeaf()) {
            long l = (this.range.getStart() + this.range.getEnd()) / 2L;
            this.a = new Partitions<T>(this, Range.getRangeByNumbers(this.range.getStart(), l), this.content);
            this.b = new Partitions<T>(this, Range.getRangeByNumbers(l + 1L, this.range.getEnd()), this.content);
        }
        this.a.insert(range, t);
        if (this.b != null) {
            this.b.insert(range, t);
        }
    }

    public Range search(Range range, T t) {
        if (!this.range.intersects(range)) {
            return null;
        }
        if (this.isLeaf()) {
            if (this.sameValue(this.content, t)) {
                return Range.getRangeByNumbers(Math.max(range.getStart(), this.range.getStart()), Math.min(range.getEnd(), this.range.getEnd()));
            }
            return null;
        }
        Range range2 = this.a.search(range, t);
        Range range3 = this.b.search(range, t);
        if (range2 == null) {
            return range3;
        }
        if (range3 == null) {
            return range2;
        }
        if (range2.getEnd() + 1L == range3.getStart()) {
            return Range.getRangeByNumbers(range2.getStart(), range3.getEnd());
        }
        return range2;
    }

    private void checkMergeChildren() {
        if (super.isLeaf() && super.isLeaf() && this.sameValue(this.a.content, this.b.content)) {
            this.content = this.a.content;
            this.a = null;
            this.b = null;
            if (!this.isRoot()) {
                super.checkMergeChildren();
            }
        }
    }

    private boolean sameValue(T t, T t2) {
        return t == t2 || t != null && t.equals(t2);
    }

    public void logRanges(Class<T> clazz) {
        if (this.isLeaf()) {
            log.info(clazz.getName() + " " + this.getPartionedRange() + " with value " + this.content);
            return;
        }
        this.a.logRanges(clazz);
        this.b.logRanges(clazz);
    }

    public long count(Range range, T t) {
        if (this.isLeaf()) {
            if (!this.sameValue(this.content, t)) {
                return 0L;
            }
            return this.range.intersectionLength(range);
        }
        return this.a.count(range, t) + this.b.count(range, t);
    }
}

