/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.util;

import de.dal33t.powerfolder.light.FileInfo;
import de.dal33t.powerfolder.util.Base58;
import de.dal33t.powerfolder.util.Convert;
import de.dal33t.powerfolder.util.PathUtils;
import de.dal33t.powerfolder.util.Util;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.UUID;

public class IdGenerator {
    public static final String FILE_LINK_PREFIX = "fi";

    public static String makeId() {
        String string = Base58.encode(IdGenerator.makeIdBytes());
        return PathUtils.removeInvalidFilenameChars(string.substring(0, string.length() - 2)).replace("+", "").replace("/", "");
    }

    public static String makeFolderId() {
        return "2" + IdGenerator.makeId();
    }

    public static String makeFileId() {
        return "1" + IdGenerator.makeId();
    }

    public static String makeConfigEntryId() {
        return new String(Util.encodeHex(Util.md5(IdGenerator.makeIdBytes())));
    }

    public static byte[] makeIdBytes() {
        UUID uUID = UUID.randomUUID();
        byte[] byArray = new byte[16];
        long l = uUID.getMostSignificantBits();
        byArray[0] = (byte)(l >> 56 & 0xFFL);
        byArray[1] = (byte)(l >> 48 & 0xFFL);
        byArray[2] = (byte)(l >> 40 & 0xFFL);
        byArray[3] = (byte)(l >> 32 & 0xFFL);
        byArray[4] = (byte)(l >> 24 & 0xFFL);
        byArray[5] = (byte)(l >> 16 & 0xFFL);
        byArray[6] = (byte)(l >> 8 & 0xFFL);
        byArray[7] = (byte)(l & 0xFFL);
        long l2 = uUID.getLeastSignificantBits();
        byArray[8] = (byte)(l2 >> 56 & 0xFFL);
        byArray[9] = (byte)(l2 >> 48 & 0xFFL);
        byArray[10] = (byte)(l2 >> 40 & 0xFFL);
        byArray[11] = (byte)(l2 >> 32 & 0xFFL);
        byArray[12] = (byte)(l2 >> 24 & 0xFFL);
        byArray[13] = (byte)(l2 >> 16 & 0xFFL);
        byArray[14] = (byte)(l2 >> 8 & 0xFFL);
        byArray[15] = (byte)(l2 & 0xFFL);
        return byArray;
    }

    public static String generateFileLinkRandomID() {
        return FILE_LINK_PREFIX + IdGenerator.makeId();
    }

    public static String generateFileLinkID(FileInfo fileInfo) {
        return IdGenerator.generateFileLinkID(fileInfo.getFolderInfo().id, fileInfo.getRelativeName());
    }

    private static String generateFileLinkID(String string, String string2) {
        String string3 = string + "/" + string2;
        return FILE_LINK_PREFIX + Base58.encode(IdGenerator.md5(string3.getBytes(Convert.UTF8)));
    }

    private static byte[] md5(byte[] byArray) {
        return IdGenerator.getMd5Digest().digest(byArray);
    }

    private static MessageDigest getDigest(String string) {
        try {
            return MessageDigest.getInstance(string);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException(noSuchAlgorithmException.getMessage());
        }
    }

    private static MessageDigest getMd5Digest() {
        return IdGenerator.getDigest("MD5");
    }
}

