/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.util;

import de.dal33t.powerfolder.light.FileInfo;
import de.dal33t.powerfolder.util.DateUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileTime;

public class FolderSetLastmodified {
    public static void main(String[] stringArray) throws IOException, ClassNotFoundException {
        Path path = Paths.get(stringArray[0], new String[0]);
        if (!path.getFileName().toString().equalsIgnoreCase("PowerFolders")) {
            FolderSetLastmodified.correct(path);
            FolderSetLastmodified.correct(path.resolve(".PowerFolder/meta"));
            return;
        }
        DirectoryStream.Filter<Path> filter = new DirectoryStream.Filter<Path>(){

            @Override
            public boolean accept(Path path) {
                return Files.isDirectory(path, new LinkOption[0]);
            }
        };
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(path, (DirectoryStream.Filter<? super Path>)filter);){
            for (Path path2 : directoryStream) {
                FolderSetLastmodified.correct(path2);
                FolderSetLastmodified.correct(path2.resolve(".PowerFolder/meta"));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void correct(Path path) {
        try {
            Path path2 = path.resolve(".PowerFolder/.PowerFolder.db");
            InputStream inputStream = Files.newInputStream(path2, new OpenOption[0]);
            ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
            FileInfo[] fileInfoArray = (FileInfo[])objectInputStream.readObject();
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            for (FileInfo fileInfo : fileInfoArray) {
                if (fileInfo.isDeleted()) continue;
                ++n3;
                Path path3 = path.resolve(fileInfo.getRelativeName());
                if (Files.notExists(path3, new LinkOption[0])) {
                    System.err.println("Skip file not found: " + path3);
                    continue;
                }
                if (fileInfo.isFile() && Files.size(path3) != fileInfo.getSize()) {
                    System.err.println("Skip file size not identical found: " + Files.size(path3) + ". expected: " + fileInfo.getSize() + ": " + path3);
                    continue;
                }
                boolean bl = DateUtil.equalsFileDateCrossPlattform(Files.getLastModifiedTime(path3, new LinkOption[0]).toMillis(), fileInfo.getModifiedDate().getTime());
                if (!bl) {
                    Files.setLastModifiedTime(path3, FileTime.fromMillis(fileInfo.getModifiedDate().getTime()));
                    ++n;
                    continue;
                }
                ++n2;
            }
            System.out.println("Finished: " + n + " lmd changes, " + n2 + " lmd unchanged, " + n3 + " processed files @ " + path);
        }
        catch (Exception exception) {
            System.err.println(exception.toString());
        }
    }
}

