/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.util;

import de.dal33t.powerfolder.light.FolderInfo;
import de.dal33t.powerfolder.util.Base64;
import de.dal33t.powerfolder.util.StringUtils;
import de.dal33t.powerfolder.util.net.NetworkUtil;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Date;
import java.util.logging.Logger;

public class ExternalizableUtil {
    private ExternalizableUtil() {
    }

    public static void writeString(ObjectOutput objectOutput, String string) throws IOException {
        objectOutput.writeBoolean(string != null);
        if (string != null) {
            objectOutput.writeUTF(string);
        }
    }

    public static String readString(ObjectInput objectInput) throws IOException {
        boolean bl = objectInput.readBoolean();
        if (!bl) {
            return null;
        }
        return objectInput.readUTF();
    }

    public static void writeDate(ObjectOutput objectOutput, Date date) throws IOException {
        if (date != null) {
            objectOutput.writeLong(date.getTime());
        } else {
            objectOutput.writeLong(-1L);
        }
    }

    public static Date readDate(ObjectInput objectInput) throws IOException {
        long l = objectInput.readLong();
        if (l == -1L) {
            return null;
        }
        return new Date(l);
    }

    public static void writeAddress(ObjectOutput objectOutput, InetSocketAddress inetSocketAddress) throws IOException {
        InetAddress inetAddress;
        Object object = null;
        if (inetSocketAddress != null && (inetAddress = inetSocketAddress.getAddress()) != null) {
            object = NetworkUtil.getHostAddressNoResolve(inetAddress);
            object = (String)object + ":";
            if (!inetSocketAddress.isUnresolved() && inetAddress.getAddress() != null) {
                object = (String)object + Base64.encodeBytes(inetAddress.getAddress());
            }
            object = (String)object + ":";
            object = (String)object + inetSocketAddress.getPort();
        }
        objectOutput.writeBoolean(object != null);
        if (object != null) {
            objectOutput.writeUTF((String)object);
        }
    }

    public static InetSocketAddress readAddress(ObjectInput objectInput) throws IOException {
        boolean bl = objectInput.readBoolean();
        if (!bl) {
            return null;
        }
        String string = objectInput.readUTF();
        String[] stringArray = string.split(":");
        if (stringArray.length < 2) {
            return null;
        }
        if (stringArray.length == 2) {
            return new InetSocketAddress(stringArray[0], (int)Integer.valueOf(stringArray[1]));
        }
        String string2 = stringArray[0];
        int n = Integer.valueOf(stringArray[2]);
        if (StringUtils.isNotBlank(stringArray[1])) {
            byte[] byArray = Base64.decode(stringArray[1]);
            try {
                InetAddress inetAddress = InetAddress.getByAddress(string2, byArray);
                return new InetSocketAddress(inetAddress, n);
            }
            catch (UnknownHostException unknownHostException) {
                Logger.getLogger(ExternalizableUtil.class.getName()).warning(unknownHostException + ": hostname=" + string2 + ", addAndPort[1]=" + stringArray[1] + ", ip=" + Arrays.toString(byArray));
                throw unknownHostException;
            }
        }
        return new InetSocketAddress(string2, n);
    }

    public static void writeFolderInfo(ObjectOutput objectOutput, FolderInfo folderInfo, boolean bl) throws IOException {
        objectOutput.writeBoolean(folderInfo != null);
        if (folderInfo != null) {
            folderInfo.writeExternal(objectOutput, bl);
        }
    }

    public static FolderInfo readFolderInfo(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        if (objectInput.readBoolean()) {
            return FolderInfo.readExt(objectInput);
        }
        return null;
    }
}

