/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.util;

import de.dal33t.powerfolder.util.Reject;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.logging.Logger;

public class DateUtil {
    private static final Logger log = Logger.getLogger(DateUtil.class.getName());

    public static boolean equalsFileDateCrossPlattform(Date date, Date date2) {
        return DateUtil.equalsFileDateCrossPlattform(date.getTime(), date2.getTime());
    }

    public static boolean equalsFileDateCrossPlattform(long l, long l2) {
        if (l == l2) {
            return true;
        }
        long l3 = l > l2 ? l - l2 : l2 - l;
        return l3 <= 2000L;
    }

    public static boolean isNewerFileDateCrossPlattform(Date date, Date date2) {
        return DateUtil.isNewerFileDateCrossPlattform(date.getTime(), date2.getTime());
    }

    public static boolean isNewerFileDateCrossPlattform(long l, long l2) {
        if (l == l2) {
            return false;
        }
        long l3 = l - l2;
        return l3 > 2000L;
    }

    public static boolean isDateMoreThanNDaysInFuture(Date date, int n) {
        Reject.ifNull(date, "No date");
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        ((Calendar)gregorianCalendar).add(5, n);
        return date.after(gregorianCalendar.getTime());
    }

    public static boolean isMoreThanNDaysAfter(Date date, Date date2, int n) {
        Reject.ifNull(date, "No Date t0");
        Reject.ifNull(date2, "No Date t1");
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        ((Calendar)gregorianCalendar).add(5, n);
        return date2.after(gregorianCalendar.getTime());
    }

    public static boolean isDateMoreThanNHoursInFuture(Date date, int n) {
        Reject.ifNull(date, "No date");
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        ((Calendar)gregorianCalendar).add(10, n);
        return date.after(gregorianCalendar.getTime());
    }

    public static boolean isDateMoreThanNMinutesInFuture(Date date, int n) {
        Reject.ifNull(date, "No date");
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        ((Calendar)gregorianCalendar).add(12, n);
        return date.after(gregorianCalendar.getTime());
    }

    public static int getDaysInFuture(Date date) {
        Reject.ifNull(date, "No date");
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        Date date2 = gregorianCalendar.getTime();
        long l = date.getTime() - date2.getTime();
        return (int)(l / 1000L / 3660L / 24L);
    }

    public static int getHoursInFuture(Date date) {
        Reject.ifNull(date, "No date");
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        Date date2 = gregorianCalendar.getTime();
        long l = date.getTime() - date2.getTime();
        return (int)(l / 1000L / 3660L);
    }

    public static int getMinutesInFuture(Date date) {
        Reject.ifNull(date, "No date");
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        Date date2 = gregorianCalendar.getTime();
        long l = date.getTime() - date2.getTime();
        return (int)(l / 1000L / 60L);
    }

    public static boolean isBeforeEndOfDate(Date date, Date date2) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(DateUtil.zeroTime(date2));
        gregorianCalendar.set(11, 0);
        gregorianCalendar.set(12, 0);
        gregorianCalendar.set(13, 0);
        gregorianCalendar.set(14, 0);
        ((Calendar)gregorianCalendar).add(5, 1);
        return date.before(gregorianCalendar.getTime());
    }

    public static Date zeroTime(Date date) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        gregorianCalendar.set(11, 0);
        gregorianCalendar.set(12, 0);
        gregorianCalendar.set(13, 0);
        gregorianCalendar.set(14, 0);
        return gregorianCalendar.getTime();
    }

    public static Date truncateToHour(Date date) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        gregorianCalendar.set(12, 0);
        gregorianCalendar.set(13, 0);
        gregorianCalendar.set(14, 0);
        return gregorianCalendar.getTime();
    }

    public static long convertLdapToUnix(long l) {
        long l2 = 10000L;
        long l3 = 11644473600000L;
        return l / l2 - l3;
    }

    public static Date parseDate(String string) throws ParseException {
        Date date;
        block6: {
            if ("9223372036854775807".equals(string)) {
                return null;
            }
            date = null;
            try {
                TemporalAccessor temporalAccessor = DateTimeFormatter.ISO_OFFSET_DATE_TIME.parse(string);
                date = Date.from(Instant.from(temporalAccessor));
            }
            catch (RuntimeException runtimeException) {
                try {
                    long l = Long.parseLong(string);
                    if (l != 0L && l != Long.MAX_VALUE) {
                        l = DateUtil.convertLdapToUnix(l);
                        date = new Date(l);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    if (string.startsWith("9999") || string.equals("0")) break block6;
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
                    date = simpleDateFormat.parse(string);
                }
            }
        }
        return date;
    }

    public static Date parseISODateTime(String string) {
        if (string == null || string.trim().isEmpty()) {
            return null;
        }
        try {
            return DateUtil.parseISODateTimeStrict(string);
        }
        catch (DateTimeParseException dateTimeParseException) {
            log.fine("Unable to parse date string '" + string + "': " + dateTimeParseException.getMessage() + ". Parsing will be handled by caller.");
            return null;
        }
    }

    public static Date parseISODateTimeStrict(String string) throws DateTimeParseException {
        if (string == null || string.trim().isEmpty()) {
            throw new DateTimeParseException("Date string is null or empty", "", 0);
        }
        String string2 = string.trim();
        try {
            OffsetDateTime offsetDateTime = OffsetDateTime.parse(string2);
            return Date.from(offsetDateTime.toInstant());
        }
        catch (DateTimeParseException dateTimeParseException) {
            try {
                LocalDateTime localDateTime = LocalDateTime.parse(string2);
                return Date.from(localDateTime.atZone(ZoneOffset.UTC).toInstant());
            }
            catch (DateTimeParseException dateTimeParseException2) {
                throw new DateTimeParseException("Unable to parse date string '" + string2 + "' as OffsetDateTime or LocalDateTime", string2, 0);
            }
        }
    }

    public static Instant parseISODateTimeToInstant(String string) {
        if (string == null || string.trim().isEmpty()) {
            return null;
        }
        String string2 = string.trim();
        try {
            return OffsetDateTime.parse(string2).toInstant();
        }
        catch (DateTimeParseException dateTimeParseException) {
            try {
                return LocalDateTime.parse(string2).atZone(ZoneOffset.UTC).toInstant();
            }
            catch (DateTimeParseException dateTimeParseException2) {
                log.fine("Unable to parse date string '" + string2 + "' to Instant: " + dateTimeParseException2.getMessage());
                return null;
            }
        }
    }
}

