/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.util;

import de.dal33t.powerfolder.Member;
import de.dal33t.powerfolder.light.MemberInfo;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.logging.Logger;

public class Convert {
    public static final Charset UTF8 = Charset.forName("UTF-8");
    private static final Logger log = Logger.getLogger(Convert.class.getName());
    private static final long TIMEZONE_OFFSET_TO_UTC_MS = Calendar.getInstance().get(15) + Calendar.getInstance().get(16);

    private Convert() {
    }

    public static byte[] convert2Bytes(int n) {
        byte[] byArray = new byte[4];
        byArray[3] = (byte)(n & 0xFF);
        byArray[2] = (byte)(0xFF & n >> 8);
        byArray[1] = (byte)(0xFF & n >> 16);
        byArray[0] = (byte)(0xFF & n >> 24);
        return byArray;
    }

    public static int convert2Int(byte[] byArray) {
        int n = 0;
        for (byte by : byArray) {
            n <<= 8;
            if (by < 0) {
                n += by + 256;
                continue;
            }
            n += by;
        }
        return n;
    }

    public static MemberInfo[] asMemberInfos(Member[] memberArray) {
        if (memberArray == null) {
            throw new NullPointerException("Memebers is null");
        }
        MemberInfo[] memberInfoArray = new MemberInfo[memberArray.length];
        for (int i = 0; i < memberArray.length; ++i) {
            memberInfoArray[i] = memberArray[i].getInfo();
        }
        return memberInfoArray;
    }

    public static List<MemberInfo> asMemberInfos(Collection<Member> collection) {
        if (collection == null) {
            throw new NullPointerException("Memebers is null");
        }
        ArrayList<MemberInfo> arrayList = new ArrayList<MemberInfo>(collection.size());
        for (Member member : collection) {
            arrayList.add(member.getInfo());
        }
        return arrayList;
    }

    public static long convertToUTC(Date date) {
        return date.getTime() - TIMEZONE_OFFSET_TO_UTC_MS;
    }

    public static long convertToGlobalPrecision(long l) {
        return l / 2000L * 2000L;
    }
}

