/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.wizard.table;

import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.PFComponent;
import de.dal33t.powerfolder.light.FileInfo;
import de.dal33t.powerfolder.ui.model.SortedTableModel;
import de.dal33t.powerfolder.ui.util.UIUtil;
import de.dal33t.powerfolder.util.Translation;
import de.dal33t.powerfolder.util.compare.FileInfoComparator;
import de.dal33t.powerfolder.util.compare.ReverseComparator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class MultiFileRestoreTableModel
extends PFComponent
implements TableModel,
SortedTableModel {
    private static final String[] COLUMNS = new String[]{Translation.get("multi_file_restore_table_model.file_name"), Translation.get("multi_file_restore_table_model.modified_date"), Translation.get("multi_file_restore_table_model.version"), Translation.get("multi_file_restore_table_model.size")};
    static final int COL_FILE_NAME = 0;
    static final int COL_MODIFIED_DATE = 1;
    static final int COL_VERSION = 2;
    static final int COL_SIZE = 3;
    private final List<FileInfo> fileInfos = new ArrayList<FileInfo>();
    private int fileInfoComparatorType = -1;
    private boolean sortAscending = true;
    private int sortColumn;
    private final List<TableModelListener> listeners = new CopyOnWriteArrayList<TableModelListener>();

    public MultiFileRestoreTableModel(Controller controller) {
        super(controller);
    }

    @Override
    public int getRowCount() {
        return this.fileInfos.size();
    }

    @Override
    public int getColumnCount() {
        return COLUMNS.length;
    }

    @Override
    public String getColumnName(int n) {
        return COLUMNS[n];
    }

    @Override
    public Class<?> getColumnClass(int n) {
        return FileInfo.class;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        return this.fileInfos.get(n);
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        throw new UnsupportedOperationException("Cannot modify MultiFileRestoreTableModel");
    }

    @Override
    public void addTableModelListener(TableModelListener tableModelListener) {
        this.listeners.add(tableModelListener);
    }

    @Override
    public void removeTableModelListener(TableModelListener tableModelListener) {
        this.listeners.remove(tableModelListener);
    }

    @Override
    public int getSortColumn() {
        return this.sortColumn;
    }

    @Override
    public boolean isSortAscending() {
        return this.sortAscending;
    }

    @Override
    public boolean sortBy(int n) {
        this.sortColumn = n;
        switch (n) {
            case 0: {
                return this.sortMe(1);
            }
            case 2: {
                return this.sortMe(7);
            }
            case 3: {
                return this.sortMe(3);
            }
            case 1: {
                return this.sortMe(5);
            }
        }
        this.sortColumn = -1;
        return false;
    }

    public boolean sortMe(int n) {
        boolean bl;
        if (this.fileInfos.isEmpty()) {
            return false;
        }
        int n2 = this.fileInfoComparatorType;
        this.fileInfoComparatorType = n;
        if (n2 != n && (bl = this.sort())) {
            this.fireModelChanged();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean sort() {
        if (this.fileInfoComparatorType != -1) {
            FileInfoComparator fileInfoComparator = new FileInfoComparator(this.fileInfoComparatorType);
            List<FileInfo> list = this.fileInfos;
            synchronized (list) {
                if (this.sortAscending) {
                    Collections.sort(this.fileInfos, fileInfoComparator);
                } else {
                    Collections.sort(this.fileInfos, new ReverseComparator<FileInfo>(fileInfoComparator));
                }
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reverseList() {
        this.sortAscending = !this.sortAscending;
        List<FileInfo> list = this.fileInfos;
        synchronized (list) {
            Collections.reverse(this.fileInfos);
        }
        this.fireModelChanged();
    }

    private void fireModelChanged() {
        TableModelEvent tableModelEvent = new TableModelEvent(this);
        for (TableModelListener tableModelListener : this.listeners) {
            tableModelListener.tableChanged(tableModelEvent);
        }
    }

    @Override
    public void setAscending(boolean bl) {
        this.sortAscending = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFileInfos(List<FileInfo> list) {
        List<FileInfo> list2 = this.fileInfos;
        synchronized (list2) {
            this.fileInfos.clear();
            this.fileInfos.addAll(list);
        }
        this.update();
    }

    private void update() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                MultiFileRestoreTableModel.this.sort();
                MultiFileRestoreTableModel.this.fireModelChanged();
            }
        };
        UIUtil.invokeLaterInEDT(runnable);
    }

    public List<FileInfo> getFileInfos() {
        return Collections.unmodifiableList(this.fileInfos);
    }
}

