/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.wizard;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.dal33t.powerfolder.ConfigurationEntry;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.PreferencesEntry;
import de.dal33t.powerfolder.disk.SyncProfile;
import de.dal33t.powerfolder.message.Invitation;
import de.dal33t.powerfolder.ui.panel.SyncProfileSelectorPanel;
import de.dal33t.powerfolder.ui.util.SimpleComponentFactory;
import de.dal33t.powerfolder.ui.wizard.ChooseDiskLocationPanel;
import de.dal33t.powerfolder.ui.wizard.FolderCreatePanel;
import de.dal33t.powerfolder.ui.wizard.PFWizardPanel;
import de.dal33t.powerfolder.ui.wizard.SwingWorkerPanel;
import de.dal33t.powerfolder.ui.wizard.TextPanelPanel;
import de.dal33t.powerfolder.util.ConfigurationLoader;
import de.dal33t.powerfolder.util.StringUtils;
import de.dal33t.powerfolder.util.Translation;
import java.awt.Component;
import java.io.IOException;
import java.util.Properties;
import java.util.logging.Logger;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jwf.WizardPanel;

public class ReceivedInvitationPanel
extends PFWizardPanel {
    private static final Logger log = Logger.getLogger(ReceivedInvitationPanel.class.getName());
    private final Invitation invitation;
    private JLabel folderHintLabel;
    private JLabel folderNameLabel;
    private JLabel invitorHintLabel;
    private JLabel invitorLabel;
    private JLabel invitationMessageHintLabel;
    private JTextField invitationMessageLabel;
    private JLabel syncProfileHintLabel;
    private SyncProfileSelectorPanel syncProfileSelectorPanel;

    public ReceivedInvitationPanel(Controller controller, Invitation invitation) {
        super(controller);
        this.invitation = invitation;
    }

    @Override
    public boolean hasNext() {
        return this.invitation != null;
    }

    @Override
    public WizardPanel next() {
        this.getWizardContext().setAttribute("disklocation.sync_profile", this.syncProfileSelectorPanel.getSyncProfile());
        this.getWizardContext().setAttribute("disklocation.folder_info", this.invitation.folder);
        this.getWizardContext().setAttribute("folder_permission", this.invitation.getPermission());
        this.getWizardContext().setAttribute("disklocation.send_invitations", false);
        this.getWizardContext().setAttribute("folder.is.invite", true);
        this.getWizardContext().setAttribute("disklocation.prompt_text", Translation.get("wizard.what_to_do.invite.select_local"));
        TextPanelPanel textPanelPanel = new TextPanelPanel(this.getController(), Translation.get("wizard.setup_success"), Translation.get("wizard.success_join"));
        this.getWizardContext().setAttribute("successpanel", textPanelPanel);
        this.getWizardContext().setAttribute("make.friend.after", this.invitation.getSenderDevice());
        ChooseDiskLocationPanel chooseDiskLocationPanel = new ChooseDiskLocationPanel(this.getController(), this.invitation.getSuggestedLocalBase(this.getController()).toAbsolutePath().toString(), new FolderCreatePanel(this.getController()));
        if (this.serverAgreeInvitationEnabled(this.invitation)) {
            return new SwingWorkerPanel(this.getController(), new AcceptInviteTask(), Translation.get(""), Translation.get(""), chooseDiskLocationPanel);
        }
        return chooseDiskLocationPanel;
    }

    private boolean serverAgreeInvitationEnabled(Invitation invitation) {
        boolean bl = ConfigurationEntry.FOLDER_AGREE_INVITATION_ENABLED.getValueBoolean(this.getController());
        if (invitation.getServer() != null && ConfigurationEntry.SERVER_FEDERATION_ENABLED.getValueBoolean(this.getController()).booleanValue()) {
            try {
                Properties properties = ConfigurationLoader.loadPreConfiguration(invitation.getServer().getWebUrl());
                String string = (String)properties.get(ConfigurationEntry.FOLDER_AGREE_INVITATION_ENABLED.getConfigKey());
                if (StringUtils.isNotBlank(string)) {
                    bl = Boolean.parseBoolean(string);
                }
            }
            catch (IOException iOException) {
                log.warning("Failed to get config from federation server " + invitation.getServer().getWebUrl());
                return bl;
            }
        }
        return bl;
    }

    @Override
    protected JPanel buildContent() {
        FormLayout formLayout = new FormLayout("right:pref, 3dlu, pref, pref:grow", "pref, 6dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        panelBuilder.setBorder(this.createFewContentBorder());
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.addLabel(Translation.get("wizard.folder_invitation.intro", this.invitation.getSender(), this.invitation.folder.getLocalizedName()), cellConstraints.xyw(1, 1, 4));
        int n = 3;
        String string = this.invitation.getInvitationText();
        if (string != null && string.trim().length() > 0) {
            panelBuilder.add((Component)this.invitationMessageHintLabel, cellConstraints.xy(1, n));
            panelBuilder.add((Component)this.invitationMessageLabel, cellConstraints.xy(3, n));
            n += 2;
        }
        if (PreferencesEntry.EXPERT_MODE.getValueBoolean(this.getController()).booleanValue()) {
            panelBuilder.add((Component)this.syncProfileHintLabel, cellConstraints.xy(1, n));
            JPanel jPanel = (JPanel)this.syncProfileSelectorPanel.getUIComponent();
            jPanel.setOpaque(false);
            panelBuilder.add((Component)jPanel, cellConstraints.xyw(3, n, 2));
        }
        n += 2;
        return panelBuilder.getPanel();
    }

    @Override
    protected void initComponents() {
        this.folderHintLabel = new JLabel(Translation.get("general.folder"));
        this.folderHintLabel.setEnabled(false);
        this.folderNameLabel = SimpleComponentFactory.createLabel();
        this.invitorHintLabel = new JLabel(Translation.get("general.inviter"));
        this.invitorHintLabel.setEnabled(false);
        this.invitorLabel = SimpleComponentFactory.createLabel();
        this.invitationMessageHintLabel = new JLabel(Translation.get("general.message"));
        this.invitationMessageHintLabel.setEnabled(false);
        this.invitationMessageLabel = new JTextField();
        this.invitationMessageLabel.setEditable(false);
        this.syncProfileHintLabel = new JLabel(Translation.get("general.synchonisation"));
        this.syncProfileHintLabel.setEnabled(false);
        this.syncProfileSelectorPanel = new SyncProfileSelectorPanel(this.getController());
        this.syncProfileSelectorPanel.setEnabled(false);
        this.loadInvitation();
    }

    @Override
    protected String getTitle() {
        return Translation.get("wizard.folder_invitation.title");
    }

    private void loadInvitation() {
        log.info("Loaded invitation " + this.invitation);
        if (this.invitation != null) {
            this.folderHintLabel.setEnabled(true);
            this.folderNameLabel.setText(this.invitation.folder.getLocalizedName());
            this.invitorHintLabel.setEnabled(true);
            this.invitorLabel.setText(this.invitation.getSender());
            this.invitationMessageHintLabel.setEnabled(true);
            this.invitationMessageLabel.setText(this.invitation.getInvitationText() == null ? "" : this.invitation.getInvitationText());
            this.syncProfileHintLabel.setEnabled(true);
            this.syncProfileSelectorPanel.setEnabled(true);
            SyncProfile syncProfile = this.invitation.getSuggestedSyncProfile();
            this.syncProfileSelectorPanel.setSyncProfile(syncProfile, false);
        } else {
            this.folderHintLabel.setEnabled(false);
            this.folderNameLabel.setText("");
            this.invitorHintLabel.setEnabled(false);
            this.invitorLabel.setText("");
            this.invitationMessageHintLabel.setEnabled(false);
            this.invitationMessageLabel.setText("");
            this.syncProfileHintLabel.setEnabled(false);
            this.syncProfileSelectorPanel.setEnabled(false);
        }
    }

    private class AcceptInviteTask
    implements Runnable {
        private AcceptInviteTask() {
        }

        @Override
        public void run() {
            ReceivedInvitationPanel.this.getController().getOSClient().getSecurityService().acceptInvitation(ReceivedInvitationPanel.this.invitation);
        }
    }
}

