/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.wizard;

import com.jgoodies.binding.value.ValueHolder;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.dal33t.powerfolder.ConfigurationEntry;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.Feature;
import de.dal33t.powerfolder.PreferencesEntry;
import de.dal33t.powerfolder.clientserver.RemoteCallException;
import de.dal33t.powerfolder.clientserver.ServerClient;
import de.dal33t.powerfolder.disk.SyncProfile;
import de.dal33t.powerfolder.light.FolderInfo;
import de.dal33t.powerfolder.ui.action.BaseAction;
import de.dal33t.powerfolder.ui.dialog.DialogFactory;
import de.dal33t.powerfolder.ui.dialog.GenericDialogType;
import de.dal33t.powerfolder.ui.panel.SyncProfileSelectorPanel;
import de.dal33t.powerfolder.ui.util.Help;
import de.dal33t.powerfolder.ui.util.Icons;
import de.dal33t.powerfolder.ui.widget.ActionLabel;
import de.dal33t.powerfolder.ui.widget.ActivityVisualizationWorker;
import de.dal33t.powerfolder.ui.widget.JButtonMini;
import de.dal33t.powerfolder.ui.wizard.FolderCreateItem;
import de.dal33t.powerfolder.ui.wizard.FolderCreatePanel;
import de.dal33t.powerfolder.ui.wizard.PFWizard;
import de.dal33t.powerfolder.ui.wizard.PFWizardPanel;
import de.dal33t.powerfolder.util.PathUtils;
import de.dal33t.powerfolder.util.StringUtils;
import de.dal33t.powerfolder.util.Translation;
import de.dal33t.powerfolder.util.UserDirectories;
import de.dal33t.powerfolder.util.UserDirectory;
import de.dal33t.powerfolder.util.os.LinuxUtil;
import de.dal33t.powerfolder.util.os.OSUtil;
import de.dal33t.powerfolder.util.os.Win32.WinUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Semaphore;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jwf.WizardPanel;

public class MultiOnlineStorageSetupPanel
extends PFWizardPanel {
    private Map<FolderInfo, SyncProfile> folderProfileMap;
    private Map<FolderInfo, Path> folderLocalBaseMap;
    private JComboBox<String> folderInfoCombo;
    private JTextField folderInfoField;
    private DefaultComboBoxModel<String> folderInfoComboModel;
    private SyncProfileSelectorPanel syncProfileSelectorPanel;
    private JCheckBox manualSyncCB;
    private boolean changingSelection;
    private JTextField localFolderField;
    private JButton localFolderButton;
    private ActionLabel mountAsWebDavLabel;
    private ServerClient serverClient;
    private Date lastFetch;
    private String webDAVURL;

    public MultiOnlineStorageSetupPanel(Controller controller) {
        super(controller);
        this.serverClient = controller.getOSClient();
    }

    @Override
    public boolean hasNext() {
        return true;
    }

    @Override
    public WizardPanel next() {
        ArrayList<FolderCreateItem> arrayList = new ArrayList<FolderCreateItem>();
        for (Map.Entry<FolderInfo, SyncProfile> entry : this.folderProfileMap.entrySet()) {
            SyncProfile syncProfile = PreferencesEntry.EXPERT_MODE.getValueBoolean(this.getController()) != false ? entry.getValue() : (this.manualSyncCB.isSelected() ? SyncProfile.MANUAL_SYNCHRONIZATION : SyncProfile.AUTOMATIC_SYNCHRONIZATION);
            Path path = this.folderLocalBaseMap.get(entry.getKey());
            FolderCreateItem folderCreateItem = new FolderCreateItem(path);
            folderCreateItem.setArchiveHistory(ConfigurationEntry.DEFAULT_ARCHIVE_VERSIONS.getValueInt(this.getController()));
            folderCreateItem.setSyncProfile(syncProfile);
            folderCreateItem.setFolderInfo(entry.getKey());
            arrayList.add(folderCreateItem);
        }
        this.getWizardContext().setAttribute("disklocation.folder_create_items", arrayList);
        return new FolderCreatePanel(this.getController());
    }

    @Override
    protected JPanel buildContent() {
        FormLayout formLayout = new FormLayout("right:pref, 3dlu, 140dlu, 3dlu, pref, pref:grow", "pref, 6dlu, pref, 6dlu, pref, 30dlu, pref");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        panelBuilder.setBorder(this.createFewContentBorder());
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.addLabel(Translation.get("general.folder"), cellConstraints.xy(1, 1));
        panelBuilder.add(this.folderInfoCombo, cellConstraints.xy(3, 1));
        panelBuilder.add((Component)this.folderInfoField, cellConstraints.xy(3, 1));
        panelBuilder.add((Component)new JLabel(Translation.get("wizard.multi_online_storage_setup.local_folder_location")), cellConstraints.xy(1, 3));
        panelBuilder.add((Component)this.localFolderField, cellConstraints.xy(3, 3));
        if (!ConfigurationEntry.FOLDER_CREATE_IN_BASEDIR_ONLY.getValueBoolean(this.getController()).booleanValue()) {
            panelBuilder.add((Component)this.localFolderButton, cellConstraints.xy(5, 3));
        }
        if (PreferencesEntry.EXPERT_MODE.getValueBoolean(this.getController()).booleanValue()) {
            panelBuilder.add((Component)new JLabel(Translation.get("general.transfer_mode")), cellConstraints.xy(1, 5));
            JPanel jPanel = (JPanel)this.syncProfileSelectorPanel.getUIComponent();
            jPanel.setOpaque(false);
            panelBuilder.add((Component)jPanel, cellConstraints.xyw(3, 5, 4));
        } else {
            this.syncProfileSelectorPanel.getUIComponent();
            if (Feature.MANUAL_SYNC_CB.isEnabled()) {
                panelBuilder.add((Component)this.manualSyncCB, cellConstraints.xyw(3, 5, 4));
            }
        }
        panelBuilder.add((Component)this.mountAsWebDavLabel.getUIComponent(), cellConstraints.xy(3, 7));
        return panelBuilder.getPanel();
    }

    @Override
    protected void initComponents() {
        this.localFolderField = new JTextField();
        if (!ConfigurationEntry.FOLDER_CREATE_IN_BASEDIR_ONLY.getValueBoolean(this.getController()).booleanValue()) {
            this.localFolderButton = new JButtonMini(Icons.getIconById("directory.icon"), Translation.get("wizard.multi_online_storage_setup.select_directory"));
            MyActionListener myActionListener = new MyActionListener();
            this.localFolderButton.addActionListener(myActionListener);
        } else {
            this.localFolderField.setEnabled(false);
        }
        this.manualSyncCB = new JCheckBox(Translation.get("transfer_mode.manual_synchronization.name"));
        this.syncProfileSelectorPanel = new SyncProfileSelectorPanel(this.getController());
        this.syncProfileSelectorPanel.addModelValueChangeListener(new MyPropertyValueChangeListener());
        this.folderInfoComboModel = new DefaultComboBoxModel();
        this.folderInfoCombo = new JComboBox<String>(this.folderInfoComboModel);
        this.folderInfoCombo.addItemListener(new MyItemListener());
        this.folderInfoField = new JTextField();
        this.folderInfoField.setEditable(false);
        this.mountAsWebDavLabel = new ActionLabel(this.getController(), new MyMountAsWebDavAction(this.getController()));
        this.mountAsWebDavLabel.setVisible(this.serverClient.supportsWebDAV());
    }

    @Override
    public void afterDisplay() {
        boolean bl = PreferencesEntry.EXPERT_MODE.getValueBoolean(this.getController());
        Map<String, UserDirectory> map = UserDirectories.getUserDirectoriesFiltered(this.getController(), bl);
        this.folderProfileMap = new HashMap<FolderInfo, SyncProfile>();
        this.folderLocalBaseMap = new HashMap<FolderInfo, Path>();
        String string = this.getController().getFolderRepository().getFoldersBasedirString();
        List list = (List)this.getWizardContext().getAttribute("folder.infos");
        if (list.size() == 1) {
            this.folderInfoField.setText(((FolderInfo)list.get(0)).getLocalizedName());
            this.folderInfoCombo.setVisible(false);
        } else {
            this.folderInfoField.setVisible(false);
        }
        for (FolderInfo folderInfo : list) {
            Path path;
            this.folderProfileMap.put(folderInfo, SyncProfile.getDefault(this.getController()));
            if (map.get(folderInfo.getLocalizedName()) == null) {
                Object object = folderInfo.getLocalizedName();
                String string2 = this.getOwnerDisplayname(folderInfo);
                if (StringUtils.isNotBlank(string2)) {
                    object = (String)object + " (";
                    object = (String)object + string2;
                    object = (String)object + ")";
                }
                path = Paths.get(string, PathUtils.removeInvalidFilenameChars(((String)object).trim()));
            } else {
                path = map.get(folderInfo.getLocalizedName()).getDirectory();
            }
            this.folderLocalBaseMap.put(folderInfo, path);
            this.folderInfoComboModel.addElement(folderInfo.getLocalizedName());
        }
        if (PFWizard.hideFolderJoinWizard(this.getController())) {
            this.getWizard().next();
        }
    }

    @Override
    protected String getTitle() {
        return Translation.get("wizard.multi_online_storage_setup.title");
    }

    private void folderInfoComboSelectionChange() {
        this.changingSelection = true;
        Object object = this.folderInfoCombo.getSelectedItem();
        FolderInfo folderInfo = null;
        for (FolderInfo folderInfo2 : this.folderProfileMap.keySet()) {
            if (!folderInfo2.getLocalizedName().equals(object)) continue;
            folderInfo = folderInfo2;
            break;
        }
        if (folderInfo != null) {
            this.localFolderField.setText(this.folderLocalBaseMap.get(folderInfo).toAbsolutePath().toString());
            this.syncProfileSelectorPanel.setSyncProfile(this.folderProfileMap.get(folderInfo), false);
        }
        this.changingSelection = false;
    }

    private void syncProfileSelectorPanelChange() {
        if (!this.changingSelection) {
            Object object = this.folderInfoCombo.getSelectedItem();
            FolderInfo folderInfo = null;
            for (FolderInfo folderInfo2 : this.folderProfileMap.keySet()) {
                if (!folderInfo2.getLocalizedName().equals(object)) continue;
                folderInfo = folderInfo2;
                break;
            }
            if (folderInfo != null) {
                this.folderProfileMap.put(folderInfo, this.syncProfileSelectorPanel.getSyncProfile());
            }
        }
    }

    private synchronized void createWebDAVURL() {
        if (!this.serverClient.isConnected() || !this.serverClient.isLoggedIn()) {
            return;
        }
        if (this.lastFetch == null || this.lastFetch.before(new Date(System.currentTimeMillis() - 10000L))) {
            FolderInfo folderInfo = null;
            if (this.folderLocalBaseMap.size() == 1) {
                folderInfo = this.folderLocalBaseMap.keySet().iterator().next();
            } else {
                int n = this.folderInfoCombo.getSelectedIndex();
                int n2 = 0;
                for (FolderInfo folderInfo2 : this.folderProfileMap.keySet()) {
                    if (n2++ != n) continue;
                    folderInfo = folderInfo2;
                    break;
                }
            }
            if (folderInfo != null) {
                this.webDAVURL = this.serverClient.getFolderService(folderInfo).getWebDAVURL(folderInfo);
            }
            this.lastFetch = new Date();
        }
    }

    private String getOwnerDisplayname(final FolderInfo folderInfo) {
        if (!this.serverClient.isConnected() || !this.serverClient.isLoggedIn()) {
            return null;
        }
        if (this.serverClient.getAccount().hasOwnerPermission(folderInfo)) {
            return null;
        }
        final ValueHolder valueHolder = new ValueHolder();
        final Semaphore semaphore = new Semaphore(0);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                String string;
                try {
                    string = MultiOnlineStorageSetupPanel.this.serverClient.getFolderService(folderInfo).getOwnerDisplayname(folderInfo);
                }
                catch (RemoteCallException remoteCallException) {
                    Logger.getLogger(MultiOnlineStorageSetupPanel.class.getName()).warning("Unsupported/Old server. Not able to retrieve owner name of " + folderInfo.getName() + ". " + remoteCallException);
                    string = "";
                }
                valueHolder.setValue(string);
                semaphore.release();
            }
        };
        this.getController().getIOProvider().startIO(runnable);
        try {
            semaphore.acquire();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return (String)valueHolder.getValue();
    }

    private void closeWizard() {
        JDialog jDialog = this.getWizardDialog();
        jDialog.setVisible(false);
        jDialog.dispose();
    }

    private JDialog getWizardDialog() {
        return (JDialog)this.getWizardContext().getAttribute("dialog");
    }

    private void createWebdavConnection() {
        ActivityVisualizationWorker activityVisualizationWorker = new ActivityVisualizationWorker(this.getController().getUIController()){

            @Override
            protected String getTitle() {
                return Translation.get("exp_folder_view.webdav_title");
            }

            @Override
            protected String getWorkingText() {
                return Translation.get("exp_folder_view.webdav_working_text");
            }

            @Override
            public Object construct() throws Throwable {
                try {
                    MultiOnlineStorageSetupPanel.this.createWebDAVURL();
                    if (OSUtil.isLinux()) {
                        return LinuxUtil.mountWebDAV(MultiOnlineStorageSetupPanel.this.serverClient, MultiOnlineStorageSetupPanel.this.webDAVURL);
                    }
                    WinUtils winUtils = WinUtils.getInstance();
                    if (winUtils != null) {
                        return WinUtils.mountWebDAV(MultiOnlineStorageSetupPanel.this.serverClient, MultiOnlineStorageSetupPanel.this.webDAVURL);
                    }
                    return Character.valueOf('N');
                }
                catch (Exception exception) {
                    return "N" + exception.getMessage();
                }
            }

            @Override
            public void finished() {
                String string = (String)this.get();
                if (string != null) {
                    if (string.startsWith("Y")) {
                        String[] stringArray;
                        for (final String string2 : stringArray = string.substring(1).split("\\s")) {
                            if (string2.length() != 2 || string2.charAt(1) != ':') continue;
                            MultiOnlineStorageSetupPanel.this.getController().getIOProvider().startIO(new Runnable(){

                                @Override
                                public void run() {
                                    PathUtils.openFile(Paths.get(string2, new String[0]));
                                }
                            });
                            MultiOnlineStorageSetupPanel.this.closeWizard();
                            break;
                        }
                    } else if (string.startsWith("N")) {
                        String[] stringArray = Help.hasWiki(MultiOnlineStorageSetupPanel.this.getController()) ? new String[]{Translation.get("general.ok"), Translation.get("general.help")} : new String[]{Translation.get("general.ok")};
                        int n = DialogFactory.genericDialog(MultiOnlineStorageSetupPanel.this.getController(), Translation.get("exp_folder_view.webdav_failure_title"), Translation.get("exp_folder_view.webdav_failure_text", string.substring(1)), stringArray, 0, GenericDialogType.ERROR);
                        if (n == 1) {
                            Help.openWikiArticle(MultiOnlineStorageSetupPanel.this.getController(), "WebDAV");
                        }
                    }
                }
            }
        };
        activityVisualizationWorker.start();
    }

    private void configureLocalFolder() {
        Object object;
        Object object2 = this.folderInfoCombo.getSelectedItem();
        FolderInfo folderInfo = null;
        Object object3 = this.folderLocalBaseMap.keySet().iterator();
        while (object3.hasNext()) {
            object = object3.next();
            if (!((FolderInfo)object).getLocalizedName().equals(object2)) continue;
            folderInfo = object;
            break;
        }
        if (folderInfo != null && !(object3 = DialogFactory.chooseDirectory(this.getController().getUIController(), this.folderLocalBaseMap.get(folderInfo), false)).isEmpty()) {
            object = (Path)object3.get(0);
            List list = (List)this.getWizardContext().getAttribute("folder.infos");
            if (list != null && list.size() == 1) {
                String string = ((FolderInfo)list.get(0)).getName();
                if (!object.getFileName().toString().equals(string)) {
                    object = object.resolve(string);
                }
            }
            this.localFolderField.setText(object.toAbsolutePath().toString());
            this.folderLocalBaseMap.put(folderInfo, (Path)object);
        }
    }

    private class MyActionListener
    implements ActionListener {
        private MyActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource().equals(MultiOnlineStorageSetupPanel.this.localFolderButton)) {
                MultiOnlineStorageSetupPanel.this.configureLocalFolder();
            }
        }
    }

    private class MyPropertyValueChangeListener
    implements PropertyChangeListener {
        private MyPropertyValueChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            MultiOnlineStorageSetupPanel.this.syncProfileSelectorPanelChange();
        }
    }

    private class MyItemListener
    implements ItemListener {
        private MyItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            MultiOnlineStorageSetupPanel.this.folderInfoComboSelectionChange();
        }
    }

    private class MyMountAsWebDavAction
    extends BaseAction {
        private MyMountAsWebDavAction(Controller controller) {
            super("action_webdav", controller);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MultiOnlineStorageSetupPanel.this.createWebdavConnection();
        }
    }
}

