/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.wizard;

import com.jgoodies.binding.value.ValueHolder;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.dal33t.powerfolder.ConfigurationEntry;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.PreferencesEntry;
import de.dal33t.powerfolder.disk.SyncProfile;
import de.dal33t.powerfolder.light.FolderInfo;
import de.dal33t.powerfolder.light.FolderInfoFactory;
import de.dal33t.powerfolder.ui.dialog.DialogFactory;
import de.dal33t.powerfolder.ui.dialog.GenericDialogType;
import de.dal33t.powerfolder.ui.panel.ArchiveModeSelectorPanel;
import de.dal33t.powerfolder.ui.panel.SyncProfileSelectorPanel;
import de.dal33t.powerfolder.ui.wizard.FolderCreateItem;
import de.dal33t.powerfolder.ui.wizard.FolderCreatePanel;
import de.dal33t.powerfolder.ui.wizard.PFWizardPanel;
import de.dal33t.powerfolder.ui.wizard.TextPanelPanel;
import de.dal33t.powerfolder.util.PathUtils;
import de.dal33t.powerfolder.util.Translation;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jwf.WizardPanel;

public class MultiFolderSetupPanel
extends PFWizardPanel {
    private List<FolderCreateItem> folderCreateItems;
    private JComboBox<String> localBaseCombo;
    private DefaultComboBoxModel<String> localBaseComboModel;
    private FolderCreateItem selectedItem;
    private ValueModel versionsModel;
    private JTextField nameField;
    private SyncProfileSelectorPanel syncProfileSelectorPanel;
    private ArchiveModeSelectorPanel archiveModeSelectorPanel;

    public MultiFolderSetupPanel(Controller controller) {
        super(controller);
    }

    @Override
    public boolean hasNext() {
        return true;
    }

    @Override
    public boolean validateNext() {
        for (FolderCreateItem folderCreateItem : this.folderCreateItems) {
            if (folderCreateItem.getFolderInfo().getName() != null && folderCreateItem.getFolderInfo().getName().length() != 0) continue;
            DialogFactory.genericDialog(this.getController(), Translation.get("wizard.multi_folder_setup.no_name.title"), Translation.get("wizard.multi_folder_setup.no_name.text", folderCreateItem.getLocalBase().toAbsolutePath().toString()), GenericDialogType.ERROR);
            return false;
        }
        return true;
    }

    @Override
    public WizardPanel next() {
        TextPanelPanel textPanelPanel = new TextPanelPanel(this.getController(), Translation.get("wizard.setup_success"), Translation.get("wizard.success_join"));
        this.getWizardContext().setAttribute("successpanel", textPanelPanel);
        return new FolderCreatePanel(this.getController());
    }

    @Override
    protected JPanel buildContent() {
        FormLayout formLayout = new FormLayout("right:pref, 3dlu, 140dlu, pref:grow", "pref, 6dlu, pref, 6dlu, pref, 6dlu, pref");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.addLabel(Translation.get("general.directory"), cellConstraints.xy(1, 1));
        panelBuilder.add(this.localBaseCombo, cellConstraints.xy(3, 1));
        panelBuilder.addLabel(Translation.get("general.folder_name"), cellConstraints.xy(1, 3));
        panelBuilder.add((Component)this.nameField, cellConstraints.xy(3, 3));
        if (PreferencesEntry.EXPERT_MODE.getValueBoolean(this.getController()).booleanValue()) {
            panelBuilder.add((Component)new JLabel(Translation.get("general.transfer_mode")), cellConstraints.xy(1, 5));
            JPanel jPanel = (JPanel)this.syncProfileSelectorPanel.getUIComponent();
            jPanel.setOpaque(false);
            panelBuilder.add((Component)jPanel, cellConstraints.xyw(3, 5, 2));
        }
        panelBuilder.add((Component)new JLabel(Translation.get("general.local_archive_mode")), cellConstraints.xy(1, 7));
        panelBuilder.add(this.archiveModeSelectorPanel.getUIComponent(), cellConstraints.xyw(3, 7, 2));
        return panelBuilder.getPanel();
    }

    @Override
    protected void initComponents() {
        this.syncProfileSelectorPanel = new SyncProfileSelectorPanel(this.getController());
        this.syncProfileSelectorPanel.addModelValueChangeListener(new MyPropertyValueChangeListener());
        MyKeyListener myKeyListener = new MyKeyListener();
        this.folderCreateItems = new ArrayList<FolderCreateItem>();
        this.localBaseComboModel = new DefaultComboBoxModel();
        this.localBaseCombo = new JComboBox<String>(this.localBaseComboModel);
        this.nameField = new JTextField();
        this.nameField.addKeyListener(myKeyListener);
        this.versionsModel = new ValueHolder();
        this.archiveModeSelectorPanel = new ArchiveModeSelectorPanel(this.getController(), this.versionsModel);
        this.archiveModeSelectorPanel.setArchiveMode(ConfigurationEntry.DEFAULT_ARCHIVE_VERSIONS.getValueInt(this.getController()));
        MyPropertyChangeListener myPropertyChangeListener = new MyPropertyChangeListener();
        this.versionsModel.addValueChangeListener(myPropertyChangeListener);
        MyItemListener myItemListener = new MyItemListener();
        this.localBaseCombo.addItemListener(myItemListener);
    }

    @Override
    public void afterDisplay() {
        this.localBaseComboModel.removeAllElements();
        Object object = this.getWizardContext().getAttribute("disklocation.folder_create_items");
        if (object != null && object instanceof List) {
            List list = (List)object;
            for (Object e : list) {
                if (!(e instanceof FolderCreateItem)) continue;
                FolderCreateItem folderCreateItem = (FolderCreateItem)e;
                if (folderCreateItem.getFolderInfo() == null) {
                    MultiFolderSetupPanel.createFolderInfo(folderCreateItem);
                }
                this.folderCreateItems.add(folderCreateItem);
                this.localBaseComboModel.addElement(folderCreateItem.getLocalBase().toAbsolutePath().toString());
            }
        }
        this.localBaseComboSelectionChanged();
    }

    @Override
    protected String getTitle() {
        return Translation.get("wizard.multi_folder_setup.title");
    }

    private void localBaseComboSelectionChanged() {
        String string = (String)this.localBaseComboModel.getSelectedItem();
        for (FolderCreateItem folderCreateItem : this.folderCreateItems) {
            if (!folderCreateItem.getLocalBase().toAbsolutePath().toString().equals(string)) continue;
            this.selectedItem = folderCreateItem;
            FolderInfo folderInfo = folderCreateItem.getFolderInfo();
            this.nameField.setText(folderInfo.getName());
            SyncProfile syncProfile = folderCreateItem.getSyncProfile();
            if (syncProfile == null) {
                syncProfile = SyncProfile.AUTOMATIC_SYNCHRONIZATION;
            }
            this.syncProfileSelectorPanel.setSyncProfile(syncProfile, false);
            break;
        }
    }

    private static void createFolderInfo(FolderCreateItem folderCreateItem) {
        String string = PathUtils.getSuggestedFolderName(folderCreateItem.getLocalBase());
        FolderInfo folderInfo = FolderInfoFactory.newTopFolder(string);
        folderCreateItem.setFolderInfo(folderInfo);
    }

    private void syncProfileSelectorPanelChange() {
        if (this.selectedItem != null) {
            this.selectedItem.setSyncProfile(this.syncProfileSelectorPanel.getSyncProfile());
        }
    }

    private void updateModeAndVersion() {
        if (this.selectedItem != null) {
            int n = (Integer)this.versionsModel.getValue();
            this.selectedItem.setArchiveHistory(n);
        }
    }

    private class MyPropertyValueChangeListener
    implements PropertyChangeListener {
        private MyPropertyValueChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            MultiFolderSetupPanel.this.syncProfileSelectorPanelChange();
        }
    }

    private class MyKeyListener
    implements KeyListener {
        private MyKeyListener() {
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            if (MultiFolderSetupPanel.this.selectedItem != null) {
                MultiFolderSetupPanel.this.selectedItem.setFolderInfo(FolderInfoFactory.newTopFolder(((MultiFolderSetupPanel)MultiFolderSetupPanel.this).selectedItem.getFolderInfo().id, MultiFolderSetupPanel.this.nameField.getText()));
            }
        }
    }

    private class MyPropertyChangeListener
    implements PropertyChangeListener {
        private MyPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getSource() == MultiFolderSetupPanel.this.versionsModel) {
                MultiFolderSetupPanel.this.updateModeAndVersion();
            }
        }
    }

    private class MyItemListener
    implements ItemListener {
        private MyItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getSource() == MultiFolderSetupPanel.this.localBaseCombo) {
                MultiFolderSetupPanel.this.localBaseComboSelectionChanged();
            }
        }
    }
}

