/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.wizard;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.clientserver.FolderService;
import de.dal33t.powerfolder.clientserver.ServerClient;
import de.dal33t.powerfolder.disk.FileArchiver;
import de.dal33t.powerfolder.disk.Folder;
import de.dal33t.powerfolder.light.FileInfo;
import de.dal33t.powerfolder.ui.util.UIUtil;
import de.dal33t.powerfolder.ui.wizard.FileRestoringPanel;
import de.dal33t.powerfolder.ui.wizard.PFWizardPanel;
import de.dal33t.powerfolder.ui.wizard.table.MultiFileRestoreTable;
import de.dal33t.powerfolder.ui.wizard.table.MultiFileRestoreTableModel;
import de.dal33t.powerfolder.util.Translation;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CancellationException;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.SwingWorker;
import jwf.WizardPanel;

public class MultiFileRestorePanel
extends PFWizardPanel {
    private final List<FileInfo> fileInfosToRestore;
    private final JLabel infoLabel;
    private final JLabel warningLabel;
    private JProgressBar bar;
    private JScrollPane scrollPane;
    private boolean hasNext;
    private SwingWorker<List<FileInfo>, FileInfo> worker;
    private MultiFileRestoreTableModel tableModel = new MultiFileRestoreTableModel(this.getController());

    public MultiFileRestorePanel(Controller controller, List<FileInfo> list) {
        super(controller);
        this.fileInfosToRestore = list;
        this.infoLabel = new JLabel();
        this.warningLabel = new JLabel();
    }

    @Override
    protected JComponent buildContent() {
        FormLayout formLayout = new FormLayout("140dlu, pref:grow", "pref, 3dlu, pref, 3dlu, pref");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.add((Component)this.infoLabel, cellConstraints.xyw(1, 1, 2));
        panelBuilder.add((Component)this.scrollPane, cellConstraints.xyw(1, 3, 2));
        panelBuilder.add((Component)this.bar, cellConstraints.xy(1, 3));
        panelBuilder.add((Component)this.warningLabel, cellConstraints.xyw(1, 5, 2));
        return panelBuilder.getPanel();
    }

    @Override
    protected void afterDisplay() {
        this.loadVersions();
    }

    private void loadVersions() {
        this.infoLabel.setText(Translation.get("wizard.multi_file_restore.retrieving.text"));
        this.hasNext = false;
        this.updateButtons();
        if (this.worker != null) {
            this.worker.cancel(false);
        }
        this.tableModel.setFileInfos(new ArrayList<FileInfo>());
        this.bar.setVisible(true);
        this.scrollPane.setVisible(false);
        this.worker = new VersionLoaderWorker();
        this.worker.execute();
    }

    @Override
    protected String getTitle() {
        return Translation.get("wizard.multi_file_restore.title");
    }

    @Override
    protected void initComponents() {
        this.tableModel = new MultiFileRestoreTableModel(this.getController());
        MultiFileRestoreTable multiFileRestoreTable = new MultiFileRestoreTable(this.tableModel);
        this.scrollPane = new JScrollPane(multiFileRestoreTable);
        this.scrollPane.setPreferredSize(new Dimension(400, 200));
        this.scrollPane.setVisible(false);
        UIUtil.removeBorder(this.scrollPane);
        UIUtil.setZeroWidth(this.scrollPane);
        this.bar = new JProgressBar(0, 100);
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    @Override
    public WizardPanel next() {
        return new FileRestoringPanel(this.getController(), this.tableModel.getFileInfos());
    }

    private class VersionLoaderWorker
    extends SwingWorker<List<FileInfo>, FileInfo> {
        private int fileInfosProcessed;

        private VersionLoaderWorker() {
        }

        @Override
        public List<FileInfo> doInBackground() {
            MultiFileRestorePanel.this.bar.setIndeterminate(true);
            MultiFileRestorePanel.this.bar.setValue(0);
            MultiFileRestorePanel.this.warningLabel.setText("");
            ArrayList<FileInfo> arrayList = new ArrayList<FileInfo>(MultiFileRestorePanel.this.fileInfosToRestore.size());
            try {
                ArrayList arrayList2 = new ArrayList();
                arrayList2.addAll(MultiFileRestorePanel.this.fileInfosToRestore);
                for (FileInfo fileInfo : arrayList2) {
                    Folder folder = fileInfo.getFolder(MultiFileRestorePanel.this.getController().getFolderRepository());
                    if (folder == null) continue;
                    FolderService folderService = null;
                    ServerClient serverClient = MultiFileRestorePanel.this.getController().getOSClient();
                    if (serverClient.isConnected() && serverClient.isLoggedIn()) {
                        folderService = serverClient.getFolderService(folder.getInfo());
                    }
                    FileArchiver fileArchiver = folder.getFileArchiver();
                    if (this.isCancelled()) {
                        return Collections.emptyList();
                    }
                    List<FileInfo> list = fileArchiver.getArchivedFilesInfos(fileInfo);
                    FileInfo fileInfo2 = null;
                    for (FileInfo fileInfo3 : list) {
                        if (!this.isBetterVersion(fileInfo2, fileInfo3)) continue;
                        fileInfo2 = fileInfo3;
                    }
                    if (folderService != null) {
                        try {
                            List<FileInfo> list2 = folderService.getArchivedFilesInfos(fileInfo);
                            Iterator iterator = list2.iterator();
                            while (iterator.hasNext()) {
                                FileInfo fileInfo4 = (FileInfo)iterator.next();
                                if (!this.isBetterVersion(fileInfo2, fileInfo4)) continue;
                                fileInfo2 = fileInfo4;
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (fileInfo2 == null) continue;
                    arrayList.add(fileInfo2);
                    this.publish(fileInfo2);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            Collections.reverse(arrayList);
            return arrayList;
        }

        private boolean isBetterVersion(FileInfo fileInfo, FileInfo fileInfo2) {
            return fileInfo == null || fileInfo.getVersion() < fileInfo2.getVersion();
        }

        @Override
        protected void process(List<FileInfo> list) {
            this.fileInfosProcessed += list.size();
            if (MultiFileRestorePanel.this.fileInfosToRestore.isEmpty()) {
                MultiFileRestorePanel.this.bar.setIndeterminate(true);
            } else {
                MultiFileRestorePanel.this.bar.setIndeterminate(false);
                MultiFileRestorePanel.this.bar.setValue(100 * this.fileInfosProcessed / MultiFileRestorePanel.this.fileInfosToRestore.size());
                MultiFileRestorePanel.this.infoLabel.setText(Translation.get("general.processed", String.valueOf(this.fileInfosProcessed), String.valueOf(MultiFileRestorePanel.this.fileInfosToRestore.size())));
            }
        }

        @Override
        protected void done() {
            MultiFileRestorePanel.this.scrollPane.setVisible(true);
            MultiFileRestorePanel.this.bar.setVisible(false);
            MultiFileRestorePanel.this.hasNext = false;
            try {
                MultiFileRestorePanel.this.tableModel.setFileInfos((List)this.get());
                if (((List)this.get()).isEmpty()) {
                    MultiFileRestorePanel.this.infoLabel.setText(Translation.get("wizard.multi_file_restore.retrieved_none.text"));
                } else {
                    MultiFileRestorePanel.this.infoLabel.setText(Translation.get("wizard.multi_file_restore.retrieved.text"));
                    MultiFileRestorePanel.this.hasNext = true;
                    if (this.fileInfosProcessed < MultiFileRestorePanel.this.fileInfosToRestore.size()) {
                        MultiFileRestorePanel.this.warningLabel.setText(Translation.get("wizard.multi_file_restore.some.text"));
                    }
                }
            }
            catch (CancellationException cancellationException) {
                MultiFileRestorePanel.this.infoLabel.setText(Translation.get("wizard.multi_file_restore.retrieve_cancelled.text"));
            }
            catch (Exception exception) {
                MultiFileRestorePanel.this.infoLabel.setText(Translation.get("wizard.multi_file_restore.retrieve_exception.text", exception.getMessage()));
            }
            MultiFileRestorePanel.this.updateButtons();
        }
    }
}

