/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.wizard;

import de.dal33t.powerfolder.ConfigurationEntry;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.Member;
import de.dal33t.powerfolder.clientserver.ServerClient;
import de.dal33t.powerfolder.disk.Folder;
import de.dal33t.powerfolder.disk.FolderRepository;
import de.dal33t.powerfolder.disk.FolderSettings;
import de.dal33t.powerfolder.disk.SyncProfile;
import de.dal33t.powerfolder.light.FolderInfo;
import de.dal33t.powerfolder.light.FolderInfoFactory;
import de.dal33t.powerfolder.light.MemberInfo;
import de.dal33t.powerfolder.ui.wizard.FolderCreateItem;
import de.dal33t.powerfolder.ui.wizard.SendInvitationsPanel;
import de.dal33t.powerfolder.ui.wizard.SwingWorkerPanel;
import de.dal33t.powerfolder.util.PathUtils;
import de.dal33t.powerfolder.util.Reject;
import de.dal33t.powerfolder.util.StringUtils;
import de.dal33t.powerfolder.util.Translation;
import de.dal33t.powerfolder.util.UserDirectories;
import de.dal33t.powerfolder.util.os.Win32.ShellLink;
import de.dal33t.powerfolder.util.os.Win32.WinUtils;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import jwf.WizardPanel;

public class FolderCreatePanel
extends SwingWorkerPanel {
    private static final Logger log = Logger.getLogger(FolderCreatePanel.class.getName());
    private boolean sendInvitations;
    private final List<Folder> folders;

    public FolderCreatePanel(Controller controller) {
        super(controller, null, Translation.get("wizard.create_folder.title"), Translation.get("wizard.create_folder.working"), null);
        this.setTask(new MyFolderCreateWorker());
        this.folders = new ArrayList<Folder>();
    }

    @Override
    protected String getTitle() {
        return Translation.get("wizard.create_folder.title");
    }

    @Override
    public boolean hasNext() {
        return !this.folders.isEmpty();
    }

    @Override
    public WizardPanel next() {
        WizardPanel wizardPanel = this.sendInvitations ? new SendInvitationsPanel(this.getController()) : (WizardPanel)this.getWizardContext().getAttribute("successpanel");
        return wizardPanel;
    }

    private static FolderInfo createFolderInfo(Path path) {
        String string = PathUtils.getSuggestedFolderName(path);
        return FolderInfoFactory.newTopFolder(string);
    }

    private class MyFolderCreateWorker
    implements Runnable {
        private MyFolderCreateWorker() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void run() {
            Object object;
            Object object2;
            FolderInfo folderInfo;
            Object object4;
            Object object522;
            List list;
            HashMap<Object, FolderSettings> hashMap = new HashMap<Object, FolderSettings>();
            HashMap<FolderInfo, String> hashMap2 = new HashMap<FolderInfo, String>();
            Object object6 = FolderCreatePanel.this.getWizardContext().getAttribute("folder_create.backup_by_os");
            boolean bl = false;
            if (object6 != null && object6 instanceof Boolean) {
                bl = (Boolean)object6;
            }
            if (bl) {
                FolderCreatePanel.this.getController().getUIController().getApplicationModel().getServerClientModel().checkAndSetupAccount();
            }
            object6 = FolderCreatePanel.this.getWizardContext().getAttribute("disklocation.send_invitations");
            FolderCreatePanel.this.sendInvitations = false;
            if (object6 != null && object6 instanceof Boolean) {
                FolderCreatePanel.this.sendInvitations = (Boolean)object6;
            }
            if ((list = (List)FolderCreatePanel.this.getWizardContext().getAttribute("disklocation.folder_create_items")) != null && !list.isEmpty()) {
                for (Object object522 : list) {
                    void object32;
                    object4 = PathUtils.removeInvalidFilenameChars(((FolderCreateItem)object522).getLocalBase());
                    Reject.ifNull(object4, "Local base for folder is null/not set");
                    SyncProfile syncProfile = ((FolderCreateItem)object522).getSyncProfile();
                    if (syncProfile == null) {
                        SyncProfile syncProfile2 = SyncProfile.getDefault(FolderCreatePanel.this.getController());
                    }
                    if ((folderInfo = ((FolderCreateItem)object522).getFolderInfo()) == null) {
                        folderInfo = FolderCreatePanel.createFolderInfo(object4);
                    }
                    int n = ((FolderCreateItem)object522).getArchiveHistory();
                    if (!StringUtils.isBlank(((FolderCreateItem)object522).getLinkToOnlineFolder())) {
                        hashMap2.put(folderInfo, ((FolderCreateItem)object522).getLinkToOnlineFolder());
                    }
                    object2 = new FolderSettings((Path)object4, (SyncProfile)object32, null, n, true);
                    hashMap.put(folderInfo, (FolderSettings)object2);
                }
            } else {
                object = PathUtils.removeInvalidFilenameChars((Path)FolderCreatePanel.this.getWizardContext().getAttribute("disklocation.localbase"));
                Reject.ifNull(object, "Local base for folder is null/not set");
                object522 = (SyncProfile)FolderCreatePanel.this.getWizardContext().getAttribute("disklocation.sync_profile");
                if (object522 == null) {
                    object522 = SyncProfile.getDefault(FolderCreatePanel.this.getController());
                }
                if ((object4 = (FolderInfo)FolderCreatePanel.this.getWizardContext().getAttribute("disklocation.folder_info")) == null) {
                    object4 = FolderCreatePanel.createFolderInfo((Path)object);
                }
                FolderSettings folderSettings = new FolderSettings((Path)object, (SyncProfile)object522, null, ConfigurationEntry.DEFAULT_ARCHIVE_VERSIONS.getValueInt(FolderCreatePanel.this.getController()), true);
                hashMap.put(object4, folderSettings);
            }
            FolderCreatePanel.this.folders.clear();
            FolderCreatePanel.this.updateButtons();
            object = FolderCreatePanel.this.getController().getOSClient();
            object522 = ((ServerClient)object).getAccountFolders();
            for (Map.Entry entry : hashMap.entrySet()) {
                Object object3;
                Object object5;
                folderInfo = (FolderInfo)entry.getKey();
                FolderSettings folderSettings = (FolderSettings)entry.getValue();
                object2 = (String)hashMap2.get(folderInfo);
                Boolean bl2 = (Boolean)FolderCreatePanel.this.getWizardContext().getAttribute("folder.is.invite");
                if (object2 == null) {
                    boolean bl3;
                    if (!(bl2 != null && bl2.booleanValue() || (bl3 = ((ServerClient)object).getAccount().hasReadPermissions(folderInfo)))) {
                        object5 = object522.iterator();
                        while (object5.hasNext()) {
                            object3 = (FolderInfo)object5.next();
                            String string = ((FolderInfo)object3).getLocalizedName();
                            if (!string.equals(folderInfo.getName()) || ((FolderInfo)object3).equals(folderInfo)) continue;
                            log.info("Found online folder with same name: " + folderInfo.getName() + ". Using it");
                            folderInfo = object3;
                            log.info("Changed folder info to online version: " + folderInfo.getName());
                            break;
                        }
                    }
                } else {
                    boolean bl4 = false;
                    object5 = object522.iterator();
                    while (object5.hasNext()) {
                        object3 = (FolderInfo)object5.next();
                        if (!((FolderInfo)object3).getName().equals(object2)) continue;
                        log.info("Joining specified folder " + (String)object2);
                        folderInfo = object3;
                        bl4 = true;
                        break;
                    }
                    if (!bl4) {
                        log.warning("Could not find link folder " + (String)object2 + " for " + folderInfo);
                    }
                }
                Folder folder = FolderCreatePanel.this.getController().getFolderRepository().createFolder(folderInfo, folderSettings);
                folder.addDefaultExcludes();
                this.createShortcutToFolder(folderInfo, folderSettings);
                FolderCreatePanel.this.folders.add(folder);
                if (hashMap.size() == 1) {
                    FolderCreatePanel.this.getWizardContext().setAttribute("disklocation.folder_info", folder.getInfo());
                }
                if ((object6 = FolderCreatePanel.this.getWizardContext().getAttribute("make.friend.after")) != null && object6 instanceof MemberInfo) {
                    object5 = (MemberInfo)object6;
                    object3 = FolderCreatePanel.this.getController().getNodeManager().getNode((MemberInfo)object5);
                    if (object3 != null && !((Member)object3).isFriend()) {
                        ((Member)object3).setFriend(true, null);
                    }
                }
                if (!bl || !((ServerClient)object).isLoggedIn()) continue;
                if (((ServerClient)object).joinedByCloud(folder)) {
                    log.log(Level.WARNING, "Already have os folder " + folderInfo.getLocalizedName());
                    continue;
                }
                ((ServerClient)object).getFolderService().createFolder(folderInfo, null);
                FolderCreatePanel.this.getController().getFolderRepository().triggerSynchronizeAllFolderMemberships();
                object6 = FolderCreatePanel.this.getWizardContext().getAttribute("set_default_synced_folder");
                if (object6 == null || !((Boolean)object6).booleanValue()) continue;
                ((ServerClient)object).getFolderService().setDefaultSynchronizedFolder(folderInfo);
                this.createDefaultFolderHelpFile(folder);
                folder.recommendScanOnNextMaintenance();
                PathUtils.openFile(folder.getLocalBase());
            }
        }

        private void createShortcutToFolder(FolderInfo folderInfo, FolderSettings folderSettings) {
            Path path;
            FolderRepository folderRepository = FolderCreatePanel.this.getController().getFolderRepository();
            Path path2 = folderRepository.getFoldersBasedir();
            if (Files.notExists(path2, new LinkOption[0])) {
                log.info(String.format("Creating basedir: %s", path2.toAbsolutePath()));
                try {
                    Files.createDirectories(path2, new FileAttribute[0]);
                }
                catch (IOException iOException) {
                    log.info(iOException.getMessage());
                }
            }
            if (Files.exists(path = path2.resolve(folderInfo.getLocalizedName()), new LinkOption[0])) {
                log.finer("Folder is an existing subdirectory in basedir: " + path);
                return;
            }
            if (folderSettings.getLocalBaseDir().startsWith(path2)) {
                log.finer("Folder is an existing subdirectory in basedir: " + path);
                return;
            }
            Path path3 = path2.resolve(folderInfo.getLocalizedName() + ".lnk");
            String string = path3.toAbsolutePath().toString();
            String string2 = folderSettings.getLocalBaseDir().toAbsolutePath().toString();
            if (WinUtils.isSupported() && !UserDirectories.getUserDirectories(FolderCreatePanel.this.getController()).containsKey(folderInfo.getName())) {
                WinUtils winUtils = WinUtils.getInstance();
                ShellLink shellLink = new ShellLink(null, null, string2, null);
                try {
                    log.info(String.format("Attempting to create shortcut %s to %s", string, string2));
                    winUtils.createLink(shellLink, string);
                }
                catch (IOException iOException) {
                    log.warning(String.format("An exception was thrown when creating shortcut %s to %s", string, string2));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void createDefaultFolderHelpFile(Folder folder) {
            Path path = folder.getLocalBase().resolve("Place files to sync here.txt");
            if (Files.exists(path, new LinkOption[0])) {
                return;
            }
            Writer writer = null;
            try {
                writer = new OutputStreamWriter(Files.newOutputStream(path, new OpenOption[0]));
                writer.write("This is the default synchronized folder of PowerFolder.\r\n");
                writer.write("Simply place files into this directory to sync them\r\n");
                writer.write("across all your computers running PowerFolder.\r\n");
                writer.write("\r\n");
                writer.write("More information: http://wiki.powerfolder.com/wiki/Default_Folder");
                writer.close();
            }
            catch (IOException iOException) {
            }
            finally {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }
}

