/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.wizard;

import com.jgoodies.binding.adapter.BasicComponentFactory;
import com.jgoodies.binding.value.ValueHolder;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.dal33t.powerfolder.ConfigurationEntry;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.NetworkingMode;
import de.dal33t.powerfolder.transfer.TransferManager;
import de.dal33t.powerfolder.ui.panel.LineSpeedSelectionPanel;
import de.dal33t.powerfolder.ui.util.SimpleComponentFactory;
import de.dal33t.powerfolder.ui.util.UIUtil;
import de.dal33t.powerfolder.ui.wizard.DefaultFolderWizardHelper;
import de.dal33t.powerfolder.ui.wizard.PFWizardPanel;
import de.dal33t.powerfolder.util.Reject;
import de.dal33t.powerfolder.util.StringUtils;
import de.dal33t.powerfolder.util.Translation;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jwf.WizardPanel;

public class BasicSetupPanel
extends PFWizardPanel {
    private ValueModel nameModel;
    private ValueModel networkingModeModel;
    private LineSpeedSelectionPanel wanLineSpeed;
    private JTextField nameField;
    private JComboBox<Locale> languageChooser;
    private DefaultFolderWizardHelper defaultFolderHelper;
    private WizardPanel nextPanel;

    public BasicSetupPanel(Controller controller, WizardPanel wizardPanel) {
        super(controller);
        Reject.ifNull(wizardPanel, "Nextpanel is null");
        this.nextPanel = wizardPanel;
    }

    @Override
    public boolean hasNext() {
        return !StringUtils.isBlank((String)this.nameModel.getValue());
    }

    @Override
    protected JPanel buildContent() {
        FormLayout formLayout = new FormLayout("right:pref, 3dlu, 100dlu, pref:grow", "pref, 6dlu, pref, 6dlu, pref, 6dlu, top:pref");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        panelBuilder.setBorder(this.createFewContentBorder());
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.addLabel(Translation.get("exp.wizard.basic_setup.computer_name"), cellConstraints.xy(1, 1));
        panelBuilder.add((Component)this.nameField, cellConstraints.xy(3, 1));
        panelBuilder.addLabel(Translation.get("preferences.network.line_settings"), cellConstraints.xywh(1, 3, 1, 1, "default, top"));
        panelBuilder.add((Component)this.wanLineSpeed.getUiComponent(), cellConstraints.xy(3, 3));
        panelBuilder.addLabel(Translation.get("exp.wizard.basic_setup.language_restart"), cellConstraints.xy(1, 5));
        panelBuilder.add(this.languageChooser, cellConstraints.xy(3, 5));
        panelBuilder.add(this.defaultFolderHelper.getUIComponent(), cellConstraints.xyw(3, 7, 2));
        return panelBuilder.getPanel();
    }

    @Override
    public WizardPanel next() {
        String string = (String)this.nameModel.getValue();
        if (!StringUtils.isBlank(string)) {
            this.getController().changeNick(string, true);
        }
        boolean bl = this.networkingModeModel.getValue() instanceof PrivateNetworking;
        boolean bl2 = this.networkingModeModel.getValue() instanceof LanOnlyNetworking;
        if (bl) {
            this.getController().setNetworkingMode(NetworkingMode.PRIVATEMODE);
        } else if (bl2) {
            this.getController().setNetworkingMode(NetworkingMode.LANONLYMODE);
        } else {
            throw new IllegalStateException("invalid net working mode");
        }
        TransferManager transferManager = this.getController().getTransferManager();
        transferManager.setUploadCPSForWAN(this.wanLineSpeed.getUploadSpeedKBPS());
        transferManager.setDownloadCPSForWAN(this.wanLineSpeed.getDownloadSpeedKBPS());
        if (this.languageChooser.getSelectedItem() instanceof Locale) {
            Locale locale = (Locale)this.languageChooser.getSelectedItem();
            Translation.saveLocalSetting(locale);
        } else {
            Translation.saveLocalSetting(null);
        }
        if (this.getController().getOSClient().isLoggedIn() || this.getController().isLanOnly()) {
            return this.defaultFolderHelper.next(this.nextPanel, this.getWizardContext());
        }
        return this.nextPanel;
    }

    @Override
    protected void initComponents() {
        this.nameModel = new ValueHolder(this.getController().getMySelf().getNick());
        this.nameModel.addValueChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                BasicSetupPanel.this.updateButtons();
            }
        });
        this.languageChooser = BasicSetupPanel.createLanguageChooser();
        this.nameField = BasicComponentFactory.createTextField(this.nameModel, false);
        UIUtil.ensureMinimumWidth(107, this.nameField);
        this.wanLineSpeed = new LineSpeedSelectionPanel(this.getController(), true, false);
        TransferManager transferManager = this.getController().getTransferManager();
        this.wanLineSpeed.setSpeedKBPS(ConfigurationEntry.TRANSFER_LIMIT_AUTODETECT.getValueBoolean(this.getController()), transferManager.getUploadCPSForWAN() / 1024L, transferManager.getDownloadCPSForWAN() / 1024L);
        this.networkingModeModel = new ValueHolder();
        JComboBox jComboBox = SimpleComponentFactory.createComboBox(this.networkingModeModel);
        jComboBox.addItem(new PrivateNetworking());
        jComboBox.addItem(new LanOnlyNetworking());
        NetworkingMode networkingMode = this.getController().getNetworkingMode();
        switch (networkingMode) {
            case PRIVATEMODE: {
                jComboBox.setSelectedIndex(0);
                break;
            }
            case LANONLYMODE: {
                jComboBox.setSelectedIndex(1);
            }
        }
        this.wanLineSpeed.setEnabled(jComboBox.getSelectedItem() instanceof PrivateNetworking);
        jComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                BasicSetupPanel.this.wanLineSpeed.setEnabled(itemEvent.getItem() instanceof PrivateNetworking);
            }
        });
        this.defaultFolderHelper = new DefaultFolderWizardHelper(this.getController(), this.getController().getOSClient());
    }

    @Override
    protected String getTitle() {
        return Translation.get("exp.wizard.basic_setup.title");
    }

    private static JComboBox<Locale> createLanguageChooser() {
        JComboBox<Locale> jComboBox = new JComboBox<Locale>();
        for (Locale locale : Translation.getSupportedLocales()) {
            jComboBox.addItem(locale);
        }
        jComboBox.setSelectedItem(Translation.getResourceBundle().getLocale());
        jComboBox.setRenderer(new MyDefaultListCellRenderer());
        jComboBox.setSelectedItem(Translation.getActiveLocale());
        return jComboBox;
    }

    private static class PrivateNetworking {
        private PrivateNetworking() {
        }

        public String toString() {
            return Translation.get("general.network_mode.private");
        }
    }

    private static class LanOnlyNetworking {
        private LanOnlyNetworking() {
        }

        public String toString() {
            return Translation.get("general_network_mode.lan_only");
        }
    }

    private static class MyDefaultListCellRenderer
    extends DefaultListCellRenderer {
        private MyDefaultListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            if (object instanceof Locale) {
                Locale locale = (Locale)object;
                this.setText(locale.getDisplayName(locale));
            } else {
                this.setText("- unknown -");
            }
            return this;
        }
    }
}

