/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.widget;

import com.jgoodies.forms.factories.Borders;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.PFComponent;
import de.dal33t.powerfolder.PreferencesEntry;
import de.dal33t.powerfolder.ui.util.ColorUtil;
import de.dal33t.powerfolder.ui.util.CursorUtils;
import de.dal33t.powerfolder.ui.util.Icons;
import de.dal33t.powerfolder.ui.util.UIUtil;
import de.dal33t.powerfolder.util.BrowserLauncher;
import de.dal33t.powerfolder.util.StringUtils;
import java.awt.Color;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JLabel;

public class LinkLabel
extends PFComponent {
    private static final Logger log = Logger.getLogger(LinkLabel.class.getName());
    private String url;
    private JLabel uiComponent;
    private String text;
    private volatile boolean mouseOver;

    public LinkLabel(Controller controller, String string, String string2) {
        super(controller);
        this.text = string;
        this.url = string2;
        this.uiComponent = new JLabel();
        this.setText();
        this.uiComponent.addMouseListener(new MyMouseAdapter());
        CursorUtils.setHandCursor(this.uiComponent);
        this.uiComponent.setBorder(Borders.createEmptyBorder("0, 1px, 0, 0"));
    }

    public void setText(String string) {
        this.text = string;
        this.setText();
    }

    public void setTextAndURL(String string, String string2) {
        this.text = string;
        this.url = string2;
        this.setText();
    }

    public void setForeground(Color color) {
        this.uiComponent.setForeground(color);
    }

    public void setIcon(Icon icon) {
        this.uiComponent.setIcon(icon);
    }

    public void convertToBigLabel() {
        this.uiComponent.setIcon(Icons.getIconById("arrow_right.icon"));
        UIUtil.setFontSize(this.uiComponent, 15);
    }

    public JLabel getUIComponent() {
        return this.uiComponent;
    }

    private void setText() {
        if (StringUtils.isBlank(this.text)) {
            this.uiComponent.setText(null);
            return;
        }
        if (this.mouseOver || PreferencesEntry.UNDERLINE_LINKS.getValueBoolean(this.getController()).booleanValue()) {
            Color color = ColorUtil.getTextForegroundColor();
            String string = ColorUtil.getRgbForColor(color);
            if (StringUtils.isBlank(this.url)) {
                this.uiComponent.setText("<html><font color=\"" + string + "\"><a href=\".\">" + this.text + "</a></font></html>");
            } else {
                this.uiComponent.setText("<html><font color=\"" + string + "\"><a href=\"" + this.url + "\">" + this.text + "</a></font></html>");
            }
        } else {
            this.uiComponent.setText(this.text);
        }
    }

    public void setToolTipText(String string) {
        this.uiComponent.setToolTipText(string);
    }

    public void setVisible(boolean bl) {
        this.uiComponent.setVisible(bl);
    }

    private class MyMouseAdapter
    extends MouseAdapter {
        private MyMouseAdapter() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (StringUtils.isBlank(LinkLabel.this.url)) {
                return;
            }
            BrowserLauncher.openURL(LinkLabel.this.getController(), LinkLabel.this.url);
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            LinkLabel.this.mouseOver = true;
            LinkLabel.this.setText();
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            LinkLabel.this.mouseOver = false;
            LinkLabel.this.setText();
        }
    }
}

