/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.widget;

import com.jgoodies.binding.adapter.BasicComponentFactory;
import com.jgoodies.binding.value.ValueHolder;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.Member;
import de.dal33t.powerfolder.PFComponent;
import de.dal33t.powerfolder.PreferencesEntry;
import de.dal33t.powerfolder.ui.util.Icons;
import de.dal33t.powerfolder.ui.util.SimpleComponentFactory;
import de.dal33t.powerfolder.ui.widget.JButton3Icons;
import de.dal33t.powerfolder.util.Translation;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;

public class FileFilterTextField
extends PFComponent {
    private JPanel panel;
    private JTextField textField;
    private JButton clearTextJButton;
    private JLabel glassIcon;
    private ValueModel externalSearchTextValueModel;
    private ValueModel externalSearchModeValueModel;
    private ValueModel localValueModel = new ValueHolder();
    private boolean focus;
    private JPopupMenu contextMenu;
    private ButtonGroup buttonGroup;
    private JRadioButtonMenuItem fileNameDirectoryNameRBMI;
    private JRadioButtonMenuItem fileNameOnlyRBMI;
    private JRadioButtonMenuItem modifierRBMI;
    private Map<Member, JRadioButtonMenuItem> computerButtons;
    private MyActionListener popupMenuListener;
    private boolean currentlyMemberMode;
    private boolean previouslyMemberMode;

    public FileFilterTextField(Controller controller) {
        super(controller);
        this.externalSearchTextValueModel = new ValueHolder();
        this.externalSearchModeValueModel = new ValueHolder();
        this.externalSearchModeValueModel.setValue(PreferencesEntry.FILE_SEARCH_MODE.getValueInt(controller));
        this.computerButtons = new ConcurrentHashMap<Member, JRadioButtonMenuItem>();
        this.buttonGroup = new ButtonGroup();
    }

    public ValueModel getSearchTextValueModel() {
        return this.externalSearchTextValueModel;
    }

    public ValueModel getSearchModeValueModel() {
        return this.externalSearchModeValueModel;
    }

    public JPanel getUIComponent() {
        if (this.panel == null) {
            this.initComponents();
            FormLayout formLayout = new FormLayout("pref, 1dlu, pref:grow, 15dlu", "pref");
            PanelBuilder panelBuilder = new PanelBuilder(formLayout);
            CellConstraints cellConstraints = new CellConstraints();
            panelBuilder.add((Component)this.glassIcon, cellConstraints.xy(1, 1));
            panelBuilder.add((Component)this.textField, cellConstraints.xy(3, 1));
            panelBuilder.add((Component)this.clearTextJButton, cellConstraints.xy(4, 1, CellConstraints.RIGHT, CellConstraints.DEFAULT));
            panelBuilder.setBorder(new EtchedBorder());
            this.panel = panelBuilder.getPanel();
            this.panel.setBackground(Color.white);
        }
        return this.panel;
    }

    public void reset() {
        this.textField.setText("");
        this.externalSearchTextValueModel.setValue("");
    }

    private void initComponents() {
        this.textField = BasicComponentFactory.createTextField(this.localValueModel, false);
        this.textField.setColumns(15);
        this.textField.setBorder(null);
        this.textField.setPreferredSize(new Dimension(17, 17));
        this.textField.setToolTipText(Translation.get("filter_text_field.tip"));
        this.clearTextJButton = new JButton3Icons(Icons.getIconById("filter_text_field_clear_button_normal.icon"), Icons.getIconById("filter_text_field_clear_button_hover.icon"), Icons.getIconById("filter_text_field_clear_button_push.icon"));
        this.clearTextJButton.setVisible(false);
        this.clearTextJButton.setToolTipText(Translation.get("filter_text_field.clear.hint"));
        this.clearTextJButton.setContentAreaFilled(false);
        this.clearTextJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FileFilterTextField.this.textField.setText("");
                FileFilterTextField.this.externalSearchTextValueModel.setValue("");
                FileFilterTextField.this.textField.requestFocus();
            }
        });
        this.glassIcon = SimpleComponentFactory.createLabel(Icons.getIconById("filter_text_field_glass_arrow.icon"));
        this.glassIcon.setToolTipText(Translation.get("filter_text_field.glass.hint"));
        this.glassIcon.addMouseListener(new MyMouseListener());
        this.localValueModel.addValueChangeListener(new MyPropertyChangeListener());
        MyFocusListener myFocusListener = new MyFocusListener();
        this.clearTextJButton.addFocusListener(myFocusListener);
        this.textField.addFocusListener(myFocusListener);
        this.updateForFocus();
    }

    private void updateForFocus() {
        boolean bl = this.focus = this.clearTextJButton.hasFocus() || this.textField.hasFocus();
        if (!this.hasExternalText()) {
            if (this.focus && !this.currentlyMemberMode) {
                this.textField.setText("");
                this.textField.setForeground(SystemColor.textText);
            } else {
                this.textField.setForeground(Color.lightGray);
                int n = (Integer)this.externalSearchModeValueModel.getValue();
                if (n == 11) {
                    this.textField.setText(Translation.get("filter_text_field.menu.file_name_only.text"));
                } else if (n == 10) {
                    this.textField.setText(Translation.get("filter_text_field.menu.file_name_directory_name.text"));
                } else if (n == 12) {
                    this.textField.setText(Translation.get("filter_text_field.menu.modifier.text"));
                }
            }
        }
    }

    private boolean hasExternalText() {
        return this.externalSearchTextValueModel.getValue() != null && ((CharSequence)this.externalSearchTextValueModel.getValue()).length() > 0;
    }

    public JPopupMenu createPopupMenu() {
        if (this.contextMenu == null) {
            this.popupMenuListener = new MyActionListener();
            this.contextMenu = new JPopupMenu();
            Integer n = PreferencesEntry.FILE_SEARCH_MODE.getValueInt(this.getController());
            this.fileNameDirectoryNameRBMI = new JRadioButtonMenuItem(Translation.get("filter_text_field.menu.file_name_directory_name.text"));
            this.fileNameDirectoryNameRBMI.addActionListener(this.popupMenuListener);
            this.fileNameDirectoryNameRBMI.setSelected(n == 10);
            this.fileNameOnlyRBMI = new JRadioButtonMenuItem(Translation.get("filter_text_field.menu.file_name_only.text"));
            this.fileNameOnlyRBMI.addActionListener(this.popupMenuListener);
            this.fileNameOnlyRBMI.setSelected(n == 11);
            this.modifierRBMI = new JRadioButtonMenuItem(Translation.get("filter_text_field.menu.modifier.text"));
            this.modifierRBMI.addActionListener(this.popupMenuListener);
            this.modifierRBMI.setSelected(n == 12);
            this.buttonGroup.add(this.fileNameDirectoryNameRBMI);
            this.buttonGroup.add(this.fileNameOnlyRBMI);
            this.buttonGroup.add(this.modifierRBMI);
            this.contextMenu.add(this.fileNameDirectoryNameRBMI);
            this.contextMenu.add(this.fileNameOnlyRBMI);
            this.contextMenu.add(this.modifierRBMI);
        }
        return this.contextMenu;
    }

    public void setMembers(Collection<Member> collection) {
        if (collection == null || collection.isEmpty()) {
            for (JRadioButtonMenuItem jRadioButtonMenuItem : this.computerButtons.values()) {
                jRadioButtonMenuItem.removeActionListener(this.popupMenuListener);
                this.buttonGroup.remove(jRadioButtonMenuItem);
                if (jRadioButtonMenuItem.isSelected()) {
                    this.fileNameDirectoryNameRBMI.setSelected(true);
                    this.textField.setText("");
                }
                this.createPopupMenu().remove(jRadioButtonMenuItem);
            }
            this.computerButtons.clear();
        } else {
            Object object;
            for (Map.Entry<Member, JRadioButtonMenuItem> object2 : this.computerButtons.entrySet()) {
                object = object2.getKey();
                JRadioButtonMenuItem jRadioButtonMenuItem = object2.getValue();
                if (collection.contains(object)) continue;
                jRadioButtonMenuItem.removeActionListener(this.popupMenuListener);
                this.buttonGroup.remove(jRadioButtonMenuItem);
                this.createPopupMenu().remove(jRadioButtonMenuItem);
                this.computerButtons.remove(object);
                if (jRadioButtonMenuItem.isSelected()) {
                    this.fileNameDirectoryNameRBMI.setSelected(true);
                    this.textField.setText("");
                    this.externalSearchModeValueModel.setValue(11);
                    this.externalSearchTextValueModel.setValue("");
                    this.textField.setEnabled(true);
                    this.updateForFocus();
                }
                if (!this.isFine()) continue;
                this.logFine("Removed " + ((Member)object).getNick());
            }
            for (Member member : collection) {
                if (this.computerButtons.keySet().contains(member)) continue;
                object = new JRadioButtonMenuItem(Translation.get("filter_text_field.menu.computer.text", member.getNick()));
                this.computerButtons.put(member, (JRadioButtonMenuItem)object);
                this.buttonGroup.add((AbstractButton)object);
                this.createPopupMenu().add((JMenuItem)object);
                ((AbstractButton)object).addActionListener(this.popupMenuListener);
                if (!this.isFine()) continue;
                this.logFine("Added " + member.getNick());
            }
        }
    }

    private class MyMouseListener
    extends MouseAdapter {
        private MyMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            this.showContextMenu(mouseEvent);
        }

        private void showContextMenu(MouseEvent mouseEvent) {
            FileFilterTextField.this.createPopupMenu().show(mouseEvent.getComponent(), FileFilterTextField.this.glassIcon.getX(), FileFilterTextField.this.glassIcon.getY() + FileFilterTextField.this.glassIcon.getHeight());
        }
    }

    private class MyPropertyChangeListener
    implements PropertyChangeListener {
        private MyPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (FileFilterTextField.this.focus) {
                FileFilterTextField.this.externalSearchTextValueModel.setValue(FileFilterTextField.this.localValueModel.getValue());
            }
            boolean bl = FileFilterTextField.this.hasExternalText();
            FileFilterTextField.this.clearTextJButton.setVisible(bl && !FileFilterTextField.this.currentlyMemberMode);
        }
    }

    private class MyFocusListener
    extends FocusAdapter {
        private MyFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            FileFilterTextField.this.updateForFocus();
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            FileFilterTextField.this.updateForFocus();
        }
    }

    private class MyActionListener
    implements ActionListener {
        private MyActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            FileFilterTextField.this.previouslyMemberMode = FileFilterTextField.this.currentlyMemberMode;
            if (actionEvent.getSource() == FileFilterTextField.this.fileNameOnlyRBMI) {
                this.setMode(10);
            } else if (actionEvent.getSource() == FileFilterTextField.this.fileNameDirectoryNameRBMI) {
                this.setMode(11);
            } else if (actionEvent.getSource() == FileFilterTextField.this.modifierRBMI) {
                this.setMode(12);
            } else {
                FileFilterTextField.this.currentlyMemberMode = true;
                for (Map.Entry entry : FileFilterTextField.this.computerButtons.entrySet()) {
                    if (entry.getValue() != actionEvent.getSource()) continue;
                    FileFilterTextField.this.externalSearchModeValueModel.setValue(13);
                    FileFilterTextField.this.externalSearchTextValueModel.setValue(((Member)entry.getKey()).getId());
                    FileFilterTextField.this.textField.setEnabled(false);
                    FileFilterTextField.this.textField.setText(Translation.get("filter_text_field.menu.computer.text", ((Member)entry.getKey()).getNick()));
                }
            }
            if (!FileFilterTextField.this.currentlyMemberMode) {
                PreferencesEntry.FILE_SEARCH_MODE.setValue(FileFilterTextField.this.getController(), (Integer)FileFilterTextField.this.externalSearchModeValueModel.getValue());
            }
            FileFilterTextField.this.updateForFocus();
        }

        private void setMode(int n) {
            FileFilterTextField.this.externalSearchModeValueModel.setValue(n);
            FileFilterTextField.this.textField.setEnabled(true);
            FileFilterTextField.this.currentlyMemberMode = false;
            if (FileFilterTextField.this.previouslyMemberMode) {
                FileFilterTextField.this.textField.setText("");
                FileFilterTextField.this.externalSearchTextValueModel.setValue("");
                FileFilterTextField.this.textField.setForeground(SystemColor.textText);
                FileFilterTextField.this.clearTextJButton.setVisible(false);
                FileFilterTextField.this.textField.transferFocus();
            }
        }
    }
}

