/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.util.update;

import de.dal33t.powerfolder.ConfigurationEntry;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.PreferencesEntry;
import de.dal33t.powerfolder.ui.PFUIComponent;
import de.dal33t.powerfolder.ui.dialog.DialogFactory;
import de.dal33t.powerfolder.ui.dialog.DownloadUpdateDialog;
import de.dal33t.powerfolder.ui.dialog.GenericDialogType;
import de.dal33t.powerfolder.ui.util.UIUtil;
import de.dal33t.powerfolder.util.BrowserLauncher;
import de.dal33t.powerfolder.util.Translation;
import de.dal33t.powerfolder.util.os.OSUtil;
import de.dal33t.powerfolder.util.update.UpdaterEvent;
import de.dal33t.powerfolder.util.update.UpdaterHandler;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class UIUpdateHandler
extends PFUIComponent
implements UpdaterHandler {
    private static volatile boolean updateDialogOpen = false;
    private Object option;

    public UIUpdateHandler(Controller controller) {
        super(controller);
    }

    @Override
    public void newReleaseAvailable(UpdaterEvent updaterEvent) {
        this.getController().waitForUIOpen();
        final String string = Translation.get("dialog.update_check.text", "26.0.100", updaterEvent.getNewReleaseVersion());
        final ArrayList<String> arrayList = new ArrayList<String>(4);
        String string2 = Translation.get("dialog.update_check.downloadAndUpdateSilent");
        String string3 = Translation.get("dialog.update_check.downloadAndUpdate");
        String string4 = Translation.get("dialog.update_check.gotoHomepage");
        String string5 = Translation.get("dialog.update_check.nothingNeverAsk");
        boolean bl = ConfigurationEntry.UPDATE_SILENT_ALLOWED.getValueBoolean(this.getController());
        if (bl && ConfigurationEntry.AUTO_UPDATE.getValueBoolean(this.getController()).booleanValue()) {
            this.option = string2;
        } else {
            if (OSUtil.isWindowsSystem()) {
                arrayList.add(string3);
                if (bl) {
                    arrayList.add(string2);
                }
            }
            arrayList.add(string4);
            arrayList.add(string5);
            updateDialogOpen = true;
            try {
                if (OSUtil.isWindowsSystem() && ConfigurationEntry.UPDATE_FORCE.getValueBoolean(this.getController()).booleanValue()) {
                    UIUtil.invokeAndWaitInEDT(new Runnable(){

                        @Override
                        public void run() {
                            Object[] objectArray = new Object[]{"OK"};
                            JOptionPane.showOptionDialog(UIUpdateHandler.this.getParentFrame(), string, Translation.get("dialog.update_check.title"), -1, 3, null, objectArray, objectArray[0]);
                        }
                    });
                    this.option = string3;
                } else {
                    UIUtil.invokeAndWaitInEDT(new Runnable(){

                        @Override
                        public void run() {
                            UIUpdateHandler.this.option = JOptionPane.showInputDialog(UIUpdateHandler.this.getParentFrame(), string, Translation.get("dialog.update_check.title"), 2, null, arrayList.toArray(), arrayList.get(0));
                        }
                    });
                }
            }
            catch (InterruptedException interruptedException) {
                this.logFiner(interruptedException);
                return;
            }
            updateDialogOpen = false;
        }
        if (this.option == string3 || this.option == string2) {
            boolean bl2 = this.option == string2;
            URL uRL = updaterEvent.getNewWindowsExeURL();
            if (uRL == null) {
                return;
            }
            this.getController().getUIController().closePreferencesDialog();
            DownloadUpdateDialog downloadUpdateDialog = new DownloadUpdateDialog(this.getController(), updaterEvent.getNewReleaseVersion());
            downloadUpdateDialog.openInEDT();
            boolean bl3 = updaterEvent.getUpdater().downloadAndUpdate(uRL, downloadUpdateDialog.getStreamCallback(), bl2) != null;
            downloadUpdateDialog.close();
            if (!bl3) {
                try {
                    UIUtil.invokeAndWaitInEDT(new Runnable(){

                        @Override
                        public void run() {
                            DialogFactory.genericDialog(UIUpdateHandler.this.getController(), Translation.get("dialog.update_check.failed.title"), Translation.get("dialog.update_check.failed.text"), GenericDialogType.WARN);
                        }
                    });
                }
                catch (InterruptedException interruptedException) {
                    this.logFiner(interruptedException);
                }
            }
        } else if (this.option == string4) {
            BrowserLauncher.openURL(this.getController(), ConfigurationEntry.PROVIDER_URL.getValue(this.getController()));
        } else if (this.option == string5) {
            PreferencesEntry.CHECK_UPDATE.setValue(this.getController(), false);
        }
    }

    @Override
    public void noNewReleaseAvailable(UpdaterEvent updaterEvent) {
    }

    @Override
    public boolean shouldCheckForNewVersion() {
        return !updateDialogOpen && PreferencesEntry.CHECK_UPDATE.getValueBoolean(this.getController()) != false;
    }

    protected JFrame getParentFrame() {
        return this.getUIController().getMainFrame().getUIComponent();
    }
}

