/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.util;

import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.looks.HeaderStyle;
import de.dal33t.powerfolder.ui.widget.AntialiasedLabel;
import java.awt.Font;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.JToolBar;

public class SimpleComponentFactory {
    public static final int BIG_FONT_SIZE = 15;
    public static final int BIGGER_FONT_SIZE = 20;

    private SimpleComponentFactory() {
    }

    public static JTextField createTextField(boolean bl) {
        JTextField jTextField = new JTextField();
        jTextField.setEditable(bl);
        return jTextField;
    }

    public static JPasswordField createPasswordField() {
        return new JPasswordField();
    }

    public static JLabel createLabel() {
        return new JLabel();
    }

    public static JLabel createLabel(String string) {
        return new JLabel(string);
    }

    public static JLabel createLabel(Icon icon) {
        return new JLabel(icon);
    }

    public static JLabel createBigTextLabel(String string) {
        AntialiasedLabel antialiasedLabel = new AntialiasedLabel(string);
        SimpleComponentFactory.setFontSize(antialiasedLabel, 15);
        return antialiasedLabel;
    }

    public static JLabel createBiggerTextLabel(String string) {
        AntialiasedLabel antialiasedLabel = new AntialiasedLabel(string);
        SimpleComponentFactory.setFontSize(antialiasedLabel, 20);
        return antialiasedLabel;
    }

    public static void setFontSize(JLabel jLabel, int n) {
        Font font = new Font(jLabel.getFont().getFontName(), 0, n);
        jLabel.setFont(font);
    }

    public static void setFont(JLabel jLabel, int n, int n2) {
        Font font = new Font(jLabel.getFont().getFontName(), n2, n);
        jLabel.setFont(font);
    }

    public static JCheckBox createCheckBox(String string) {
        return new JCheckBox(string);
    }

    public static JPopupMenu createPopupMenu() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.putClientProperty("jgoodies.headerStyle", HeaderStyle.BOTH);
        return jPopupMenu;
    }

    public static JToolBar createToolBar() {
        JToolBar jToolBar = new JToolBar();
        return jToolBar;
    }

    public static JComboBox createComboBox(final ValueModel valueModel) {
        if (valueModel == null) {
            throw new NullPointerException("Model is null");
        }
        JComboBox jComboBox = new JComboBox();
        jComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    valueModel.setValue(itemEvent.getItem());
                }
            }
        });
        return jComboBox;
    }
}

